/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompiler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClosureCompilerImpl
implements ClosureCompiler {
    private ClassFileLoader loader;
    private Collection closure = new HashSet();
    private HashSet visited = new HashSet();
    private Stack callStack = new Stack();
    private Map failed = new HashMap();
    private HashSet excludedClasses = new HashSet();
    private HashSet excludedPackages = new HashSet();
    private HashSet excludedPatterns = new HashSet();
    private static Logger logger = Logger.getLogger("apiscan.classfile");
    private static final String myClassName = "ClosureCompilerImpl";

    public ClosureCompilerImpl(ClassFileLoader loader) {
        this.loader = loader;
    }

    public void addExcludedClass(String externalName) {
        this.excludedClasses.add(externalName);
    }

    public void addExcludedPackage(String externalName) {
        this.excludedPackages.add(externalName);
    }

    public void addExcludedPattern(String pattern) {
        this.excludedPatterns.add(pattern);
    }

    public boolean buildClosure(String externalClsName) {
        ClassFile cf;
        logger.entering(myClassName, "buildClosure", externalClsName);
        if (!this.needToAdd(externalClsName)) {
            return true;
        }
        try {
            cf = this.loader.load(externalClsName);
        }
        catch (IOException e) {
            this.handleFailure(externalClsName);
            return false;
        }
        return this.buildClosure(cf);
    }

    public boolean buildClosure(JarFile jar) throws IOException {
        boolean result = true;
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String clsName = entries.nextElement().getName();
            if (!clsName.endsWith(".class")) continue;
            String externalClsName = clsName.substring(0, clsName.lastIndexOf(".class")).replace('/', '.');
            boolean newresult = this.buildClosure(externalClsName);
            result = newresult && result;
        }
        return result;
    }

    public boolean buildClosure(ClassFile cf) {
        boolean result = true;
        this.callStack.push(cf);
        if (this.needToAdd(cf.getName())) {
            this.visited.add(cf.getName());
            Collection names = cf.getAllReferencedClassNames();
            this.closure.addAll(names);
            Iterator i = names.iterator();
            while (i.hasNext()) {
                ClassFile next;
                String nextExternalName = (String)i.next();
                if (!this.needToAdd(nextExternalName)) continue;
                try {
                    next = this.loader.load(nextExternalName);
                }
                catch (IOException e) {
                    result = false;
                    this.handleFailure(nextExternalName);
                    continue;
                }
                boolean newresult = this.buildClosure(next);
                result = newresult && result;
            }
        }
        this.callStack.pop();
        return result;
    }

    private void handleFailure(String referencedClass) {
        String referencingPath = "";
        try {
            ClassFile top = (ClassFile)this.callStack.peek();
            String referencingClass = top.getName();
            StringBuffer referencingPathBuffer = new StringBuffer();
            Iterator i = this.callStack.iterator();
            while (i.hasNext()) {
                if (referencingPathBuffer.length() != 0) {
                    referencingPathBuffer.append(File.separator);
                }
                referencingPathBuffer.append(((ClassFile)i.next()).getName());
            }
            referencingPath = referencingPathBuffer.toString();
        }
        catch (EmptyStackException e) {
            // empty catch block
        }
        logger.finer("Could not locate " + referencingPath + File.separator + referencedClass);
        ArrayList<String> failedList = (ArrayList<String>)this.failed.get(referencingPath);
        if (failedList == null) {
            failedList = new ArrayList<String>();
            this.failed.put(referencingPath, failedList);
        }
        failedList.add(referencedClass);
    }

    public Collection getClosure() {
        return Collections.unmodifiableCollection(this.closure);
    }

    public Map getFailed() {
        return Collections.unmodifiableMap(this.failed);
    }

    public void reset() {
        this.closure.clear();
        this.visited.clear();
        this.failed.clear();
    }

    protected boolean needToAdd(String externalName) {
        boolean result = true;
        if (this.visited.contains(externalName)) {
            result = false;
        } else if (this.excludedClasses.contains(externalName)) {
            result = false;
        } else if (this.excludedPackages.contains(ClosureCompilerImpl.getPackageName(externalName))) {
            result = false;
        } else {
            Iterator i = this.excludedPatterns.iterator();
            while (i.hasNext()) {
                String pattern = (String)i.next();
                if (!externalName.startsWith(pattern)) continue;
                result = false;
                break;
            }
        }
        logger.logp(Level.FINEST, myClassName, "needToAdd", externalName + " " + result);
        return result;
    }

    private static String getPackageName(String externalClassName) {
        int idx = externalClassName.lastIndexOf(46);
        if (idx != -1) {
            return externalClassName.substring(0, idx);
        }
        return "";
    }

    public String toString() {
        Iterator i;
        StringBuffer sb = new StringBuffer();
        if (logger.getLevel() == Level.FINER) {
            sb.append("\n");
            sb.append("ExcludedClasses");
            sb.append(" [ ");
            i = this.excludedClasses.iterator();
            while (i.hasNext()) {
                sb.append((String)((Object)i.next())).append("\t");
            }
            sb.append(" ] ");
            sb.append("\n");
            sb.append("ExcludedPackages");
            sb.append(" [ ");
            i = this.excludedPackages.iterator();
            while (i.hasNext()) {
                sb.append("\n");
                sb.append((String)((Object)i.next()));
            }
            sb.append(" ] ");
            sb.append("\n");
            sb.append("ExcludedPatterns");
            sb.append(" [ ");
            i = this.excludedPatterns.iterator();
            while (i.hasNext()) {
                sb.append("\n");
                sb.append((String)((Object)i.next()));
            }
            sb.append(" ] ");
            sb.append("\n");
            sb.append("Classes");
            sb.append(" [ ");
            i = this.closure.iterator();
            while (i.hasNext()) {
                sb.append("\n");
                sb.append((String)((Object)i.next()));
            }
            sb.append(" ] ");
        }
        sb.append("\n\n");
        i = this.failed.entrySet().iterator();
        while (i.hasNext()) {
            LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
            String classes = "classes [ ";
            String reference = "referenced by [ ";
            String notFound = "are not found";
            if (smh != null) {
                classes = smh.getLocalString((class$com$sun$enterprise$tools$verifier$apiscan$classfile$ClosureCompilerImpl == null ? ClosureCompilerImpl.class$("com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImpl") : class$com$sun$enterprise$tools$verifier$apiscan$classfile$ClosureCompilerImpl).getName() + ".classes", "classes [ ");
                reference = smh.getLocalString((class$com$sun$enterprise$tools$verifier$apiscan$classfile$ClosureCompilerImpl == null ? ClosureCompilerImpl.class$("com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImpl") : class$com$sun$enterprise$tools$verifier$apiscan$classfile$ClosureCompilerImpl).getName() + ".reference", "referenced by [ ");
                notFound = smh.getLocalString((class$com$sun$enterprise$tools$verifier$apiscan$classfile$ClosureCompilerImpl == null ? ClosureCompilerImpl.class$("com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImpl") : class$com$sun$enterprise$tools$verifier$apiscan$classfile$ClosureCompilerImpl).getName() + ".notFound", "are not found");
            }
            Map.Entry referencingPathToFailedList = i.next();
            sb.append(classes);
            Iterator iii = ((List)referencingPathToFailedList.getValue()).iterator();
            while (iii.hasNext()) {
                sb.append((String)iii.next());
                sb.append(" ");
            }
            sb.append("] ");
            sb.append(reference);
            String referencingPath = (String)referencingPathToFailedList.getKey();
            sb.append(referencingPath.substring(referencingPath.lastIndexOf("/") + 1));
            sb.append("] ");
            sb.append(notFound);
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage : java " + ClosureCompilerImpl.class.getName() + " <external class name(s) e.g. java/util/Map$Entry");
            return;
        }
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        logger.addHandler(h);
        logger.setLevel(Level.ALL);
        String cp = "";
        cp = cp + "/net/eas201/workspace/ss141213/compiler/api_scan/bcel/bcel1/build/test/classes";
        System.out.println("Uisng classpath " + cp);
        ClassFileLoader cfl = ClassFileLoaderFactory.newInstance(new Object[]{cp});
        ClosureCompilerImpl closure = new ClosureCompilerImpl(cfl);
        closure.addExcludedPattern("java.");
        closure.addExcludedPattern("sun.");
        closure.addExcludedPattern("org.");
        for (int i = 0; i < args.length; ++i) {
            String clsName = args[i];
            System.out.println("Building closure for " + clsName);
            closure.reset();
            closure.buildClosure(clsName);
            System.out.println("The closure is [\n");
            System.out.println(closure);
            System.out.println("\n]");
        }
    }
}

