/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.apiscan.classfile.BCELClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassFileLoaderFactory {
    private static Logger logger = Logger.getLogger("apiscan.classfile");
    private static final String myClassName = "ClassFileLoaderFactory";

    public static ClassFileLoader newInstance(Object[] args) throws RuntimeException {
        logger.entering(myClassName, "newInstance", args);
        String loaderClassName = System.getProperty("apiscan.ClassFileLoader");
        if (loaderClassName == null) {
            loaderClassName = BCELClassFileLoader.class.getName();
            logger.logp(Level.FINE, myClassName, "newInstance", "System Property apiscan.ClassFileLoader is null, so defaulting to " + loaderClassName);
        }
        try {
            Class<?> clazz = Class.forName(loaderClassName);
            Object o = null;
            Constructor<?>[] constrs = clazz.getConstructors();
            for (int i = 0; i < constrs.length; ++i) {
                try {
                    o = constrs[i].newInstance(args);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (o == null) {
                throw new Exception("Could not find a suitable constructor for this argument types.");
            }
            logger.exiting(myClassName, "<init>", o);
            return o;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to instantiate a loader.", e);
            throw new RuntimeException("Unable to instantiate a loader.", e);
        }
    }
}

