/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.DescendingVisitor;
import com.sun.org.apache.bcel.internal.classfile.EmptyVisitor;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class BCELClassFile
implements ClassFile {
    private JavaClass jc;
    private Set classNames;
    private static Logger logger = Logger.getLogger("apiscan.classfile");
    private static final String myClassName = "apiscan.classfile.BCELClassFile";

    public BCELClassFile(InputStream is, String file_name) throws IOException {
        logger.entering(myClassName, "<init>(InputStream, String)", file_name);
        this.jc = new ClassParser(is, file_name).parse();
    }

    public BCELClassFile(String file_path) throws IOException {
        logger.entering(myClassName, "<init>(String)", file_path);
        this.jc = new ClassParser(file_path).parse();
    }

    public synchronized Collection getAllReferencedClassNamesInInternalForm() {
        if (this.classNames == null) {
            this.classNames = new HashSet();
            logger.logp(Level.FINER, myClassName, "getAllReferencedClassNames", "Starting to visit");
            this.jc.accept(new DescendingVisitor(this.jc, new Visitor()));
            logger.logp(Level.FINER, myClassName, "getAllReferencedClassNames", "Finished visting");
            this.classNames = Collections.unmodifiableSet(this.classNames);
        }
        return this.classNames;
    }

    public synchronized Collection getAllReferencedClassNames() {
        if (this.classNames == null) {
            this.getAllReferencedClassNamesInInternalForm();
        }
        HashSet<String> extClassNames = new HashSet<String>(this.classNames.size());
        Iterator i = this.classNames.iterator();
        while (i.hasNext()) {
            extClassNames.add(BCELClassFile.convertToExternalClassName((String)i.next()));
        }
        return extClassNames;
    }

    public static String convertToExternalClassName(String internalClsName) {
        return internalClsName.replace('/', '.');
    }

    public static String convertToInternalClassName(String externalClsName) {
        return externalClsName.replace('.', '/');
    }

    public String getName() {
        return this.jc.getClassName();
    }

    public String getInternalName() {
        return BCELClassFile.convertToInternalClassName(this.getName());
    }

    public String getPackageName() {
        return this.jc.getPackageName();
    }

    public String toString() {
        return "External Name: " + this.getName() + "\n" + "Internal Name: " + this.getInternalName() + "\n" + this.jc.toString() + "\n------------CONSTANT POOL BEGIN--------------\n" + this.jc.getConstantPool() + "\n------------CONSTANT POOL END--------------";
    }

    private static List signatureToClassNames(String signature) {
        int j;
        logger.entering(myClassName, "signatureToClassNames", signature);
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while ((i = signature.indexOf(76, i)) != -1 && (j = signature.indexOf(59, i)) > i) {
            String className = signature.substring(i + 1, j);
            if (!BCELClassFile.isPrimitive(className)) {
                result.add(className);
            }
            i = j + 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer("Class Names are {");
            int size = result.size();
            for (int k = 0; k < size; ++k) {
                sb.append((String)result.get(k));
                if (k == size - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            logger.finer(sb.toString());
        }
        return result;
    }

    private static boolean isPrimitive(String className) {
        logger.entering(myClassName, "isPrimitive", className);
        boolean result = "B".equals(className) || "C".equals(className) || "D".equals(className) || "F".equals(className) || "I".equals(className) || "J".equals(className) || "S".equals(className) || "Z".equals(className);
        logger.exiting(myClassName, "isPrimitive", new Boolean(result));
        return result;
    }

    private class Visitor
    extends EmptyVisitor {
        private Visitor() {
        }

        public void visitConstantClass(ConstantClass obj) {
            logger.entering(BCELClassFile.myClassName, "visitConstantClass", obj);
            String className = obj.getBytes(BCELClassFile.this.jc.getConstantPool());
            logger.finer("Class name is " + className);
            if (className.indexOf(59) != -1 || className.indexOf(91) != -1) {
                BCELClassFile.this.classNames.addAll(BCELClassFile.signatureToClassNames(className));
            } else {
                BCELClassFile.this.classNames.add(className);
            }
        }

        public void visitField(Field field) {
            logger.entering(BCELClassFile.myClassName, "visitField", field);
            String signature = field.getSignature();
            logger.finer("Signature is " + signature);
            BCELClassFile.this.classNames.addAll(BCELClassFile.signatureToClassNames(signature));
        }

        public synchronized void visitMethod(Method method) {
            logger.entering(BCELClassFile.myClassName, "visitMethod", method);
            String signature = method.getSignature();
            logger.finer("Signature is " + signature);
            BCELClassFile.this.classNames.addAll(BCELClassFile.signatureToClassNames(signature));
        }
    }
}

