/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.Initializer;
import com.sun.enterprise.tools.verifier.ReportHandler;
import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.VerificationHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Verifier {
    public static final int FAIL = 0;
    public static final int WARN = 1;
    public static final int ALL = 2;
    private static boolean debug = false;
    private static int reportLevel = 2;
    private static FrameworkContext frameworkContext = null;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");

    public Verifier(boolean usingGui) {
        frameworkContext = new FrameworkContext();
        frameworkContext.setUsingGui(usingGui);
    }

    public Verifier(String[] args) {
        StringManagerHelper.setLocalStringsManager(this.getClass());
        frameworkContext = new Initializer(args).getFrameworkContext();
    }

    public static void main(String[] args) throws IOException {
        Verifier verifer = new Verifier(args);
        if (frameworkContext.isUsingGui()) {
            return;
        }
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        try {
            verifer.verify();
        }
        catch (Exception e) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, smh.getLocalString(verifer.getClass().getName() + ".verifyFailed", "Could not verify successfully."));
            logRecord.setThrown(e);
            frameworkContext.getResultManager().log(logRecord);
        }
        verifer.generateReports();
        int failedCount = frameworkContext.getResultManager().getFailedCount() + frameworkContext.getResultManager().getErrorCount();
        if (failedCount != 0) {
            System.exit(failedCount);
        }
    }

    private ResultManager verify() throws IOException {
        VerificationHandler verificationHandler = new VerificationHandler(frameworkContext);
        return verificationHandler.verifyArchive();
    }

    public ResultManager verify(String jarFile) throws IOException {
        frameworkContext.setJarFileName(jarFile);
        return this.verify();
    }

    public void generateReports() throws IOException {
        new ReportHandler(frameworkContext).generateAllReports();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void debug(Throwable t) {
        logger.log(Level.FINEST, "Exception occurred", t);
    }

    public static void setReportLevel(int rl) {
        if (frameworkContext == null) {
            reportLevel = rl;
        } else {
            frameworkContext.setReportLevel(rl);
        }
    }

    public static int getReportLevel() {
        if (frameworkContext == null) {
            return reportLevel;
        }
        return frameworkContext.getReportLevel();
    }
}

