/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.FileArchiveFactory;
import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.TestInformation;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierEventsListener;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.webservices.WebServiceCheckMgrImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class CheckMgr {
    static Vector listenerList = new Vector();
    protected FrameworkContext frameworkContext = null;
    protected final boolean debug = Verifier.isDebug();
    protected Context context = null;
    private static final String excludeListFileName = "TestExcludeList.xml";
    private Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private boolean isDDPresent = false;

    public void check(Descriptor descriptor) throws Exception {
        this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.check", new Object[]{this.getClass().getName(), descriptor.getName()});
        this.setRuntimeDDPresent(this.getAbstractArchiveUri(descriptor));
        this.loadTestInformationFromPropsFile();
        this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.RunAllTests", new Object[]{descriptor.getName()});
        Vector test = this.getTests();
        String specVersion = this.getSpecVersion(descriptor);
        ResultManager resultManager = this.frameworkContext.getResultManager();
        for (int i = 0; i < test.size(); ++i) {
            TestInformation ti = (TestInformation)test.elementAt(i);
            String minVersion = ti.getMinimumVersion();
            String maxVersion = ti.getMaximumVersion();
            if (specVersion != null && minVersion != null && specVersion.compareTo(minVersion) < 0) {
                this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.version.NOT_APPLICABLE", new Object[]{ti.getClassName()});
                continue;
            }
            if (specVersion != null && maxVersion != null && specVersion.compareTo(maxVersion) > 0) {
                this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.version.NOT_APPLICABLE", new Object[]{ti.getClassName()});
                continue;
            }
            try {
                Class<?> c = Class.forName(ti.getClassName());
                VerifierCheck t = (VerifierCheck)c.newInstance();
                t.setVerifierContext(this.context);
                Result r = t.check(descriptor);
                r.setComponentName(this.getArchiveUri(descriptor));
                this.setModuleName(r);
                resultManager.add(r);
                this.fireTestFinishedEvent(r);
                continue;
            }
            catch (Throwable e) {
                LogRecord logRecord = new LogRecord(Level.SEVERE, ti.getClassName());
                logRecord.setThrown(e);
                resultManager.log(logRecord);
            }
        }
        this.fireAllTestsFinishedEvent();
    }

    public void setVerifierContext(Context context) {
        this.context = context;
    }

    public static void addVerifierEventsListener(VerifierEventsListener l) {
        listenerList.add(l);
    }

    public static void removeVerifierEventsListener(VerifierEventsListener l) {
        listenerList.remove(l);
    }

    protected abstract Vector getTests();

    protected abstract String getTestsListFileName();

    protected abstract String getArchiveUri(Descriptor var1);

    protected abstract void setModuleName(Result var1);

    protected abstract String getSpecVersion(Descriptor var1);

    protected abstract String getSunONETestsListFileName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTestFinishedEvent(Result r) {
        Object[] listeners;
        Vector vector = listenerList;
        synchronized (vector) {
            listeners = listenerList.toArray();
        }
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof VerifierEventsListener)) continue;
            EventObject event = new EventObject(r);
            ((VerifierEventsListener)listeners[i]).testFinished(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAllTestsFinishedEvent() {
        Object[] listeners;
        Vector vector = listenerList;
        synchronized (vector) {
            listeners = listenerList.toArray();
        }
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof VerifierEventsListener)) continue;
            EventObject event = new EventObject(this);
            ((VerifierEventsListener)listeners[i]).allTestsFinished(event);
        }
    }

    protected void loadTestInformationFromPropsFile() throws ParserConfigurationException, SAXException, IOException {
        Vector test = this.getTests();
        test.clear();
        this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.TestnamesPropsFile");
        File inputFile = this.getTestsFileFor(this.getTestsListFileName());
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(inputFile);
        NodeList list = doc.getElementsByTagName("description");
        if (list.getLength() > 0) {
            Element e = (Element)list.item(0);
            e.getFirstChild().getNodeValue().trim();
        }
        list = doc.getElementsByTagName("test");
        for (int i = 0; i < list.getLength(); ++i) {
            Element e = (Element)list.item(i);
            NodeList nl = e.getChildNodes();
            TestInformation ti = new TestInformation();
            for (int j = 0; j < nl.getLength(); ++j) {
                Node el;
                String nodeName = nl.item(j).getNodeName();
                if ("test-class".equals(nodeName.trim())) {
                    el = nl.item(j);
                    ti.setClassName(el.getFirstChild().getNodeValue().trim());
                }
                if ("minimum-version".equals(nodeName.trim())) {
                    el = nl.item(j);
                    ti.setMinimumVersion(el.getFirstChild().getNodeValue().trim());
                }
                if (!"maximum-version".equals(nodeName.trim())) continue;
                el = nl.item(j);
                ti.setMaximumVersion(el.getFirstChild().getNodeValue().trim());
            }
            test.addElement(ti);
        }
        if (this.frameworkContext.isAreRuntimeTestsNeeded() && this.getRuntimeDDPresent()) {
            this.readSunONETests(test);
        }
        Vector testExcluded = this.getTestFromExcludeList();
        test = this.getFinalTestList(test, testExcluded);
    }

    protected Vector getTestFromExcludeList() throws ParserConfigurationException, SAXException, IOException {
        Vector<TestInformation> testExcluded = new Vector<TestInformation>();
        this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.TestnamesPropsFile");
        File inputFile = this.getTestsFileFor(excludeListFileName);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(inputFile);
        NodeList list = doc.getElementsByTagName("description");
        if (list.getLength() > 0) {
            Element e = (Element)list.item(0);
            e.getFirstChild().getNodeValue().trim();
        }
        list = doc.getElementsByTagName("test");
        for (int i = 0; i < list.getLength(); ++i) {
            Element e = (Element)list.item(i);
            NodeList nl = e.getChildNodes();
            TestInformation ti = new TestInformation();
            for (int j = 0; j < nl.getLength(); ++j) {
                String nodeName = nl.item(j).getNodeName();
                if (!"test-class".equals(nodeName.trim())) continue;
                Node el = nl.item(j);
                ti.setClassName(el.getFirstChild().getNodeValue().trim());
            }
            testExcluded.addElement(ti);
        }
        return testExcluded;
    }

    protected Vector getFinalTestList(Vector orignalList, Vector excludeList) {
        if (excludeList == null) {
            return orignalList;
        }
        if (orignalList.size() != 0 && excludeList.size() != 0) {
            for (int i = 0; i < excludeList.size(); ++i) {
                for (int j = 0; j < orignalList.size(); ++j) {
                    if (!((TestInformation)orignalList.elementAt(j)).getClassName().equals(((TestInformation)excludeList.elementAt(i)).getClassName())) continue;
                    orignalList.remove(j);
                }
            }
        }
        return orignalList;
    }

    protected void checkWebServices(Descriptor descriptor) throws Exception {
        if (this.frameworkContext.isPartition() && !this.frameworkContext.isWebServices()) {
            return;
        }
        BundleDescriptor bundleDescriptor = (BundleDescriptor)descriptor;
        WebServiceCheckMgrImpl webServiceCheckMgr = new WebServiceCheckMgrImpl(this.frameworkContext);
        if (bundleDescriptor.hasWebServices()) {
            WebServicesDescriptor wdesc = bundleDescriptor.getWebServices();
            webServiceCheckMgr.setVerifierContext(this.context);
            webServiceCheckMgr.check(wdesc);
        }
    }

    protected static String getSunPrefix() {
        return "sun-";
    }

    private void setRuntimeDDPresent(String uri) {
        try {
            AbstractArchive abstractArchive = new FileArchiveFactory().openArchive(uri);
            Archivist archivist = ArchivistFactory.getArchivistForArchive(abstractArchive);
            String ddFileEntryName = archivist.getRuntimeDeploymentDescriptorPath();
            InputStream is = abstractArchive.getEntry(ddFileEntryName);
            if (is != null) {
                this.isDDPresent = true;
                is.close();
            }
        }
        catch (IOException e) {
            this.isDDPresent = false;
        }
    }

    private boolean getRuntimeDDPresent() {
        return this.isDDPresent;
    }

    private void readSunONETests(Vector test) throws ParserConfigurationException, SAXException, IOException {
        String sunonetests = this.getSunONETestsListFileName();
        if (sunonetests == null) {
            return;
        }
        File inputFile = this.getTestsFileFor(sunonetests);
        if (!inputFile.exists()) {
            return;
        }
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(inputFile);
        NodeList list = doc.getElementsByTagName("description");
        if (list.getLength() > 0) {
            Element e = (Element)list.item(0);
            e.getFirstChild().getNodeValue().trim();
        }
        list = doc.getElementsByTagName("test");
        for (int i = 0; i < list.getLength(); ++i) {
            Element e = (Element)list.item(i);
            NodeList nl = e.getChildNodes();
            TestInformation ti = new TestInformation();
            for (int j = 0; j < nl.getLength(); ++j) {
                Node el;
                String nodeName = nl.item(j).getNodeName();
                if ("test-class".equals(nodeName.trim())) {
                    el = nl.item(j);
                    ti.setClassName(el.getFirstChild().getNodeValue().trim());
                }
                if ("minimum-version".equals(nodeName.trim())) {
                    el = nl.item(j);
                    ti.setMinimumVersion(el.getFirstChild().getNodeValue().trim());
                }
                if (!"maximum-version".equals(nodeName.trim())) continue;
                el = nl.item(j);
                ti.setMaximumVersion(el.getFirstChild().getNodeValue().trim());
            }
            test.addElement(ti);
        }
    }

    private File getTestsFileFor(String filename) {
        File f = new File(this.frameworkContext.getConfigDirStr());
        f = new File(f, filename);
        return new File(f.toString());
    }

    protected String getAbstractArchiveUri(Descriptor descriptor) {
        BundleDescriptor desc = null;
        String archBase = this.context.getAbstractArchive().getArchiveUri();
        if (descriptor instanceof Application) {
            return archBase;
        }
        if (descriptor instanceof BundleDescriptor) {
            desc = (BundleDescriptor)descriptor;
        } else if (descriptor instanceof EjbDescriptor) {
            desc = ((EjbDescriptor)descriptor).getEjbBundleDescriptor();
        } else if (descriptor instanceof ServiceReferenceDescriptor) {
            desc = ((ServiceReferenceDescriptor)descriptor).getBundleDescriptor();
        } else if (descriptor instanceof WebServiceEndpoint) {
            desc = ((WebServiceEndpoint)descriptor).getBundleDescriptor();
        }
        if (desc.getApplication() != null) {
            String moduleName = desc.getModuleDescriptor().getArchiveUri();
            if (moduleName.lastIndexOf(".") != -1) {
                String moduleDir = moduleName.replace('.', '_');
                String ret = archBase + File.separator + moduleDir;
                return ret;
            }
            return archBase;
        }
        return archBase;
    }
}

