/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tools.com.sun.enterprise.util.XMLValidationHandler;

public abstract class BaseVerifier {
    protected Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    protected FrameworkContext frameworkContext = null;
    protected Context context = null;

    public abstract void verify() throws Exception;

    public abstract Descriptor getDescriptor();

    protected abstract ClassLoader createClassLoader(File var1) throws MalformedURLException, IOException;

    protected abstract String getArchiveUri();

    protected abstract String getClassPath() throws IOException;

    protected void createDocumentObject(Descriptor descriptor) throws IOException, ParserConfigurationException, SAXException {
        InputStream is = null;
        InputSource source = null;
        String descuri = this.getArchiveUri();
        String archBase = this.context.getAbstractArchive().getArchiveUri();
        String uri = null;
        if (!(descuri.endsWith(".jar") || descuri.endsWith(".war") || descuri.endsWith(".rar"))) {
            uri = archBase;
        } else {
            String moduleDir = descuri.replace('.', '_');
            uri = archBase + File.separator + moduleDir;
        }
        String[] dd = this.getDDString();
        for (int i = 0; i < dd.length; ++i) {
            is = this.getInputStreamFromAbstractArchive(uri, dd[i]);
            if (is == null) continue;
            source = new InputSource(is);
            this.createDOMObject(source, dd[i]);
            is.close();
        }
    }

    protected boolean areTestsNotRequired(boolean isModuleGivenInPartiotioningArgs) {
        return this.frameworkContext.isPartition() && !isModuleGivenInPartiotioningArgs;
    }

    protected void preVerification() throws Exception {
        this.logger.log(Level.INFO, "Verifying: [ " + this.getArchiveUri() + " ]");
        ClassLoader loader = this.createClassLoader(new File(this.frameworkContext.getExplodedArchivePath()));
        this.context = new Context(loader);
        Descriptor.setBoundsChecking(false);
        this.context.setDeployRuntime(true);
        this.context.setAbstractArchive(this.frameworkContext.getAbstractArchive());
        this.context.setClassPath(this.getClassPath());
    }

    protected void verify(Descriptor descriptor, CheckMgr checkMgrImpl) throws Exception {
        this.createDocumentObject(descriptor);
        checkMgrImpl.setVerifierContext(this.context);
        checkMgrImpl.check(descriptor);
        this.logger.log(Level.FINE, this.getClass().getName() + ".debug.endStaticVerification");
    }

    protected void createDOMObject(InputSource source, String dd) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        XMLValidationHandler dh = new XMLValidationHandler(false);
        builder.setEntityResolver(dh);
        Document document = builder.parse(source);
        if (dd.indexOf("sun-") < 0) {
            if (dd.indexOf("webservices") < 0) {
                this.context.setDocument(document);
            } else {
                this.context.setWebServiceDocument(document);
            }
        } else {
            this.context.setRuntimeDocument(document);
        }
    }

    protected abstract String[] getDDString();

    protected InputStream getInputStreamFromAbstractArchive(String uri, String ddName) throws IOException {
        FileArchive arch = new FileArchive();
        arch.open(uri);
        InputStream deploymentEntry = arch.getEntry(ddName);
        return deploymentEntry;
    }
}

