/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common;

import com.sun.enterprise.tools.common.PropertyUtils;
import com.sun.enterprise.tools.common.util.diagnostics.Reporter;
import com.sun.enterprise.tools.common.util.diagnostics.StackTrace;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;

public class LinkProperties
implements PropertyChangeListener {
    protected Object target;
    protected String sourceFieldName;
    protected Method writer = null;
    protected Object[] args = new Object[]{this.target};

    public LinkProperties(Object target, String commonName) throws IntrospectionException {
        this.target = target;
        this.sourceFieldName = commonName;
        this.writer = PropertyUtils.getWriter(target, commonName);
    }

    public LinkProperties(Object target, String srcName, String destName) throws IntrospectionException {
        this.target = target;
        this.sourceFieldName = srcName;
        this.writer = PropertyUtils.getWriter(target, destName);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        Reporter.info(pce);
        String changedProperty = pce.getPropertyName();
        Reporter.info(changedProperty);
        Reporter.info(pce.getOldValue());
        Reporter.info(pce.getNewValue());
        Reporter.info(this.sourceFieldName);
        try {
            if (changedProperty.equals(this.sourceFieldName)) {
                Reporter.info("case one");
                Reporter.verbose(pce);
                this.args[0] = pce.getNewValue();
                this.writer.invoke(this.target, this.args);
            }
        }
        catch (Throwable t) {
            try {
                this.args[0] = pce.getNewValue().toString();
                this.writer.invoke(this.target, this.args);
            }
            catch (Throwable tt) {
                Reporter.critical(new StackTrace(t));
            }
        }
    }

    public static void main(String[] args) {
        Reporter.setSeverityLevel(0);
        TestObject a = new TestObject("foo");
        TestObject b = new TestObject("bar");
        PropertyChangeSupport propWrap = new PropertyChangeSupport(a);
        System.out.println(a);
        System.out.println(b);
        try {
            propWrap.addPropertyChangeListener(new LinkProperties(b, "fOne"));
            propWrap.addPropertyChangeListener(new LinkProperties(b, "fOne", "fTwo"));
            a.setFOne("baz");
            a.setFTwo("Blah");
            propWrap.firePropertyChange("fOne", "foo", "baz");
            propWrap.firePropertyChange("fTwo", "foo", "Blah");
            System.out.println(a);
            System.out.println(b);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static class TestObject {
        private String fOne;
        private String fTwo;

        public TestObject(String arg) {
            this.fOne = arg;
            this.fTwo = arg;
        }

        public void setFOne(String newVal) {
            this.fOne = newVal;
        }

        public String getFOne() {
            return this.fOne;
        }

        public void setFTwo(String newVal) {
            this.fTwo = newVal;
        }

        public String getFTwo() {
            return this.fTwo;
        }

        public String toString() {
            return "My values are " + this.fOne + " and " + this.fTwo;
        }
    }
}

