/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class SystemLogHandler
extends Handler {
    private static final String SYSLOG_FILE_PREFIX = "SJSAS81";
    private String syslogFileName = "SJSAS81";

    public native void logMessage(String var1, String var2, String var3);

    public SystemLogHandler() {
        try {
            System.loadLibrary("utilforsyslog");
            String serverName = System.getProperty("com.sun.aas.instanceName");
            String clusterId = System.getProperty("com.sun.aas.clusterName");
            if (clusterId != null) {
                this.syslogFileName = this.syslogFileName + "_" + clusterId;
            }
            if (serverName != null) {
                this.syslogFileName = this.syslogFileName + "_" + serverName;
            }
            this.syslogFileName = this.syslogFileName + ".log";
        }
        catch (Exception e) {
            System.err.println("Exception in loading Syslog Library..." + e);
            e.printStackTrace();
        }
    }

    public synchronized void publish(LogRecord record) {
        this.logMessage(this.syslogFileName, record.getLevel().toString(), this.getFormatter().format(record));
    }

    public void close() {
    }

    public void flush() {
    }
}

