/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.server.logging.FileandSyslogHandler;
import com.sun.enterprise.server.logging.FilenameFilterImpl;
import com.sun.enterprise.server.logging.LogAlarm;
import com.sun.enterprise.server.logging.LogRotatorSPI;
import com.sun.enterprise.server.logging.ModuleToLoggerNameMapper;
import com.sun.enterprise.server.logging.ServerLogManager;
import com.sun.enterprise.server.logging.diagnostics.MessageIdCatalog;
import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class LogMBean
extends NotificationBroadcasterSupport
implements DynamicMBean {
    private static final String LOGS_DIR = "logs";
    private ObjectName objectName;
    private LogRotatorSPI accessLogRotator = null;
    private static final String LOG_MBEAN_DESCRIPTION = " Log MBean can be used for Managinging and Monitoring Logs \n The main features  provided by this MBean are .... \n 1. Fetch the Loggers available in the server \n 2. Fetch the log level of a given logger \n 3. Dynamically change the log levels of all the avalaible Loggers \n 4. Send SEVERE and WARNING Log messages as Alarms to all the interested parties ";
    private static final String GET_LOGGER_NAMES = "getLoggerNames";
    private static final String GET_LOGGER_NAMES_DESCRIPTION = " Gets all the Loggers currently running in the System. The returned  list is not sorted. ";
    private static final String GET_LOGGER_NAMES_UNDER = "getLoggerNamesUnder";
    private static final String GET_LOGGER_NAMES_UNDER_DESCRIPTION = " Gets all the Loggers under a given logger. The returned list is not  sorted. ";
    private static final String GET_LOG_LEVEL = "getLogLevel";
    private static final String GET_LOG_LEVEL_DESCRIPTION = " Gets the current Log Level of the given Logger. The 8 Possible  values are 1.SEVERE 2.WARNING 3.INFO 4.CONFIG 5.FINE 6.FINER  7.FINEST 8. Null";
    private static final String SET_LOG_LEVEL = "setLogLevel";
    private static final String SET_LOG_LEVEL_DESCRIPTION = " Sets the log level of the given logger to the request level. An  IllegalArgument Exception will be raised if the level is not one  of the following 8 values.  1.SEVERE 2.WARNING 3.INFO 4.CONFIG  5.FINE 6.FINER 7.FINEST 8.OFF";
    private static final String SET_LOG_LEVEL_FOR_MODULE = "setLogLevelForModule";
    private static final String SET_LOG_LEVEL_FOR_MODULE_DESCRIPTION = " Sets the log level for a given module .\n The Modules are admin, classloader, cmp-container, configuration  , connector, corba, deployment, ejb-container, javamail, jaxr,  jaxrpc, mdb-container, naming, saaj, security, server,  transaction, verifier, web-container, core  IllegalArgument Exception will be raised if the level is not one  of the following 8 values.  1.SEVERE 2.WARNING 3.INFO 4.CONFIG  5.FINE 6.FINER 7.FINEST 8.OFF";
    private static final String GET_LOG_RECORD_USING_QUERY = "getLogRecordsUsingQuery";
    private static final String GET_LOG_RECORD_USING_QUERY_DESCRIPTION = " This method returns the Log Records from the server.log file \n based on the query passed.....";
    private static final String GET_ARCHIVED_LOG_FILES = "getArchivedLogfiles";
    private static final String GET_ARCHIVED_LOG_FILES_DESCRIPTION = " This method returns a list of Archived Log files currently  available in the domain/log directory";
    private static final String GET_DIAGNOSTIC_CAUSES_FOR_MESSAGEID = "getDiagnosticCausesForMessageId";
    private static final String GET_DIAGNOSTIC_CAUSES_FOR_MESSAGEID_DESCRIPTION = " This method returns the Possible Causes for an Error Code specified";
    private static final String GET_DIAGNOSTIC_CHECKS_FOR_MESSAGEID = "getDiagnosticChecksForMessageId";
    private static final String GET_DIAGNOSTIC_CHECKS_FOR_MESSAGEID_DESCRIPTION = " This method returns the Diagnostic Checks for an Error Code specified";
    private static final String GET_DIAGNOSTIC_URI_FOR_MESSAGEID = "getDiagnosticURIForMessageId";
    private static final String GET_DIAGNOSTIC_URI_FOR_MESSAGEID_DESCRIPTION = " This method returns the URI to locate the latest Diagnostic info  on SUN's Docs Website";
    private static final String ROTATE_NOW = "rotateNow";
    private static final String ROTATE_NOW_DESCRIPTION = " Log file will be rotated when this method is called, This will  override the other two rotation mechanisms of rotation based on  log file size or timer.\n The timer will be restarted to schedule  next rotation if it is specified.";
    private static final String GET_LOGFILES_DIRECTORY = "getLogFilesDirectory";
    private static final String GET_LOGFILES_DIRECTORY_DESCRIPTION = " This method returns the LogFiles Directory to help locate  Logfiles in the FileSystem...";
    private static final String NOTIFICATION_SEVERE_ALARM = "SevereLogMessages";
    private static final String NOTIFICATION_SEVERE_ALARM_DESCRIPTION = " All Logged Messages whose Log Level is SEVERE will be notified  to all the subscribed listeners...";
    private static final String NOTIFICATION_WARNING_ALARM = "WarningLogMessages";
    private static final String NOTIFICATION_WARNING_ALARM_DESCRIPTION = " All Logged Messages whose Log Level is WARNING will be notified  to all the subscribed listeners...";
    private static MBeanOperationInfo[] operationInfoArray = new MBeanOperationInfo[12];
    private static MBeanInfo mBeanInfo;
    private MBeanServer mbeanServer = null;
    private static LogMBean mbeanInstance;

    public static synchronized LogMBean getInstance() {
        if (mbeanInstance == null) {
            mbeanInstance = new LogMBean();
            mbeanInstance.initialize();
        }
        return mbeanInstance;
    }

    private LogMBean() {
    }

    public void initialize() {
        try {
            LogMBean.operationInfoArray[0] = new MBeanOperationInfo(GET_LOGGER_NAMES, GET_LOGGER_NAMES_DESCRIPTION, null, "java.util.List", 1);
            MBeanParameterInfo[] loggerNameParam = new MBeanParameterInfo[]{new MBeanParameterInfo("LoggerName", "String", "Logger Name")};
            LogMBean.operationInfoArray[1] = new MBeanOperationInfo(GET_LOGGER_NAMES_UNDER, GET_LOGGER_NAMES_UNDER_DESCRIPTION, loggerNameParam, "java.util.List", 1);
            LogMBean.operationInfoArray[2] = new MBeanOperationInfo(GET_LOG_LEVEL, GET_LOG_LEVEL_DESCRIPTION, loggerNameParam, "String", 1);
            MBeanParameterInfo[] loggerNameAndLevelParam = new MBeanParameterInfo[]{new MBeanParameterInfo("LoggerName", "String", "Logger Name"), new MBeanParameterInfo("LogLevel", "String", "Logger Level")};
            LogMBean.operationInfoArray[3] = new MBeanOperationInfo(SET_LOG_LEVEL, SET_LOG_LEVEL_DESCRIPTION, loggerNameAndLevelParam, "void", 1);
            LogMBean.operationInfoArray[4] = new MBeanOperationInfo(SET_LOG_LEVEL_FOR_MODULE, SET_LOG_LEVEL_FOR_MODULE_DESCRIPTION, loggerNameAndLevelParam, "void", 1);
            MBeanParameterInfo[] logviewerQueryParams = new MBeanParameterInfo[]{new MBeanParameterInfo("FileName", "String", " If Filename is specified then it will be used to  run the query. If the user specifies null for this  argument then the current server.log file will be   used to run the query. This argument is specifed to  typically run query on Archived Log File "), new MBeanParameterInfo("FromRecord", "Long", "The location within the LogFile"), new MBeanParameterInfo("next", "Boolean", "True to get the next set of results and False to get  the previous results "), new MBeanParameterInfo("forward", "Boolean", "True to search forward through the log file "), new MBeanParameterInfo("requestedCount", "Integer", "Number of desired records"), new MBeanParameterInfo("fromDate", "java.util.Date", " The lower bound date "), new MBeanParameterInfo("toDate", "java.util.Date", " The upper bound date "), new MBeanParameterInfo("logLevel", "String", " The minimum log level to display "), new MBeanParameterInfo("onlyLevel", "Boolean", " True to only display messsage for \"logLevel\""), new MBeanParameterInfo("listOfModules", "java.util.List", " List Of Modules and Logger Names To Match"), new MBeanParameterInfo("nameValueMap", "java.util.Properties", " List Of Name Value Pairs to match ")};
            LogMBean.operationInfoArray[5] = new MBeanOperationInfo(GET_LOG_RECORD_USING_QUERY, GET_LOG_RECORD_USING_QUERY_DESCRIPTION, logviewerQueryParams, "javax.management.AttributeList", 1);
            LogMBean.operationInfoArray[6] = new MBeanOperationInfo(GET_ARCHIVED_LOG_FILES, GET_ARCHIVED_LOG_FILES_DESCRIPTION, null, "[Ljava.lang.String;", 1);
            MBeanParameterInfo[] diagnosticsParameter = new MBeanParameterInfo[]{new MBeanParameterInfo("messageId", "String", "Error Code")};
            LogMBean.operationInfoArray[7] = new MBeanOperationInfo(GET_DIAGNOSTIC_CAUSES_FOR_MESSAGEID, GET_DIAGNOSTIC_CAUSES_FOR_MESSAGEID_DESCRIPTION, diagnosticsParameter, "java.util.ArrayList", 1);
            LogMBean.operationInfoArray[8] = new MBeanOperationInfo(GET_DIAGNOSTIC_CHECKS_FOR_MESSAGEID, GET_DIAGNOSTIC_CHECKS_FOR_MESSAGEID_DESCRIPTION, diagnosticsParameter, "java.util.ArrayList", 1);
            LogMBean.operationInfoArray[9] = new MBeanOperationInfo(GET_DIAGNOSTIC_URI_FOR_MESSAGEID, GET_DIAGNOSTIC_URI_FOR_MESSAGEID_DESCRIPTION, diagnosticsParameter, "String", 1);
            LogMBean.operationInfoArray[10] = new MBeanOperationInfo(ROTATE_NOW, ROTATE_NOW_DESCRIPTION, null, "void", 1);
            LogMBean.operationInfoArray[11] = new MBeanOperationInfo(GET_LOGFILES_DIRECTORY, GET_LOGFILES_DIRECTORY_DESCRIPTION, null, "String", 1);
            String[] alarmTypes = new String[]{NOTIFICATION_SEVERE_ALARM, NOTIFICATION_WARNING_ALARM};
            MBeanNotificationInfo[] notificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(alarmTypes, "Alarms", "Severe and Warning Log Messages will be notified ")};
            mBeanInfo = new MBeanInfo("LogMBean", LOG_MBEAN_DESCRIPTION, null, null, operationInfoArray, notificationInfo);
        }
        catch (Exception e) {
            new ErrorManager().error("Error in LogMBean Initialization", e, 0);
        }
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null || operationName.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean.invoke operation name is  null "));
        }
        AttributeList resultList = new AttributeList();
        if (operationName.equals(GET_LOGGER_NAMES)) {
            return this.getLoggerNames();
        }
        if (operationName.equals(GET_LOGGER_NAMES_UNDER)) {
            String loggerName = (String)params[0];
            return this.getLoggerNamesUnder(loggerName);
        }
        if (operationName.equals(GET_LOG_LEVEL)) {
            String loggerName = (String)params[0];
            return this.getLogLevel(loggerName);
        }
        if (operationName.equals(SET_LOG_LEVEL)) {
            String loggerName = (String)params[0];
            String loglevel = (String)params[1];
            this.setLogLevel(loggerName, loglevel);
        } else if (operationName.equals(SET_LOG_LEVEL_FOR_MODULE)) {
            String module = (String)params[0];
            String loglevel = (String)params[1];
            this.setLogLevel(module, loglevel);
        } else {
            if (operationName.equals(GET_LOG_RECORD_USING_QUERY)) {
                String fileName = (String)params[0];
                Long fromRecord = (Long)params[1];
                Boolean next = (Boolean)params[2];
                Boolean forward = (Boolean)params[3];
                Integer requestedCount = (Integer)params[4];
                Date fromDate = (Date)params[5];
                Date toDate = (Date)params[6];
                String logLevel = (String)params[7];
                Boolean onlyLevel = (Boolean)params[8];
                List listOfModules = (List)params[9];
                Properties nvMap = (Properties)params[10];
                return this.getLogRecordsUsingQuery(fileName, fromRecord, next, forward, requestedCount, fromDate, toDate, logLevel, onlyLevel, listOfModules, nvMap);
            }
            if (operationName.equals(GET_ARCHIVED_LOG_FILES)) {
                return this.getArchivedLogFiles();
            }
            if (operationName.equals(GET_DIAGNOSTIC_CAUSES_FOR_MESSAGEID)) {
                String messageId = (String)params[0];
                return MessageIdCatalog.getInstance().getDiagnosticCausesForMessageId(messageId);
            }
            if (operationName.equals(GET_DIAGNOSTIC_CHECKS_FOR_MESSAGEID)) {
                String messageId = (String)params[0];
                return MessageIdCatalog.getInstance().getDiagnosticChecksForMessageId(messageId);
            }
            if (operationName.equals(GET_DIAGNOSTIC_URI_FOR_MESSAGEID)) {
                String messageId = (String)params[0];
                return MessageIdCatalog.getInstance().getDiagnosticURIForMessageId(messageId);
            }
            if (operationName.equals(ROTATE_NOW)) {
                this.rotateNow();
            } else {
                if (operationName.equals(GET_LOGFILES_DIRECTORY)) {
                    return this.getLogFilesDirectory();
                }
                throw new IllegalArgumentException("Requested operation " + operationName + " does not exist...");
            }
        }
        return resultList;
    }

    public List getLoggerNames() {
        LinkedList<String> loggerNamesList = new LinkedList<String>();
        Enumeration<String> allLoggers = LogManager.getLogManager().getLoggerNames();
        while (allLoggers.hasMoreElements()) {
            loggerNamesList.add(allLoggers.nextElement());
        }
        return loggerNamesList;
    }

    public List getLoggerNamesUnder(String loggerName) {
        LinkedList<String> filteredList = new LinkedList<String>();
        Iterator allLoggersIterator = this.getLoggerNames().iterator();
        while (allLoggersIterator.hasNext()) {
            String t = (String)allLoggersIterator.next();
            if (!t.startsWith(loggerName)) continue;
            filteredList.add(t);
        }
        return filteredList;
    }

    public String getLogLevel(String loggerName) {
        String logLevelInString = null;
        Logger logger = Logger.getLogger(loggerName);
        if (logger == null) {
            throw new RuntimeException(" Logger " + loggerName + " does not exist");
        }
        Level level = logger.getLevel();
        boolean foundParentLevel = false;
        if (level == null) {
            while (!foundParentLevel && (logger = logger.getParent()) != null) {
                level = logger.getLevel();
                if (level == null) continue;
                foundParentLevel = true;
            }
        }
        if (level != null) {
            logLevelInString = level.toString();
        }
        return logLevelInString;
    }

    public void setLogLevel(String loggerName, String level) {
        Level logLevel = Level.parse(level);
        Iterator listIterator = this.getLoggerNamesUnder(loggerName).iterator();
        while (listIterator.hasNext()) {
            this.internalSetLogLevel((String)listIterator.next(), logLevel);
        }
    }

    public void setLogLevelForModule(String module, String level) {
        this.setLogLevel(ModuleToLoggerNameMapper.getLoggerName(module), level);
    }

    private void internalSetLogLevel(final String loggerName, final Level level) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Logger.getLogger(loggerName).setLevel(level);
                return null;
            }
        });
    }

    public AttributeList getLogRecordsUsingQuery(String logFilename, Long fromRecord, Boolean next, Boolean forward, Integer requestedCount, Date fromDate, Date toDate, String logLevel, Boolean onlyLevel, List listOfModules, Properties nameValueMap) {
        return LogFilter.getLogRecordsUsingQuery(logFilename, fromRecord, next, forward, requestedCount, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap);
    }

    public String[] getArchivedLogFiles() {
        String[] archivedLogFiles = new String[]{};
        try {
            String instDir = System.getProperty("com.sun.aas.instanceRoot");
            String[] names = new String[]{instDir, LOGS_DIR};
            String logDir = StringUtils.makeFilePath((String[])names, (boolean)false);
            File file = new File(logDir);
            archivedLogFiles = file.list(new FilenameFilterImpl());
            String currentFileName = new File(ServerLogManager.getLogService().getFile()).getName();
            boolean foundCurrentFile = false;
            int i = 0;
            for (i = 0; i < archivedLogFiles.length; ++i) {
                if (!currentFileName.equals(archivedLogFiles[i])) continue;
                foundCurrentFile = true;
                break;
            }
            if (!foundCurrentFile) {
                String[] newArchivedLogFiles = new String[archivedLogFiles.length + 1];
                newArchivedLogFiles[0] = currentFileName;
                for (i = 1; i < archivedLogFiles.length + 1; ++i) {
                    newArchivedLogFiles[i] = archivedLogFiles[i - 1];
                }
                return newArchivedLogFiles;
            }
        }
        catch (Exception e) {
            System.err.println("Exception in LogMBean.getArchivedLogFiles.." + e);
            throw new RuntimeException("Exception in LogMBean.getArchivedLogFiles.." + e);
        }
        return archivedLogFiles;
    }

    public void rotateNow() {
        FileandSyslogHandler.getInstance().requestRotation();
        this.rotateAccessLog();
    }

    public void rotateAccessLog() {
        if (this.accessLogRotator != null) {
            this.accessLogRotator.rotate();
        }
    }

    public void setAccessLogRotator(LogRotatorSPI logRotator) {
        this.accessLogRotator = logRotator;
    }

    public String getLogFilesDirectory() {
        try {
            String fileName = FileandSyslogHandler.getInstance().getAbsoluteLogFileName();
            return new File(fileName).getParent();
        }
        catch (Exception e) {
            System.err.println("Exception in LogMBean.getLogFilesDirectory()" + e);
            return null;
        }
    }

    public void changeLogFileName(String fileName) {
        FileandSyslogHandler.getInstance().changeFileName(fileName);
    }

    public MBeanInfo getMBeanInfo() {
        return mBeanInfo;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        if (attribute != null) {
            throw new AttributeNotFoundException("Attribute " + attribute + " not found in LogMBean. There are no attributes.");
        }
        throw new IllegalArgumentException("Attribute Name is null");
    }

    public AttributeList getAttributes(String[] attributeNames) {
        return new AttributeList();
    }

    public AttributeList setAttributes(AttributeList list) {
        return new AttributeList();
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException {
        if (attribute != null) {
            throw new AttributeNotFoundException("Attribute " + attribute.getName() + " not found in LogMBean. There are no attributes.");
        }
        throw new IllegalArgumentException("Attribute Name is null");
    }

    private void raiseAlarm(String type, String alarmMessage) {
        LogAlarm logAlarm = new LogAlarm(type, (Object)this, alarmMessage);
        this.sendNotification(logAlarm);
    }

    void raiseWarningAlarm(String alarmMessage) {
        this.raiseAlarm(NOTIFICATION_WARNING_ALARM, alarmMessage);
    }

    void raiseSevereAlarm(String alarmMessage) {
        this.raiseAlarm(NOTIFICATION_SEVERE_ALARM, alarmMessage);
    }

    static {
        mbeanInstance = null;
    }
}

