/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.util.logging.IASLevel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public abstract class BaseLogManager
extends LogManager {
    private boolean _configurationRead = false;
    private List _unInitializedLoggers = new ArrayList();
    protected static Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected BaseLogManager() {
    }

    public String getLoggerResourceBundleName(String loggerName) {
        String result = loggerName + "." + "LogStrings";
        return result.replaceFirst("javax.", "com.sun.logging.");
    }

    protected abstract void initializeLogger(Logger var1);

    protected void doInitializeLogger(Logger logger) {
        String loggerName = logger.getName();
        if (!(loggerName.startsWith("org.apache") || loggerName.startsWith("com.sun.faces") || loggerName.startsWith("tomcat") || logger.getResourceBundleName() != null)) {
            try {
                Logger newLogger = Logger.getLogger(logger.getName(), this.getLoggerResourceBundleName(logger.getName()));
                if (!$assertionsDisabled && logger != newLogger) {
                    throw new AssertionError();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.initializeLogger(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        super.readConfiguration(ins);
        List list = this._unInitializedLoggers;
        synchronized (list) {
            this._configurationRead = true;
            Iterator iter = this._unInitializedLoggers.iterator();
            while (iter.hasNext()) {
                Logger l = (Logger)iter.next();
                this.doInitializeLogger(l);
            }
            this._unInitializedLoggers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLogger(Logger logger) {
        boolean result = super.addLogger(logger);
        if (result) {
            try {
                if (_logger == null) {
                    _logger = logger;
                }
                List list = this._unInitializedLoggers;
                synchronized (list) {
                    if (!this._configurationRead) {
                        this._unInitializedLoggers.add(logger);
                        return result;
                    }
                    this.doInitializeLogger(logger);
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                _logger.log(Level.SEVERE, "addLogger exception ", th);
            }
        }
        return result;
    }

    static {
        $assertionsDisabled = !BaseLogManager.class.desiredAssertionStatus();
        _logger = null;
        IASLevel.ALERT.getName();
    }
}

