/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.event;

import com.sun.enterprise.server.event.ApplicationEvent;
import com.sun.enterprise.server.event.ApplicationLoaderEventListener;
import com.sun.enterprise.server.event.EjbContainerEvent;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationLoaderEventNotifier {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private static ApplicationLoaderEventNotifier _notifier = new ApplicationLoaderEventNotifier();
    private ArrayList listeners = new ArrayList();

    private ApplicationLoaderEventNotifier() {
    }

    public static ApplicationLoaderEventNotifier getInstance() {
        return _notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ApplicationLoaderEventListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ApplicationLoaderEventListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(ApplicationEvent event) {
        ArrayList myListeners = null;
        _logger.log(Level.FINE, "LoaderEventNotifier: " + event);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            myListeners = (ArrayList)this.listeners.clone();
        }
        int sz = myListeners.size();
        for (int i = 0; i < sz; ++i) {
            ApplicationLoaderEventListener listener = (ApplicationLoaderEventListener)myListeners.get(i);
            try {
                listener.handleApplicationEvent(event);
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "Exception during handleApplicationEvent", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(EjbContainerEvent event) {
        ArrayList myListeners = null;
        _logger.log(Level.FINE, "LoaderEventNotifier: " + event);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            myListeners = (ArrayList)this.listeners.clone();
        }
        int sz = myListeners.size();
        for (int i = 0; i < sz; ++i) {
            ApplicationLoaderEventListener listener = (ApplicationLoaderEventListener)myListeners.get(i);
            try {
                listener.handleEjbContainerEvent(event);
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "Exception during handleEjbContainerEvent", ex);
            }
        }
    }
}

