/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.deployment.autodeploy.AutoDeployer;
import com.sun.enterprise.deployment.autodeploy.AutoDeploymentException;
import com.sun.enterprise.server.ApplicationLifecycle;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.SystemAppScanner;
import java.io.File;
import java.util.logging.Level;

public final class SystemAppLifecycle
extends ApplicationLifecycle {
    public void startup(ServerContext sc) throws ServerLifecycleException {
        this.onInitialization(sc);
        this.onStartup(sc);
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        try {
            this.loadSystemApps();
            this.deploySystemApps();
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_loading", th);
        }
    }

    public void onReady(ServerContext sc) throws ServerLifecycleException {
    }

    public void onShutdown() throws ServerLifecycleException {
    }

    public void onTermination() throws ServerLifecycleException {
    }

    private void loadSystemApps() {
        _logger.log(Level.FINE, "core.loading_system_apps");
        this._connMgr.loadSystem();
        this._ejbMgr.loadSystem();
        this._applicationMgr.loadSystem();
    }

    private String getSystemAppDirPath() {
        String sysAppDirPath = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "applications";
        return sysAppDirPath;
    }

    private void deploySystemApps() {
        try {
            String[] targets = this.getTargets();
            if (targets == null) {
                return;
            }
            int size = targets.length;
            for (int i = 0; i < size; ++i) {
                this.deployToTarget(targets[i]);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "core.exception_while_deploying_system_apps", ex);
        }
    }

    private void deployToTarget(String target) {
        String sysAppDirPath = this.getSystemAppDirPath();
        _logger.log(Level.FINE, "core.deploying_system_apps", new Object[]{target, sysAppDirPath});
        AutoDeployer deployer = new AutoDeployer();
        deployer.setTarget(target);
        deployer.setDirectoryScanner(new SystemAppScanner(this.getTargetType(target)));
        deployer.disableRenameOnSuccess();
        File sysAppDir = new File(sysAppDirPath);
        try {
            if (sysAppDir.exists() && sysAppDir.canRead()) {
                deployer.deployAll(sysAppDir);
                _logger.log(Level.FINE, "core.deployed_system_apps", target);
            } else {
                _logger.log(Level.WARNING, "core.system_app_dir_not_found", new Object[]{sysAppDirPath});
            }
        }
        catch (AutoDeploymentException ade) {
            _logger.log(Level.SEVERE, "core.exception_while_deploying_system_apps", ade);
        }
    }

    private String[] getTargets() {
        try {
            ConfigContext confContext = this._context.getConfigContext();
            Domain domain = (Domain)confContext.getRootConfigBean();
            Servers svrs = domain.getServers();
            Server[] svrArr = svrs.getServer();
            int size = svrArr.length;
            String[] targetNames = new String[size];
            for (int i = 0; i < size; ++i) {
                targetNames[i] = svrArr[i].getName();
            }
            return targetNames;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "core.exception_while_getting_targets", ex);
            return null;
        }
    }

    private String getTargetType(String targetName) {
        try {
            if (ServerHelper.isDAS(this._context.getConfigContext(), targetName)) {
                return "admin";
            }
            return "instance";
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "core.exception_while_getting_targetType", ex);
            return null;
        }
    }
}

