/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.MonitoringHelper;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.JmsRaUtil;
import com.sun.enterprise.deployment.backend.OptionalPkgDependency;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.distributedtx.UserTransactionImpl;
import com.sun.enterprise.iiop.ORBMonitoring;
import com.sun.enterprise.iiop.PEORBConfigurator;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.naming.SerialContextProviderImpl;
import com.sun.enterprise.repository.Configuration;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.PEMain;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ServerContextImpl;
import com.sun.enterprise.transaction.monitor.JTSMonitorMBean;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public final class J2EEServer {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    public static final SecureRandom secureRandom = new SecureRandom();
    public static final String J2EE_HOME = "com.sun.enterprise.home";
    public static final String J2EE_APPNAME = "com.sun.enterprise.appname";
    public static final String JTS_SERVER_ID = "com.sun.jts.persistentServerId";
    public static final String J2EE_SERVER_ID_PROP = "com.sun.enterprise.J2EEServerId";
    private static final boolean debug = true;
    private static LocalStringManagerImpl localStrings;
    private static PrintStream ostream;
    private static PrintStream estream;
    private static final int MAX_INITIAL_CONTEXT_RETRIES = 15;
    private static final String DefaultDbDir = "orb.db";
    private static final String LISTEN_PROP = "com.sun.CORBA.connection.ORBListenSocket";
    private static final String OUTPUT_LOG = "system.out";
    private static final String ERROR_LOG = "system.err";
    private File repositoryDir;
    private int orbInitialPort;
    private Configuration conf = null;
    private ORB orb;
    private ProtocolManager protocolMgr;
    private ServerContext serverContext;

    private void run(String[] args, boolean verbose, boolean startJMS) {
        ConnectorRuntime.getRuntime().initialize(1);
        try {
            if (this.serverContext != null && this.serverContext instanceof ServerContextImpl) {
                ServerContextImpl ctxImp = (ServerContextImpl)this.serverContext;
                String seedFile = ctxImp.getServerConfigPath() + File.separator + "secure.seed";
                File secureSeedFile = new File(seedFile);
                long seed = this.readSecureSeed(secureSeedFile);
                secureRandom.setSeed(seed);
                seed = secureRandom.nextLong();
                this.writeSecureSeed(secureSeedFile, seed);
                secureSeedFile = null;
            } else {
                _logger.log(Level.FINE, "Unable to initialize secure seed.");
            }
            Properties props = System.getProperties();
            props.setProperty(J2EE_APPNAME, "j2ee");
            Switch theSwitch = Switch.getSwitch();
            theSwitch.setContainerType(2);
            try {
                this.orb = this.createORB(args);
                try {
                    Object obj = this.orb.resolve_initial_references("RootPOA");
                }
                catch (InvalidName in) {
                    _logger.log(Level.SEVERE, "enterprise.orb_reference_exception", in);
                }
            }
            catch (Exception ex) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "enterprise.createorb_exception", ex.toString());
                }
                _logger.log(Level.FINEST, "Exception while creating ORB: ", ex);
                throw new RuntimeException("Unable to create ORB");
            }
            if (Switch.getSwitch().getContainerType() == 2) {
                new ORBMonitoring(this.orb);
            }
            this.protocolMgr = new POAProtocolMgr(this.orb);
            theSwitch.setProtocolManager(this.protocolMgr);
            this.protocolMgr.initializeNaming(this.repositoryDir, this.orbInitialPort);
            ((POAProtocolMgr)this.protocolMgr).initializePOAs();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("j2ee.naming", "Naming service started: ") + this.orbInitialPort);
            }
            SerialContextProviderImpl.initSerialContextProvider();
            InvocationManagerImpl invMgr = new InvocationManagerImpl();
            theSwitch.setInvocationManager(invMgr);
            NamingManagerImpl nm = new NamingManagerImpl();
            theSwitch.setNamingManager(nm);
            PEORBConfigurator.initTransactionService("com.sun.jts.CosTransactions.DefaultTransactionService");
            J2EETransactionManager tm = J2EETransactionManagerImpl.createTransactionManager();
            theSwitch.setTransactionManager(tm);
            ResourceInstaller installer = theSwitch.getResourceInstaller();
            ConnectorRuntime connRuntime = ConnectorRuntime.getRuntime();
            JmsRaUtil raUtil = new JmsRaUtil();
            raUtil.upgradeIfNecessary();
            String moduleName = ConnectorRuntime.JDBCXA_RA_NAME;
            String moduleLoc = installer.getSystemModuleLocation(moduleName);
            connRuntime.createActiveResourceAdapter(moduleLoc, moduleName, false);
            ManagementObjectManager mgmtObjectMgr = theSwitch.getManagementObjectManager();
            ResourcesUtil resourcesUtil = ResourcesUtil.getInstance(this.serverContext);
            installer.installPersistenceManagerResources();
            installer.installCustomResources();
            installer.installExternalJndiResources();
            installer.installMailResources();
            ContainerFactoryImpl cf = new ContainerFactoryImpl();
            theSwitch.setContainerFactory(cf);
            try {
                _logger.fine("satisfy.optionalpkg.dependency");
                OptionalPkgDependency.satisfyOptionalPackageDependencies();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "optionalpkg.error", e);
            }
            MonitoringHelper.registerTxnMonitoringMBean(new JTSMonitorMBean());
            nm.publishObject("UserTransaction", (java.lang.Object)new UserTransactionImpl(), true);
            this.initRoleMapperFactory();
            ConnectorRuntime.getRuntime().initializeConnectorMonitoring();
            String startupComplete = localStrings.getLocalString("j2ee.started", "J2EE server startup complete.");
            _logger.log(Level.FINE, startupComplete);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "enterprise.j2eeservice_running_exception", ex.toString());
            }
            _logger.log(Level.FINEST, "Exception running j2ee services", ex);
            Log.err.flush();
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private ORB createORB(String[] args) throws Exception {
        Properties props = new Properties();
        J2EEServer.initJTSProperties(true, props);
        ORBManager.init(args, props);
        this.orbInitialPort = ORBManager.getORBInitialPort();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, localStrings.getLocalString("j2ee.listenPort", "J2EE server listen port: ") + this.orbInitialPort);
        }
        return ORBManager.getORB();
    }

    public static void initJTSProperties(boolean lateRegistration, Properties props) {
        if (!lateRegistration) {
            props.put("com.sun.corba.ee.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
        }
        com.sun.jts.CosTransactions.Configuration.setAsAppClientConatiner(false);
        ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
        TransactionService txnService = null;
        try {
            IiopListener iiopListener;
            txnService = ServerBeansFactory.getTransactionServiceBean(ctx);
            props.put("com.sun.jts.heuristicDirection", txnService.getHeuristicDecision());
            props.put("com.sun.jts.keypointCount", txnService.getKeypointInterval());
            if (txnService.isAutomaticRecovery()) {
                _logger.log(Level.FINE, "Recoverable J2EE Server");
                props.put("com.sun.jts.ManualRecovery", "true");
            }
            boolean disable_distributed_transaction_logging = false;
            ElementProperty[] eprops = txnService.getElementProperty();
            for (int index = 0; index < eprops.length; ++index) {
                if ("disable-distributed-transaction-logging".equals(eprops[index].getName())) {
                    if (!"true".equals(eprops[index].getValue())) {
                        disable_distributed_transaction_logging = false;
                        continue;
                    }
                    disable_distributed_transaction_logging = true;
                    continue;
                }
                if (!"xaresource-txn-timeout".equals(eprops[index].getName())) continue;
                String value = eprops[index].getValue();
                _logger.log(Level.FINE, "XAResource transaction timeout is" + value);
                if (value == null) continue;
                TransactionManagerImpl.setXAResourceTimeOut(Integer.parseInt(value));
            }
            String jtsServerId = String.valueOf(63);
            IiopService iiopServiceBean = ServerBeansFactory.getIiopServiceBean(ctx);
            if (iiopServiceBean != null && (iiopListener = iiopServiceBean.getIiopListener(0)) != null) {
                jtsServerId = iiopListener.getPort();
            }
            props.put(JTS_SERVER_ID, jtsServerId);
            String serverId = String.valueOf(63);
            System.setProperty(J2EE_SERVER_ID_PROP, serverId);
            props.setProperty("com.sun.CORBA.POA.ORBServerId", serverId);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "++++ Server id: " + props.getProperty("com.sun.CORBA.POA.ORBServerId"));
            }
            if (txnService.isAutomaticRecovery() || !txnService.isAutomaticRecovery() && !disable_distributed_transaction_logging) {
                String logdir = txnService.getTxLogDir();
                if (logdir == null) {
                    Domain svr = null;
                    svr = ServerBeansFactory.getDomainBean(ctx);
                    logdir = svr.getLogRoot();
                    if (logdir == null) {
                        logdir = FileUtil.getAbsolutePath(".." + File.separator + "logs");
                    }
                } else if (!new File(logdir).isAbsolute()) {
                    _logger.log(Level.WARNING, "enterprise.relative_tx_log_dir", logdir);
                    Domain svr = null;
                    svr = ServerBeansFactory.getDomainBean(ctx);
                    String logroot = svr.getLogRoot();
                    logdir = logroot != null ? logroot + File.separator + logdir : FileUtil.getAbsolutePath(".." + File.separator + "logs" + File.separator + logdir);
                }
                logdir = logdir + File.separator + "tx";
                _logger.log(Level.FINE, "JTS log directory: " + logdir);
                _logger.log(Level.FINE, "JTS Server id " + jtsServerId);
                new File(logdir).mkdirs();
                props.put("com.sun.jts.logDirectory", logdir);
            }
            props.put("com.sun.jts.commitRetry", txnService.getRetryTimeoutInSeconds());
        }
        catch (ConfigException e) {
            throw new RuntimeException("Error reading configuration : " + e);
        }
        com.sun.jts.CosTransactions.Configuration.setProperties(props);
    }

    private void initRoleMapperFactory() throws Exception {
        java.lang.Object o = null;
        Class<?> c = null;
        try {
            c = Class.forName("com.sun.enterprise.security.acl.RoleMapperFactory");
            if (c != null && (o = c.newInstance()) != null && o instanceof SecurityRoleMapperFactory) {
                SecurityRoleMapperFactoryMgr.registerFactory(o);
            }
            if (o == null) {
                _logger.log(Level.SEVERE, localStrings.getLocalString("j2ee.norolemapper", "Cannot instantiate the SecurityRoleMapperFactory"));
            }
        }
        catch (Exception cnfe) {
            _logger.log(Level.SEVERE, localStrings.getLocalString("j2ee.norolemapper", "Cannot instantiate the SecurityRoleMapperFactory"), cnfe);
            throw cnfe;
        }
    }

    private void bindObject(ORB orb, String publishedName, Remote remote) throws RemoteException, NamingException {
        Tie servantsTie = Util.getTie(remote);
        servantsTie.orb(orb);
        NamingManager namingMgr = Switch.getSwitch().getNamingManager();
        namingMgr.publishObject(publishedName, (java.lang.Object)servantsTie, true);
    }

    private long readSecureSeed(File fname) {
        try {
            BufferedReader fis = new BufferedReader(new FileReader(fname));
            try {
                String line = fis.readLine();
                fis.close();
                Long lseed = new Long(line);
                return lseed;
            }
            catch (IOException e) {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        secureRandom.setSeed(System.currentTimeMillis());
        long newSeed = secureRandom.nextLong();
        return newSeed;
    }

    private void writeSecureSeed(File fname, long seed) {
        try {
            FileOutputStream fos = new FileOutputStream(fname);
            String sseed = Long.toString(seed);
            fos.write(sseed.getBytes());
            fos.close();
        }
        catch (IOException e) {
            String errmsg = localStrings.getLocalString("j2ee.startupslow", "Cannot write the seed file for fast startup. The next startup will be slow.");
            _logger.log(Level.WARNING, "enterprise.j2ee_startupslow");
        }
    }

    public static void main(ServerContext serverContext) throws ServerLifecycleException {
        String[] args = serverContext.getCmdLineArgs();
        if (args == null) {
            args = new String[]{};
        }
        Utility.checkJVMVersion();
        boolean verbose = false;
        boolean startJMS = true;
        if (System.getProperty("j2ee.appverification.home") != null) {
            AppVerification.setInstrument(true);
        }
        _logger.log(Level.FINE, "S1AS AVK Instrumentation " + (AppVerification.doInstrument() ? "enabled" : "disabled"));
        try {
            J2EEServer j2ee = new J2EEServer();
            j2ee.setServerContext(serverContext);
            j2ee.run(args, verbose, startJMS);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.run_exception", e);
            if (e.getMessage() != null && _logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "enterprise.j2ee_server_error", e.getMessage());
            }
            _logger.log(Level.SEVERE, "enterprise.j2ee_server_error1");
            System.err.flush();
            throw new ServerLifecycleException(e.getMessage(), e);
        }
    }

    private void setServerContext(ServerContext serverContext) {
        this.serverContext = serverContext;
    }

    public static void shutdown() {
        block6: {
            PEMain.shutdownStarted = true;
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, localStrings.getLocalString("j2ee.shutdown", "Shutting down the J2EE server..."));
                }
                if (AppVerification.doInstrument()) {
                    AppVerification.getInstrumentLogger().writeResults();
                }
                Log.flushAll();
            }
            catch (Throwable t) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "enterprise.shutdown_exception", t.toString());
                }
                if (!_logger.isLoggable(Level.FINE)) break block6;
                _logger.log(Level.FINE, localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdown the J2EE server..."));
            }
        }
        if (!PEMain.shutdownThreadInvoked) {
            System.exit(0);
        }
    }

    static {
        secureRandom.setSeed(System.currentTimeMillis());
        localStrings = new LocalStringManagerImpl(J2EEServer.class);
        ostream = System.out;
        estream = System.err;
    }
}

