/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.util.RelativePathResolver;
import java.util.logging.Level;

public class DASResourcesUtil
extends ResourcesUtil {
    public boolean getConnectionFromConnectorRuntime_ = false;

    protected DASResourcesUtil() {
    }

    protected boolean isReferenced(String resourceName) throws ConfigException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("isReferenced in DASResourcesUtil:: " + resourceName);
        }
        if (this.isGetConnectionFromConnectorRuntime()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("getConnectionFromConnectorRuntime :: true");
            }
            return true;
        }
        return super.isReferenced(resourceName);
    }

    public boolean isGetConnectionFromConnectorRuntime() {
        return this.getConnectionFromConnectorRuntime_;
    }

    public void setGetConnectionFromConnectorRuntime(boolean flag) {
        this.getConnectionFromConnectorRuntime_ = flag;
    }

    public String getLocation(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        ConfigContext adminConfigCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        try {
            ConnectorModule connectorModule = ServerBeansFactory.getDomainBean(adminConfigCtx).getApplications().getConnectorModuleByName(moduleName);
            if (connectorModule == null) {
                return null;
            }
            String connectorModuleLocation = connectorModule.getLocation();
            String connectorModuleLocationResolved = RelativePathResolver.resolvePath(connectorModuleLocation);
            return connectorModuleLocationResolved;
        }
        catch (ConfigException e) {
            _logger.warning(e.getMessage());
            _logger.log(Level.FINE, "Exception while tryign to find locationof connector module " + moduleName, new Object[]{e});
            return null;
        }
    }

    public String getApplicationDeployLocation(String appName) {
        ConfigContext adminConfigCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        try {
            J2eeApplication app = ServerBeansFactory.getDomainBean(adminConfigCtx).getApplications().getJ2eeApplicationByName(appName);
            return RelativePathResolver.resolvePath(app.getLocation());
        }
        catch (ConfigException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PersistenceManagerFactoryResource getPMFResourceByJndiName(String jndiName) {
        this.reinitialize();
        Resources localRes = this.getResourcesServerBean();
        if (localRes == null) {
            return null;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourceUtil :: looking up pmf resource, jndiName is :" + jndiName);
        }
        PersistenceManagerFactoryResource pmf = localRes.getPersistenceManagerFactoryResourceByJndiName(jndiName);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("getPMFResourceByJndiName:: looked up pmf resource : " + pmf);
        }
        if (pmf == null) {
            return null;
        }
        try {
            return this.isReferenced(jndiName) ? pmf : null;
        }
        catch (ConfigException ce) {
            return null;
        }
    }

    public JdbcResource getJdbcResourceByJndiName(String jndiName) {
        this.reinitialize();
        Resources localRes = this.getResourcesServerBean();
        if (localRes == null) {
            return null;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: looking up jdbc resource, jndiName is :" + jndiName);
        }
        JdbcResource jdbcRes = localRes.getJdbcResourceByJndiName(jndiName);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: looked up jdbc resource:" + jdbcRes.getJndiName());
        }
        if (jdbcRes == null) {
            return null;
        }
        try {
            return this.isReferenced(jndiName) ? jdbcRes : null;
        }
        catch (ConfigException ce) {
            return null;
        }
    }

    public boolean isPMFResource(String jndiName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: checking if this is a pmf resource:" + jndiName);
        }
        return this.getPMFResourceByJndiName(jndiName) != null;
    }

    protected DeferredResourceConfig getDeferredJdbcResourceConfigs(String resourceName) {
        String cmpResourceName;
        if (resourceName == null) {
            return null;
        }
        this.reinitialize();
        try {
            if (!resourceName.endsWith("__pm") && !this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (ConfigException e) {
            _logger.log(Level.WARNING, e.getMessage());
            _logger.log(Level.FINE, "Error while finding resource references ", e);
        }
        Resources localRes = this.getResourcesServerBean();
        if (localRes == null) {
            return null;
        }
        ConfigBean[] resourcesToload = new ConfigBean[2];
        JdbcResource jdbcResource = localRes.getJdbcResourceByJndiName(resourceName);
        if (!(jdbcResource != null && jdbcResource.isEnabled() || (jdbcResource = localRes.getJdbcResourceByJndiName(cmpResourceName = this.getCorrespondingCmpResourceName(resourceName))) != null)) {
            return null;
        }
        JdbcConnectionPool jdbcPool = localRes.getJdbcConnectionPoolByName(jdbcResource.getPoolName());
        if (jdbcPool == null) {
            return null;
        }
        String rarName = this.getRAForJdbcConnectionPool(jdbcPool);
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = jdbcPool;
            resourcesToload[1] = jdbcResource;
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, null, null, jdbcPool, jdbcResource, null);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredJdbcPoolConfigs(String poolName) {
        if (poolName == null) {
            return null;
        }
        this.reinitialize();
        Resources localRes = this.getResourcesServerBean();
        JdbcConnectionPool jdbcPool = localRes.getJdbcConnectionPoolByName(poolName);
        if (jdbcPool == null) {
            return null;
        }
        String rarName = this.getRAForJdbcConnectionPool(jdbcPool);
        ConfigBean[] resourcesToload = new ConfigBean[1];
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = jdbcPool;
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, null, null, jdbcPool, null, null);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected Resources getResourcesServerBean() {
        if (!this.isGetConnectionFromConnectorRuntime()) {
            return super.getResourcesServerBean();
        }
        ConfigContext adminConfigCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        Domain localdom = null;
        Resources localres = null;
        try {
            localdom = ServerBeansFactory.getDomainBean(adminConfigCtx);
            localres = localdom.getResources();
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, ce.getMessage());
            return null;
        }
        return localres;
    }

    protected DeferredResourceConfig getDeferredConnectorResourceConfigs(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        this.reinitialize();
        try {
            if (!this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (ConfigException e) {
            _logger.log(Level.WARNING, e.getMessage());
            _logger.log(Level.FINE, "Error while finding resource references ", e);
        }
        Resources localRes = this.getResourcesServerBean();
        if (localRes == null) {
            return null;
        }
        ConfigBean[] resourcesToload = new ConfigBean[2];
        ConnectorResource connectorResource = localRes.getConnectorResourceByJndiName(resourceName);
        if (connectorResource == null || !connectorResource.isEnabled()) {
            return null;
        }
        String poolName = connectorResource.getPoolName();
        ConnectorConnectionPool ccPool = localRes.getConnectorConnectionPoolByName(poolName);
        if (ccPool == null) {
            return null;
        }
        String rarName = ccPool.getResourceAdapterName();
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = ccPool;
            resourcesToload[1] = connectorResource;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{localRes.getResourceAdapterConfigByResourceAdapterName(rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, ccPool, connectorResource, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredConnectorPoolConfigs(String poolName) {
        if (poolName == null) {
            return null;
        }
        this.reinitialize();
        Resources localRes = this.getResourcesServerBean();
        ConfigBean[] resourcesToload = new ConfigBean[1];
        ConnectorConnectionPool ccPool = localRes.getConnectorConnectionPoolByName(poolName);
        if (ccPool == null) {
            return null;
        }
        String rarName = ccPool.getResourceAdapterName();
        if (rarName != null) {
            resourcesToload[0] = ccPool;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{localRes.getResourceAdapterConfigByResourceAdapterName(rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, ccPool, null, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredAdminObjectConfigs(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        this.reinitialize();
        try {
            if (!this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (ConfigException e) {
            _logger.log(Level.WARNING, e.getMessage());
            _logger.log(Level.FINE, "Error while finding resource references ", e);
        }
        Resources localRes = this.getResourcesServerBean();
        if (localRes == null) {
            return null;
        }
        ConfigBean[] resourcesToload = new ConfigBean[1];
        AdminObjectResource adminObjectResource = localRes.getAdminObjectResourceByJndiName(resourceName);
        if (adminObjectResource == null || !adminObjectResource.isEnabled()) {
            return null;
        }
        String rarName = adminObjectResource.getResAdapter();
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = adminObjectResource;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{localRes.getResourceAdapterConfigByResourceAdapterName(rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, adminObjectResource, null, null, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }
}

