/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.ApplicationDeployEventListener;
import com.sun.enterprise.admin.event.DeployEventListenerHelper;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.autodeploy.AutoDirReDeployer;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.enterprise.server.AbstractManager;
import com.sun.enterprise.server.ApplicationLoader;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ConnectorResourcesLoader;
import com.sun.enterprise.server.MonitorableEntry;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.pluggable.ApplicationLoaderFactory;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

class ApplicationManager
extends AbstractManager
implements ApplicationDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(ApplicationManager.class);

    ApplicationManager(AppsManager appsManager, ClassLoader connectorClassLoader) {
        super(connectorClassLoader, appsManager);
        AdminEventListenerRegistry.addApplicationDeployEventListener(this);
    }

    protected AbstractLoader getLoader(String id) {
        PluggableFeatureFactory featureFactory = ApplicationServer.getServerContext().getPluggableFeatureFactory();
        ApplicationLoaderFactory appLoaderFactory = featureFactory.getApplicationLoaderFactory();
        ApplicationLoader appLoader = appLoaderFactory.createApplicationLoader(id, this.parentClassLoader, (AppsManager)this.configManager);
        _logger.log(Level.FINEST, "ApplicationLoader " + appLoader);
        return appLoader;
    }

    boolean applicationDeployed(String appID) {
        return this.applicationDeployed(false, appID, true);
    }

    boolean applicationDeployed(boolean jsr77, String appID) {
        return this.applicationDeployed(jsr77, appID, true);
    }

    boolean applicationDeployed(boolean jsr77, String appID, ConfigContext dynamicConfigContext) {
        return this.applicationDeployed(jsr77, appID, true, dynamicConfigContext);
    }

    boolean applicationDeployed(boolean jsr77, String appID, boolean addToRM) {
        return this.applicationDeployed(jsr77, appID, addToRM, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean applicationDeployed(boolean jsr77, String appID, boolean addToRM, ConfigContext dynamicConfigContext) {
        AbstractLoader appLoader;
        boolean deployed;
        block25: {
            deployed = false;
            boolean loadJSR77 = jsr77 || this.loadJSR77(appID, DeployableObjectType.APP);
            appLoader = null;
            try {
                try {
                    if (addToRM) {
                        this.addToReloadMonitor(appID);
                    }
                    appLoader = this.getLoader(appID);
                    appLoader.setConfigContext(dynamicConfigContext);
                    if (loadJSR77) {
                        try {
                            appLoader.createRootMBean();
                        }
                        catch (MBeanException mbe) {
                            _logger.log(Level.WARNING, "core.error_while_creating_jsr77_root_mbean", mbe);
                        }
                    }
                    if (this.isEnabled(dynamicConfigContext, appID)) {
                        _logger.log(Level.FINEST, "[ApplicationManager] Application is enabled: " + appID);
                        if (this.id2loader.get(appID) != null) {
                            boolean mbe = true;
                            Object var12_14 = null;
                            if (appLoader == null) return mbe;
                            appLoader.setConfigContext(null);
                            return mbe;
                        }
                        try {
                            appLoader.setState(0);
                        }
                        catch (MBeanException mbe) {
                            _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                        }
                        boolean retSts = appLoader.load(jsr77);
                        if (retSts) {
                            try {
                                appLoader.setState(1);
                            }
                            catch (MBeanException mbe) {
                                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                            }
                            this.id2loader.put(appID, appLoader);
                            deployed = true;
                            SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryMgr.getFactory();
                            if (factory == null) {
                                throw new IllegalArgumentException(localStrings.getString("enterprise.deployment.deployment.norolemapperfactorydefine", "This application has no role mapper factory defined"));
                            }
                            break block25;
                        }
                        if (loadJSR77) {
                            try {
                                appLoader.deleteLeafAndRootMBeans();
                            }
                            catch (MBeanException mbe) {
                                _logger.log(Level.WARNING, "core.error_while_deleting_jsr77_leaf_and_root_mbean", mbe);
                            }
                        } else {
                            try {
                                appLoader.setState(4);
                            }
                            catch (MBeanException mbe) {
                                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                            }
                        }
                        try {
                            appLoader.done();
                        }
                        catch (Throwable thr) {
                            String msg = localStrings.getString("core.application_not_loaded", appID);
                            _logger.log(Level.INFO, msg, thr);
                        }
                        _logger.log(Level.WARNING, "core.application_not_loaded", appID);
                        break block25;
                    }
                    _logger.log(Level.INFO, "core.application_disabled", appID);
                    deployed = false;
                }
                catch (ConfigException confEx) {
                    _logger.log(Level.WARNING, "core.error_while_loading_app", confEx);
                    Object var12_16 = null;
                    if (appLoader == null) return deployed;
                    appLoader.setConfigContext(null);
                    return deployed;
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                if (appLoader == null) throw throwable;
                appLoader.setConfigContext(null);
                throw throwable;
            }
        }
        Object var12_15 = null;
        if (appLoader == null) return deployed;
        appLoader.setConfigContext(null);
        return deployed;
    }

    boolean applicationUndeployed(String appID) {
        return this.applicationUndeployed(false, appID, true);
    }

    boolean applicationUndeployed(boolean jsr77, String appID) {
        return this.applicationUndeployed(jsr77, appID, true);
    }

    boolean applicationUndeployed(boolean jsr77, String appID, boolean clearRM) {
        return this.applicationUndeployed(jsr77, appID, clearRM, false);
    }

    boolean applicationUndeployed(boolean jsr77, String appID, boolean clearRM, boolean cascade) {
        AbstractLoader appLoader;
        if (clearRM) {
            this.removeFromReloadMonitor(appID);
        }
        if ((appLoader = (AbstractLoader)this.id2loader.remove(appID)) == null) {
            return true;
        }
        appLoader.setCascade(cascade);
        try {
            appLoader.setState(2);
        }
        catch (MBeanException mbe) {
            _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
        }
        Application app = appLoader.getApplication();
        RoleMapper.removeRoleMapper(app.getRoleMapper().getName());
        if (jsr77) {
            try {
                appLoader.deleteLeafAndRootMBeans();
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "core.error_while_deleting_jsr77_leaf_and_root_mbeans", mbe);
            }
        } else {
            try {
                appLoader.setState(3);
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
            }
        }
        boolean undeployed = appLoader.unload(jsr77);
        if (undeployed) {
            if (app.getEjbComponentCount() > 0) {
                _logger.log(Level.INFO, "core.application_unloaded_ejb", appID);
            }
        } else {
            _logger.log(Level.INFO, "core.application_not_unloaded", appID);
        }
        return undeployed;
    }

    private void holdRequest() {
    }

    private void holdRequest(String appID) {
    }

    public synchronized boolean reload(MonitorableEntry entry) {
        String appName = entry.getId();
        boolean status = false;
        try {
            DeploymentRequest req = new DeploymentRequest(this.configManager.getInstanceEnvironment(), DeployableObjectType.APP, DeploymentCommand.DEPLOY);
            req.setFileSource(entry.getMonitoredFile().getParentFile());
            req.setName(appName);
            req.setForced(true);
            AutoDirReDeployer deployer = new AutoDirReDeployer(req);
            status = deployer.redeploy();
        }
        catch (IASDeploymentException de) {
            _logger.log(Level.WARNING, "core.error_while_redeploying_app", de);
            return false;
        }
        return status;
    }

    public synchronized void applicationDeployed(ApplicationDeployEvent event) throws AdminEventListenerException {
        try {
            AbstractLoader appLoader;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + event.toString());
            }
            DeployEventListenerHelper.getDeployEventListenerHelper().synchronize(event);
            this.configManager.refreshConfigContext(event.getConfigContext());
            boolean jsr77 = false;
            String action = event.getAction();
            if (action.equals("deploy") || action.equals("redeploy")) {
                jsr77 = true;
            }
            String appName = event.getApplicationName();
            ConnectorResourcesLoader connecorResourcesLoader = null;
            if (event.getForceDeploy()) {
                ResourcesUtil.getInstance().setConfigContext(event.getConfigContext());
                ResourcesUtil.getInstance().setReinitConfigContext(false);
                ServerContext sc = ApplicationServer.getServerContext();
                connecorResourcesLoader = new ConnectorResourcesLoader(sc);
                connecorResourcesLoader.loadEmbeddedRarRAConfigs(appName);
            }
            if (this.isEnabled(event.getConfigContext(), appName) && !this.applicationDeployed(jsr77, appName, event.getConfigContext())) {
                String msg = localStrings.getString("applicationmgr.application_deployed_failed", appName);
                throw new AdminEventListenerException(msg);
            }
            if (event.getForceDeploy() && (appLoader = (AbstractLoader)this.id2loader.get(appName)) != null) {
                Application appDescriptor = appLoader.getApplication();
                connecorResourcesLoader.loadEmbeddedRarResources(appName, appDescriptor);
            }
        }
        catch (ConfigException ce) {
            throw new AdminEventListenerException(ce.getMessage());
        }
        finally {
            ResourcesUtil.getInstance().setReinitConfigContext(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void applicationUndeployed(ApplicationDeployEvent event) throws AdminEventListenerException {
        boolean jsr77 = false;
        String action = event.getAction();
        if (action.equals("undeploy") || action.equals("redeploy")) {
            jsr77 = true;
        }
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + event.toString());
            }
            this.configManager.refreshConfigContext(event.getOldConfigContext());
            String appName = event.getApplicationName();
            if (event.getForceDeploy()) {
                event.setCascade(true);
            }
            boolean undeployed = false;
            ResourcesUtil resutil = ResourcesUtil.getInstance();
            resutil.setConfigContext(event.getConfigContext());
            resutil.setReinitConfigContext(false);
            try {
                undeployed = this.applicationUndeployed(jsr77, appName, true, event.getCascade());
            }
            finally {
                resutil.setReinitConfigContext(true);
            }
            if (!undeployed) {
                String msg = localStrings.getString("applicationmgr.application_undeployed_failed", appName);
                throw new AdminEventListenerException(msg);
            }
        }
        catch (ConfigException ce) {
            throw new AdminEventListenerException(ce.getMessage());
        }
    }

    public synchronized void applicationRedeployed(ApplicationDeployEvent event) throws AdminEventListenerException {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + event.toString());
            }
            this.configManager.refreshConfigContext(event.getConfigContext());
            String appName = event.getApplicationName();
            boolean ok = this.applicationUndeployed(true, appName);
            if (ok) {
                ok = this.applicationDeployed(true, appName, event.getConfigContext());
            }
            if (!ok) {
                String msg = localStrings.getString("applicationmgr.application_redeployed_failed", appName);
                throw new AdminEventListenerException(msg);
            }
        }
        catch (ConfigException ce) {
            throw new AdminEventListenerException(ce.getMessage());
        }
    }

    public synchronized void applicationEnabled(ApplicationDeployEvent event) throws AdminEventListenerException {
        ResourcesUtil resutil = ResourcesUtil.getInstance();
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + event.toString());
            }
            if (!this.isEnabled(event.getConfigContext(), event.getApplicationName())) {
                return;
            }
            this.configManager.refreshConfigContext(event.getConfigContext());
            String appName = event.getApplicationName();
            boolean cascade = true;
            ServerContext sc = ApplicationServer.getServerContext();
            ConnectorResourcesLoader connecorResourcesLoader = new ConnectorResourcesLoader(sc);
            resutil.setConfigContext(event.getConfigContext());
            resutil.setReinitConfigContext(false);
            connecorResourcesLoader.loadEmbeddedRarRAConfigs(appName);
            boolean enabled = this.applicationDeployed(false, appName, event.getConfigContext());
            if (!enabled) {
                String msg = localStrings.getString("applicationmgr.application_enabled_failed", appName);
                throw new AdminEventListenerException(msg);
            }
            AbstractLoader appLoader = (AbstractLoader)this.id2loader.get(appName);
            Application appDescriptor = appLoader.getApplication();
            connecorResourcesLoader.loadEmbeddedRarResources(appName, appDescriptor);
        }
        catch (ConfigException ce) {
            throw new AdminEventListenerException(ce.getMessage());
        }
        catch (Throwable th) {
            AdminEventListenerException aele = new AdminEventListenerException(th.getMessage());
            aele.initCause(th);
            throw aele;
        }
        finally {
            resutil.setReinitConfigContext(true);
        }
    }

    public synchronized void applicationDisabled(ApplicationDeployEvent event) throws AdminEventListenerException {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + event.toString());
            }
            this.configManager.refreshConfigContext(event.getConfigContext());
            String appName = event.getApplicationName();
            AbstractLoader appLoader = (AbstractLoader)this.id2loader.get(appName);
            if (appLoader == null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[ApplicationManager] appLoader Null. Returning applicationDisabled");
                }
                return;
            }
            event.setCascade(true);
            boolean disabled = this.applicationUndeployed(false, appName, true, true);
            if (!disabled) {
                String msg = localStrings.getString("applicationmgr.application_disabled_failed", appName);
                throw new AdminEventListenerException(msg);
            }
        }
        catch (ConfigException ce) {
            throw new AdminEventListenerException(ce.getMessage());
        }
    }

    public void applicationReferenceAdded(ApplicationDeployEvent event) throws AdminEventListenerException {
    }

    public void applicationReferenceRemoved(ApplicationDeployEvent event) throws AdminEventListenerException {
    }
}

