/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.wss;

import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ClientAuthContext;
import com.sun.enterprise.security.jauth.FailureException;
import com.sun.enterprise.security.jauth.PendingException;
import com.sun.enterprise.security.jauth.SOAPAuthParam;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.soap.SOAPMessageContext;

public class WebServiceSecurity {
    private static Logger _logger = null;
    private static final String SHARED_CLIENT_STATE = "com.sun.enterprise.security.jauth.ClientHashMap";
    private static final String SHARED_SERVER_STATE = "com.sun.enterprise.security.jauth.ServerHashMap";

    private WebServiceSecurity() {
    }

    public static boolean validateRequest(SOAPMessageContext context, ServerAuthContext sAC) throws AuthException {
        Set<Principal> principalSet;
        boolean rvalue = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Container Auth: ServerAuthContext.validateRequest");
        }
        Subject subject = null;
        boolean firstAuthentication = true;
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc == null || sc.didServerGenerateCredentials()) {
            subject = new Subject();
        } else {
            subject = sc.getSubject();
            firstAuthentication = false;
        }
        SOAPAuthParam param = new SOAPAuthParam(context.getMessage(), null);
        HashMap sharedState = new HashMap();
        context.setProperty(SHARED_SERVER_STATE, sharedState);
        try {
            sAC.validateRequest(param, subject, sharedState);
        }
        catch (PendingException pe) {
            _logger.log(Level.FINE, "Container-auth: wss: Error validating request  ", pe);
            context.setMessage(param.getResponse());
            rvalue = false;
        }
        catch (FailureException fe) {
            _logger.log(Level.FINE, "Container-auth: wss: Error validating request  ", fe);
            context.setMessage(param.getResponse());
            throw fe;
        }
        if (rvalue && firstAuthentication && (principalSet = subject.getPrincipals()) != null && !principalSet.isEmpty()) {
            String initiator = principalSet.iterator().next().getName();
            SecurityContext newSC = new SecurityContext(initiator, subject);
            SecurityContext.setCurrent(newSC);
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void secureResponse(SOAPMessageContext context, ServerAuthContext sAC) throws AuthException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Container Auth: ServerAuthContext.secureResponse");
        }
        SecurityContext sc = SecurityContext.getCurrent();
        Subject subject = sc.getSubject();
        SOAPAuthParam param = new SOAPAuthParam(null, context.getMessage());
        HashMap sharedState = (HashMap)context.getProperty(SHARED_SERVER_STATE);
        try {
            sAC.secureResponse(param, subject, sharedState);
        }
        finally {
            sAC.disposeSubject(subject, sharedState);
        }
    }

    public static void secureRequest(SOAPMessageContext context, ClientAuthContext cAC, boolean isAppClient) throws AuthException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Container Auth: ClientAuthContext.secureRequest");
        }
        SOAPAuthParam param = new SOAPAuthParam(context.getMessage(), null);
        HashMap sharedState = new HashMap();
        context.setProperty(SHARED_CLIENT_STATE, sharedState);
        Subject subject = null;
        if (isAppClient) {
            ClientSecurityContext sc = ClientSecurityContext.getCurrent();
            if (sc != null) {
                subject = sc.getSubject();
            }
        } else {
            SecurityContext sc = SecurityContext.getCurrent();
            if (sc != null && !sc.didServerGenerateCredentials()) {
                subject = sc.getSubject();
            }
        }
        if (subject == null) {
            subject = new Subject();
        }
        cAC.secureRequest(param, subject, sharedState);
    }

    public static boolean validateResponse(SOAPMessageContext context, ClientAuthContext cAC) throws AuthException {
        boolean rvalue = true;
        SOAPAuthParam param = new SOAPAuthParam(null, context.getMessage());
        HashMap sharedState = (HashMap)context.getProperty(SHARED_CLIENT_STATE);
        Subject responderSubject = new Subject();
        try {
            cAC.validateResponse(param, responderSubject, sharedState);
        }
        catch (AuthException ae) {
            _logger.log(Level.SEVERE, "Container-auth: wss: Error validating response  ", ae);
            rvalue = false;
            throw ae;
        }
        finally {
            cAC.disposeSubject(responderSubject, sharedState);
        }
        return rvalue;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

