/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jauth;

import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.security.jauth.ClientAuthContext;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import javax.security.auth.callback.CallbackHandler;

public abstract class AuthConfig {
    public static final String HTTP = "HTTP";
    public static final String EJB = "EJB";
    public static final String SOAP = "SOAP";
    private static final String AUTHCONFIG_PROPERTY = "authconfig.provider";
    private static final String DEFAULT_CLASS = "com.sun.enterprise.security.jauth.ConfigFile";
    private static AuthConfig config;
    static ClassLoader contextClassLoader;

    protected AuthConfig() {
    }

    public static synchronized AuthConfig getAuthConfig() {
        if (config == null) {
            String config_class = null;
            config_class = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty(AuthConfig.AUTHCONFIG_PROPERTY);
                }
            });
            if (config_class == null) {
                config_class = DEFAULT_CLASS;
            }
            try {
                final String finalClass = config_class;
                config = (AuthConfig)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                        return Class.forName(finalClass, true, contextClassLoader).newInstance();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (SecurityException)new SecurityException().initCause(e.getException());
            }
        }
        return config;
    }

    public static void setAuthConfig(AuthConfig config) {
        AuthConfig.config = config;
    }

    public abstract ClientAuthContext getClientAuthContext(String var1, String var2, AuthPolicy var3, AuthPolicy var4, CallbackHandler var5) throws AuthException;

    public abstract ServerAuthContext getServerAuthContext(String var1, String var2, AuthPolicy var3, AuthPolicy var4, CallbackHandler var5) throws AuthException;

    static {
        contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

