/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.Group;
import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class RoleMapper
implements Serializable,
SecurityRoleMapper {
    private static Map ROLEMAPPER;
    private static final String DEFAULT_ROLE_NAME = "ANYONE";
    private static Role defaultRole;
    private static String defaultRoleName;
    private String appName;
    private final Map roleToSubject = new HashMap();
    private final Map roleToPrincipal = new HashMap();
    private final Map roleToGroup = new HashMap();
    private static Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RoleMapper(String appName) {
        this.appName = appName;
        Switch sw = Switch.getSwitch();
        if (sw.getContainerType() == 2) {
            RoleMapper.initDefaultRole();
        }
    }

    private static synchronized void initDefaultRole() {
        if (defaultRole == null) {
            defaultRoleName = DEFAULT_ROLE_NAME;
            try {
                ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
                if (!$assertionsDisabled && configContext == null) {
                    throw new AssertionError();
                }
                Server configBean = ServerBeansFactory.getServerBean(configContext);
                if (!$assertionsDisabled && configBean == null) {
                    throw new AssertionError();
                }
                SecurityService securityBean = ServerBeansFactory.getSecurityServiceBean(configContext);
                if (!$assertionsDisabled && securityBean == null) {
                    throw new AssertionError();
                }
                defaultRoleName = securityBean.getAnonymousRole();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "java_security.anonymous_role_reading_exception", e);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Default role is: " + defaultRoleName);
            }
            defaultRole = new Role(defaultRoleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoleMapper getRoleMapper(String appName) {
        RoleMapper r = (RoleMapper)ROLEMAPPER.get(appName);
        if (r == null) {
            r = new RoleMapper(appName);
            Class clazz = RoleMapper.class;
            synchronized (clazz) {
                ROLEMAPPER.put(appName, r);
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRoleMapper(String appName, SecurityRoleMapper rmap) {
        Class clazz = RoleMapper.class;
        synchronized (clazz) {
            ROLEMAPPER.put(appName, rmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRoleMapper(String appName) {
        if (ROLEMAPPER.containsKey(appName)) {
            Class clazz = RoleMapper.class;
            synchronized (clazz) {
                ROLEMAPPER.remove(appName);
            }
        }
    }

    public String getName() {
        return this.appName;
    }

    public void setName(String name) {
        this.appName = name;
    }

    private void addRoleToPrincipal(final Principal principal, String role) {
        if (!$assertionsDisabled && this.roleToSubject == null) {
            throw new AssertionError();
        }
        Subject subject = (Subject)this.roleToSubject.get(role);
        final Subject sub = subject == null ? new Subject() : subject;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sub.getPrincipals().add(principal);
                return null;
            }
        });
        this.roleToSubject.put(role, sub);
    }

    public void unassignPrincipalFromRole(Role role, Principal principal) {
        if (!$assertionsDisabled && this.roleToSubject == null) {
            throw new AssertionError();
        }
        String mrole = role.getName();
        final Subject sub = (Subject)this.roleToSubject.get(mrole);
        final Principal p = principal;
        if (sub != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    sub.getPrincipals().remove(p);
                    return null;
                }
            });
            this.roleToSubject.put(mrole, sub);
        }
        Map tmp = null;
        tmp = principal instanceof Group ? this.roleToGroup : this.roleToPrincipal;
        Vector v = (Vector)tmp.get(mrole);
        if (v != null) {
            v.remove(principal);
            tmp.put(mrole, v);
        }
    }

    public Map getRoleToSubjectMapping() {
        if (!$assertionsDisabled && this.roleToSubject == null) {
            throw new AssertionError();
        }
        return this.roleToSubject;
    }

    public void assignRole(Principal p, Role r) {
        String role = r.getName();
        Map tmp_map = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SECURITY:RoleMapper Assigning Role " + role + " to  " + p.getName());
        }
        this.addRoleToPrincipal(p, role);
        tmp_map = p instanceof Group ? this.roleToGroup : this.roleToPrincipal;
        Vector<Principal> _principals = (Vector<Principal>)tmp_map.get(role);
        if (_principals == null) {
            _principals = new Vector<Principal>();
        }
        _principals.add(p);
        tmp_map.put(role, _principals);
    }

    public Iterator getRoles() {
        if (!$assertionsDisabled && this.roleToSubject == null) {
            throw new AssertionError();
        }
        return this.roleToSubject.keySet().iterator();
    }

    public Enumeration getGroupsAssignedTo(Role r) {
        if (!$assertionsDisabled && this.roleToGroup == null) {
            throw new AssertionError();
        }
        Vector v = (Vector)this.roleToGroup.get(r.getName());
        v = v == null ? new Vector() : v;
        return v.elements();
    }

    public Enumeration getUsersAssignedTo(Role r) {
        if (!$assertionsDisabled && this.roleToPrincipal == null) {
            throw new AssertionError();
        }
        Vector v = (Vector)this.roleToPrincipal.get(r.getName());
        v = v == null ? new Vector() : v;
        return v.elements();
    }

    public void unassignRole(Role r) {
        if (r != null) {
            String role = r.getName();
            this.roleToSubject.remove(role);
            this.roleToPrincipal.remove(role);
            this.roleToGroup.remove(role);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("RoleMapper:");
        Iterator e = this.getRoles();
        while (e.hasNext()) {
            String r = (String)e.next();
            s.append("\n\tRole (" + r + ") has Principals(");
            Subject sub = (Subject)this.roleToSubject.get(r);
            Iterator<Principal> it = sub.getPrincipals().iterator();
            while (it.hasNext()) {
                Principal p = it.next();
                s.append(p.getName() + " ");
            }
            s.append(")");
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, s.toString());
        }
        return s.toString();
    }

    public RoleMapper(RoleMapper r) {
        this.appName = r.getName();
        Iterator it = r.getRoles();
        while (it.hasNext()) {
            String role = (String)it.next();
            Enumeration groups = r.getGroupsAssignedTo(new Role(role));
            Vector<Group> groupsToRole = new Vector<Group>();
            while (groups.hasMoreElements()) {
                Group gp = (Group)groups.nextElement();
                groupsToRole.add(new Group(gp.getName()));
                this.addRoleToPrincipal(gp, role);
            }
            this.roleToGroup.put(role, groupsToRole);
            Enumeration users = r.getUsersAssignedTo(new Role(role));
            Vector<PrincipalImpl> usersToRole = new Vector<PrincipalImpl>();
            while (users.hasMoreElements()) {
                PrincipalImpl gp = (PrincipalImpl)users.nextElement();
                usersToRole.add(new PrincipalImpl(gp.getName()));
                this.addRoleToPrincipal(gp, role);
            }
            this.roleToPrincipal.put(role, usersToRole);
        }
    }

    static {
        $assertionsDisabled = !RoleMapper.class.desiredAssertionStatus();
        ROLEMAPPER = new HashMap();
        defaultRole = null;
        defaultRoleName = null;
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

