/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.clientbeans.Ssl;
import com.sun.enterprise.security.KeyTool;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.ssl.UnifiedX509KeyManager;
import com.sun.enterprise.security.ssl.UnifiedX509TrustManager;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.logging.LogDomains;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.web.security.SSLSocketFactory;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public final class SSLUtils {
    private static final String defaultKeyStorePass = "changeit";
    private static final String defaultTrustStorePass = "changeit";
    private static final String keystoreProp = "javax.net.ssl.keyStore";
    private static final String keystorePassProp = "javax.net.ssl.keyStorePassword";
    private static final String truststorePassProp = "javax.net.ssl.trustStorePassword";
    private static Logger _logger = null;
    private static SecuritySupport secSupp = null;
    private static boolean hasKey = false;
    private static KeyManager keyManager = null;
    private static TrustManager trustManager = null;
    private static KeyStore mergedTrustStore = null;
    private static SSLUtils privateKeyEntryProxy = new SSLUtils();
    private static boolean initialized;
    private static Ssl appclientSsl;
    private static HashMap fullCipherNameMap;

    private SSLUtils() {
    }

    private PrivateKeyEntry getPrivateKeyEntry(PrivateKey key, Certificate[] certs) {
        return new PrivateKeyEntry(key, certs);
    }

    public static void initStoresAtStartup() throws Exception {
        if (initialized) {
            return;
        }
        SSLSocketFactory.setManagers(SSLUtils.getKeyManagers(), SSLUtils.getTrustManagers());
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(SSLUtils.getKeyManagers(), SSLUtils.getTrustManagers(), null);
        javax.net.ssl.HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        HttpsURLConnection.setDefaultSSLSocketFactory((javax.net.ssl.SSLSocketFactory)ctx.getSocketFactory());
        initialized = true;
    }

    public static KeyStore[] getKeyStores() throws Exception {
        return secSupp.getKeyStores();
    }

    public static KeyStore getKeyStore() throws Exception {
        return SSLUtils.getKeyStores()[0];
    }

    public static KeyStore[] getTrustStores() throws Exception {
        return secSupp.getTrustStores();
    }

    public static KeyStore getTrustStore() throws Exception {
        return SSLUtils.getTrustStores()[0];
    }

    public static KeyStore getMergedTrustStore() {
        return mergedTrustStore;
    }

    public static KeyManager[] getKeyManagers() throws Exception {
        return new KeyManager[]{keyManager};
    }

    public static TrustManager[] getTrustManagers() throws Exception {
        return new TrustManager[]{trustManager};
    }

    public static void setAppclientSsl(Ssl ssl) {
        appclientSsl = ssl;
    }

    public static Ssl getAppclientSsl() {
        return appclientSsl;
    }

    public static String getKeyStorePass() {
        return System.getProperty(keystorePassProp, "changeit");
    }

    public static String getTrustStorePass() {
        return System.getProperty(truststorePassProp, "changeit");
    }

    public static boolean isKeyAvailable() {
        return hasKey;
    }

    public static boolean isTokenKeyAlias(String certNickname) throws Exception {
        boolean isTokenKeyAlias = false;
        if (certNickname != null) {
            int ind = certNickname.indexOf(58);
            KeyStore[] kstores = SSLUtils.getKeyStores();
            int count = -1;
            String aliasName = null;
            if (ind != -1) {
                String[] tokens = secSupp.getTokenNames();
                String tokenName = certNickname.substring(0, ind);
                aliasName = certNickname.substring(ind + 1);
                for (int i = 0; i < tokens.length; ++i) {
                    if (!tokenName.equals(tokens[i])) continue;
                    count = i;
                }
            }
            if (count != -1) {
                isTokenKeyAlias = kstores[count].isKeyEntry(aliasName);
            } else {
                for (int i = 0; i < kstores.length; ++i) {
                    if (!kstores[i].isKeyEntry(certNickname)) continue;
                    isTokenKeyAlias = true;
                    break;
                }
            }
        }
        return isTokenKeyAlias;
    }

    public static PrivateKeyEntry getPrivateKeyEntryFromTokenAlias(String certNickname) throws Exception {
        PrivateKeyEntry privKeyEntry;
        block3: {
            String[] passwords;
            block5: {
                String aliasName;
                KeyStore[] kstores;
                block4: {
                    privKeyEntry = null;
                    if (certNickname == null) break block3;
                    int ind = certNickname.indexOf(58);
                    kstores = SSLUtils.getKeyStores();
                    int count = -1;
                    aliasName = certNickname;
                    if (ind != -1) {
                        String[] tokens = secSupp.getTokenNames();
                        String tokenName = certNickname.substring(0, ind);
                        aliasName = certNickname.substring(ind + 1);
                        for (int i = 0; i < tokens.length; ++i) {
                            if (!tokenName.equals(tokens[i])) continue;
                            count = i;
                        }
                    }
                    passwords = secSupp.getKeyStorePasswords();
                    if (count == -1 || passwords.length < count) break block4;
                    Key key = kstores[count].getKey(aliasName, passwords[count].toCharArray());
                    if (!(key instanceof PrivateKey)) break block5;
                    PrivateKey privKey = (PrivateKey)key;
                    Certificate[] certs = kstores[count].getCertificateChain(aliasName);
                    privKeyEntry = privateKeyEntryProxy.getPrivateKeyEntry(privKey, certs);
                    break block5;
                }
                for (int i = 0; i < kstores.length; ++i) {
                    Key key = kstores[i].getKey(aliasName, passwords[i].toCharArray());
                    if (key == null || !(key instanceof PrivateKey)) continue;
                    PrivateKey privKey = (PrivateKey)key;
                    Certificate[] certs = kstores[i].getCertificateChain(aliasName);
                    privKeyEntry = privateKeyEntryProxy.getPrivateKeyEntry(privKey, certs);
                    break;
                }
            }
            passwords = null;
        }
        return privKeyEntry;
    }

    private static void initKeyManagers(KeyStore[] kstores, String[] pwds) throws Exception {
        ArrayList<KeyManager> keyManagers = new ArrayList<KeyManager>();
        for (int i = 0; i < kstores.length; ++i) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(kstores[i], pwds[i].toCharArray());
            KeyManager[] kmgrs = kmf.getKeyManagers();
            if (kmgrs == null) continue;
            for (int j = 0; j < kmgrs.length; ++j) {
                keyManagers.add(kmgrs[j]);
            }
        }
        keyManager = new UnifiedX509KeyManager(keyManagers.toArray(new X509KeyManager[keyManagers.size()]), secSupp.getTokenNames());
    }

    private static void initTrustManagers(KeyStore[] tstores) throws Exception {
        ArrayList<TrustManager> trustManagers = new ArrayList<TrustManager>();
        for (int i = 0; i < tstores.length; ++i) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(tstores[i]);
            TrustManager[] tmgrs = tmf.getTrustManagers();
            if (tmgrs == null) continue;
            for (int j = 0; j < tmgrs.length; ++j) {
                trustManagers.add(tmgrs[j]);
            }
        }
        trustManager = trustManagers.size() == 1 ? (TrustManager)trustManagers.get(0) : new UnifiedX509TrustManager(trustManagers.toArray(new X509TrustManager[trustManagers.size()]));
    }

    private static KeyStore mergingTrustStores(KeyStore[] trustStores) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore mergedStore = null;
        try {
            mergedStore = KeyStore.getInstance("CaseExactJKS");
        }
        catch (KeyStoreException ex) {
            mergedStore = KeyStore.getInstance("JKS");
        }
        String[] passwords = secSupp.getKeyStorePasswords();
        mergedStore.load(null, passwords[passwords.length - 1].toCharArray());
        for (int i = 0; i < trustStores.length; ++i) {
            Enumeration<String> aliases = trustStores[i].aliases();
            while (aliases.hasMoreElements()) {
                String alias;
                String alias2 = alias = aliases.nextElement();
                int count = 1;
                while (mergedStore.getCertificate(alias2) != null) {
                    alias2 = alias + "__" + count++;
                }
                mergedStore.setCertificateEntry(alias2, trustStores[i].getCertificate(alias));
            }
        }
        return mergedStore;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        KeyTool.initProvider();
        secSupp = SecurityUtil.getSecuritySupport();
        try {
            KeyStore[] keyStores = SSLUtils.getKeyStores();
            SSLUtils.initKeyManagers(keyStores, secSupp.getKeyStorePasswords());
            SSLUtils.initTrustManagers(SSLUtils.getTrustStores());
            if (keyStores != null && keyStores.length > 0) {
                for (int i = 0; i < keyStores.length; ++i) {
                    Enumeration<String> aliases = keyStores[i].aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (!keyStores[i].isKeyEntry(alias)) continue;
                        hasKey = true;
                        break;
                    }
                    if (hasKey) break;
                }
            }
            mergedTrustStore = SSLUtils.mergingTrustStores(secSupp.getTrustStores());
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SSLUtils static init fails.", ex);
            }
            throw new IllegalStateException(ex.getMessage());
        }
        initialized = false;
        appclientSsl = null;
        fullCipherNameMap = new HashMap();
    }

    public class PrivateKeyEntry {
        PrivateKey key;
        Certificate[] certs;

        PrivateKeyEntry(PrivateKey key, Certificate[] certs) {
            this.key = key;
            this.certs = certs;
        }

        public PrivateKey getPrivateKey() {
            return this.key;
        }

        public Certificate[] getCertificateChain() {
            return this.certs;
        }
    }
}

