/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.monitor;

import com.sun.enterprise.admin.monitor.BaseMonitorMBean;
import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.types.Counter;
import com.sun.enterprise.admin.monitor.types.MonitoredAttributeType;
import com.sun.enterprise.resource.monitor.IASResourcePoolMonitor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;

public class JDBCPoolMonitorMBean
extends BaseMonitorMBean {
    private static final StringManager localStrings = StringManager.getManager("com.sun.enterprise.resource");
    public static final String numThreadsWaiting = "total-threads-waiting";
    public static final String numConnFailedValidation = "total-connections-failed-validation";
    public static final String numConnTimedOut = "total-connections-timed-out";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static Object[][] attrNameTypeArray = new Object[][]{{"total-threads-waiting", Counter.INTEGER}, {"total-connections-failed-validation", Counter.INTEGER}, {"total-connections-timed-out", Counter.INTEGER}};
    private MonitoredObjectType type = MonitoredObjectType.JDBC_CONN_POOL;
    private boolean monitorOn = false;
    private static Map attrNameTypeMap = JDBCPoolMonitorMBean.createAttrNameTypeMap(attrNameTypeArray);
    private static MBeanInfo mBeanInfo = JDBCPoolMonitorMBean.createMBeanInfo(attrNameTypeMap);
    private IASResourcePoolMonitor poolmonitor;

    public JDBCPoolMonitorMBean(IASResourcePoolMonitor poolmonitor) {
        this.poolmonitor = poolmonitor;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        if (attribute == null) {
            String msg = localStrings.getString("resource.no_attrib_name");
            throw new RuntimeOperationsException(new IllegalArgumentException(msg));
        }
        if (attribute.equals(numThreadsWaiting)) {
            return new Integer(this.poolmonitor.getNumThreadWaiting());
        }
        if (attribute.equals(numConnFailedValidation)) {
            return new Integer(this.poolmonitor.getNumConnFailedValidation());
        }
        if (attribute.equals(numConnTimedOut)) {
            return new Integer(this.poolmonitor.getNumConnTimedOut());
        }
        String msg = localStrings.getString("resource.attrib_not_found", attribute);
        throw new AttributeNotFoundException(msg);
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            String msg = localStrings.getString("resource.attrib_name_needed");
            throw new RuntimeOperationsException(new IllegalArgumentException(msg));
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "web.error_while_getting_monitor_attr", e);
            }
        }
        return resultList;
    }

    public void startMonitoring() {
        this.monitorOn = true;
    }

    public void stopMonitoring() {
        this.monitorOn = false;
    }

    public MBeanInfo getMBeanInfo() {
        return mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String attrName) {
        MonitoredAttributeType type = null;
        if (attrNameTypeMap != null && attrName != null) {
            type = (MonitoredAttributeType)attrNameTypeMap.get(attrName);
        }
        return type;
    }

    public MonitoredObjectType getMonitoredObjectType() {
        return this.type;
    }
}

