/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.LocalTxConnectorAllocator;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.XAResourceWrapper;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionEventListener;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ResourceHandle {
    private static long idSequence;
    private long id = ResourceHandle.getNextId();
    private ClientSecurityInfo info;
    private Object resource;
    private ResourceSpec spec;
    private XAResource xares;
    private Object usercon;
    private ResourceAllocator alloc;
    private Object instance;
    private int shareCount;
    private boolean supportsXAResource = false;
    private Subject subject = null;
    private ResourceState state = null;
    private ConnectionEventListener listener = null;
    private static Logger logger;
    private boolean connectionErrorOccurred = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextId() {
        Class clazz = ResourceHandle.class;
        synchronized (clazz) {
            return ++idSequence;
        }
    }

    public ResourceHandle(Object resource, ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info) {
        this.spec = spec;
        this.info = info;
        this.resource = resource;
        this.alloc = alloc;
        this.supportsXAResource = !(alloc instanceof LocalTxConnectorAllocator);
    }

    public ResourceHandle(Object resource, ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info, boolean supportsXA) {
        this.spec = spec;
        this.info = info;
        this.resource = resource;
        this.alloc = alloc;
        this.supportsXAResource = supportsXA;
    }

    public boolean isTransactional() {
        return this.alloc.isTransactional();
    }

    public boolean supportsXA() {
        return this.supportsXAResource;
    }

    public ResourceAllocator getResourceAllocator() {
        return this.alloc;
    }

    public Object getResource() {
        return this.resource;
    }

    public ClientSecurityInfo getClientSecurityInfo() {
        return this.info;
    }

    public void setResourceSpec(ResourceSpec spec) {
        this.spec = spec;
    }

    public ResourceSpec getResourceSpec() {
        return this.spec;
    }

    public XAResource getXAResource() {
        return this.xares;
    }

    public Object getUserConnection() {
        return this.usercon;
    }

    public void setComponentInstance(Object instance) {
        this.instance = instance;
    }

    public Object getComponentInstance() {
        return this.instance;
    }

    public void fillInResourceObjects(Object userConnection, XAResource xaRes) {
        if (userConnection != null) {
            this.usercon = userConnection;
        }
        if (xaRes != null) {
            if (logger.isLoggable(Level.FINEST)) {
                if (!(xaRes instanceof XAResourceWrapper)) {
                    this.xares = new XAResourceWrapper(xaRes);
                }
            } else {
                this.xares = xaRes;
            }
        }
    }

    public void incrementCount() {
        ++this.shareCount;
    }

    public void decrementCount() {
        if (this.shareCount == 0) {
            throw new IllegalStateException("shareCount cannot be negative");
        }
        --this.shareCount;
    }

    public int getShareCount() {
        return this.shareCount;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ResourceHandle) {
            return this.id == ((ResourceHandle)other).id;
        }
        return false;
    }

    public int hashCode() {
        return new Long(this.id).hashCode();
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public void setConnectionErrorOccurred() {
        this.connectionErrorOccurred = true;
    }

    public boolean hasConnectionErrorOccurred() {
        return this.connectionErrorOccurred;
    }

    public void setResourceState(ResourceState state) {
        this.state = state;
    }

    public ResourceState getResourceState() {
        return this.state;
    }

    public void setListener(ConnectionEventListener l) {
        this.listener = l;
    }

    public ConnectionEventListener getListener() {
        return this.listener;
    }

    public boolean isShareable() {
        return this.alloc.shareableWithinComponent();
    }

    public boolean isEnlisted() {
        if (this.state != null) {
            return this.state.isEnlisted();
        }
        return false;
    }

    static {
        logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

