/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.ConnectorConnectionPoolStats;
import com.sun.enterprise.admin.monitor.stats.JDBCConnectionPoolStats;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.IASNonSharedResourcePool;
import com.sun.enterprise.resource.NoTxResourceManagerImpl;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceManager;
import com.sun.enterprise.resource.ResourceManagerImpl;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.SystemResourceManagerImpl;
import com.sun.enterprise.resource.monitor.ConnectorConnectionPoolStatsImpl;
import com.sun.enterprise.resource.monitor.ConnectorServiceMonitoringLevelListener;
import com.sun.enterprise.resource.monitor.JDBCConnectionPoolStatsImpl;
import com.sun.enterprise.resource.monitor.JDBCPoolMonitoringLevelListener;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;

public class PoolManagerImpl
implements PoolManager {
    private static final boolean debug = false;
    private static final long DEFAULT_SLEEPTIME = 10L;
    private Hashtable poolTable = new Hashtable();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PoolManagerImpl.class);
    private Hashtable xid2Connections = new Hashtable();
    private ResourceManager resourceManager = new ResourceManagerImpl();
    private ResourceManager sysResourceManager = new SystemResourceManagerImpl();
    private ResourceManager noTxResourceManager = new NoTxResourceManagerImpl();
    static Logger _logger = null;
    MonitoringRegistry monitoringRegistry_;

    private boolean isTransactionActive(Transaction tran) {
        return tran != null;
    }

    public void createEmptyConnectionPool(String poolName) throws PoolingException {
        this.createAndInitPool(poolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourcePool createAndInitPool(String poolName) throws PoolingException {
        Hashtable hashtable = this.poolTable;
        synchronized (hashtable) {
            ResourcePool pool = (ResourcePool)this.poolTable.get(poolName);
            if (pool == null) {
                pool = new IASNonSharedResourcePool(poolName);
                this.poolTable.put(poolName, pool);
                try {
                    ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
                    if (runtime.getEnviron() == 1) {
                        if (this.isJdbcPool(poolName)) {
                            this.enableJDBCPoolMonitoring(pool, poolName);
                        } else {
                            this.enableConnectorConnectionPoolMonitoring(pool, poolName);
                        }
                    }
                }
                catch (Exception e) {
                    _logger.log(Level.INFO, "poolmon.cannot_reg");
                    _logger.log(Level.FINE, "Exception while registering connection pool", e);
                }
                return pool;
            }
            return pool;
        }
    }

    public Object getResource(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info) throws PoolingException {
        ComponentInvocation inv;
        J2EETransactionManager tm;
        List resList;
        Object comp;
        Transaction tran = null;
        ResourceManager rm = this.getResourceManager(spec);
        boolean transactional = alloc.isTransactional();
        if (transactional) {
            tran = rm.getTransaction();
        }
        if (spec.isShareableXAResource() && (comp = rm.getComponent()) != null && (resList = (tm = Switch.getSwitch().getTransactionManager()).getExistingResourceList(comp, inv = Switch.getSwitch().getInvocationManager().getCurrentInvocation())) != null) {
            Iterator it = resList.iterator();
            while (it.hasNext()) {
                ResourceHandle h = (ResourceHandle)it.next();
                if (h.getResourceSpec() == null || h.getClientSecurityInfo() == null || !h.getResourceSpec().equals(spec) || !h.getClientSecurityInfo().equals(info)) continue;
                h.setResourceSpec(spec);
                return h.getResourceAllocator().getSharedConnection(h);
            }
        }
        ResourceHandle handle = this.getResourceFromPool(spec, alloc, info, tran);
        handle.setResourceSpec(spec);
        try {
            rm.enlistResource(handle);
        }
        catch (Exception e) {
            this.putbackDirectToPool(handle, spec.getConnectionPoolName());
            _logger.log(Level.WARNING, "poolmgr.err_enlisting_res_in_getconn");
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("rm.enlistResource threw Exception. Returning resource to pool");
            }
            throw new PoolingException(e);
        }
        return handle.getUserConnection();
    }

    public void registerResource(ResourceHandle handle) throws PoolingException {
        ResourceManager rm = this.getResourceManager(handle.getResourceSpec());
        rm.registerResource(handle);
    }

    public ResourceHandle getResourceFromPool(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info, Transaction tran) throws PoolingException {
        ResourcePool pool = this.createAndInitPool(spec.getConnectionPoolName());
        ResourceHandle resource = pool.getResource(spec, alloc, tran);
        return resource;
    }

    private void enableConnectorConnectionPoolMonitoring(ResourcePool pool, final String poolName) {
        if (this.getConnectorPoolMonitoringLevel() != MonitoringLevel.OFF) {
            final ConnectorConnectionPoolStatsImpl ccpStatsImpl = new ConnectorConnectionPoolStatsImpl((IASNonSharedResourcePool)pool);
            this.setMonitoringEnabled(poolName, true);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PoolManagerImpl.this.monitoringRegistry_.registerConnectorConnectionPoolStats((ConnectorConnectionPoolStats)ccpStatsImpl, poolName, null);
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_reg", mre.getMessage());
                        _logger.log(Level.FINE, "Error while enabling Connector Pool monitoring for pool " + poolName, mre);
                        PoolManagerImpl.this.setMonitoringEnabled(poolName, false);
                    }
                    return null;
                }
            });
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Enabled pool monitoring at pool creation for " + poolName);
            }
        }
    }

    private void enableJDBCPoolMonitoring(ResourcePool pool, final String poolName) {
        if (this.getJdbcPoolMonitoringLevel() != MonitoringLevel.OFF) {
            final JDBCConnectionPoolStatsImpl jdbcStatsImpl = new JDBCConnectionPoolStatsImpl((IASNonSharedResourcePool)pool);
            this.setMonitoringEnabled(poolName, true);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PoolManagerImpl.this.monitoringRegistry_.registerJDBCConnectionPoolStats((JDBCConnectionPoolStats)jdbcStatsImpl, poolName, null);
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_reg", mre.getMessage());
                        _logger.log(Level.FINE, "Error while enabling JDBC Pool monitoring for pool " + poolName, mre);
                        PoolManagerImpl.this.setMonitoringEnabled(poolName, false);
                    }
                    return null;
                }
            });
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Enabled pool monitoring at pool creation for " + poolName);
            }
        }
    }

    public void resourceEnlisted(Transaction tran, ResourceHandle res) throws IllegalStateException {
        Hashtable pools;
        ResourcePool pool;
        String poolName = res.getResourceSpec().getConnectionPoolName();
        try {
            J2EETransaction j2eeTran = (J2EETransaction)tran;
            if (poolName != null && j2eeTran.getResources(poolName) == null) {
                this.addSyncListener(tran);
            }
        }
        catch (ClassCastException e) {
            this.addSyncListener(tran);
        }
        if (poolName != null && (pool = (ResourcePool)(pools = Switch.getSwitch().getPoolManager().getPoolTable()).get(poolName)) != null) {
            pool.resourceEnlisted(tran, res);
        }
    }

    private void addSyncListener(Transaction tran) {
        SynchronizationListener sync = new SynchronizationListener(tran);
        try {
            tran.registerSynchronization((Synchronization)sync);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        Hashtable cloneTable = (Hashtable)Switch.getSwitch().getPoolManager().getPoolTable().clone();
        Enumeration e = cloneTable.elements();
        while (e.hasMoreElements()) {
            ResourcePool pool = (ResourcePool)e.nextElement();
            pool.transactionCompleted(tran, status);
        }
    }

    public void resourceClosed(ResourceHandle resource) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        rm.delistResource(resource, 0x4000000);
        this.putbackResourceToPool(resource, false);
    }

    public void resourceErrorOccurred(ResourceHandle resource) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        if (resource.isTransactional()) {
            rm.rollBackTransaction();
        }
        if (resource.isEnlisted()) {
            rm.delistResource(resource, 0x20000000);
        }
        this.putbackResourceToPool(resource, true);
    }

    public void unregisterResource(ResourceHandle resource, int xaresFlag) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        rm.unregisterResource(resource, xaresFlag);
    }

    public void putbackResourceToPool(ResourceHandle h, boolean errorOccurred) {
        ResourcePool pool;
        try {
            ResourceAllocator alloc = h.getResourceAllocator();
            alloc.cleanup(h);
        }
        catch (PoolingException ex) {
            errorOccurred = true;
        }
        String poolName = h.getResourceSpec().getConnectionPoolName();
        if (poolName != null && (pool = (ResourcePool)this.poolTable.get(poolName)) != null) {
            if (errorOccurred) {
                pool.resourceErrorOccurred(h);
            } else {
                pool.resourceClosed(h);
            }
        }
    }

    public ResourceHandle getSharedResource(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info, Xid xid) throws PoolingException {
        if (xid == null) {
            throw new PoolingException("xid cannot be null");
        }
        Vector<Object> v = new Vector<Object>(3);
        v.addElement(spec);
        v.addElement(info);
        v.addElement(xid);
        ResourceHandle resource = (ResourceHandle)this.xid2Connections.get(v);
        if (resource == null) {
            resource = this.getResourceFromPool(spec, alloc, info, null);
            this.xid2Connections.put(v, resource);
        }
        return resource;
    }

    public void freeSharedResource(ResourceHandle h, Xid xid) throws PoolingException {
        Vector<Object> v = new Vector<Object>(3);
        v.addElement(h.getResourceSpec());
        v.addElement(h.getClientSecurityInfo());
        v.addElement(xid);
        this.xid2Connections.remove(v);
        this.putbackResourceToPool(h, false);
    }

    public boolean sharedResourceExists(ResourceSpec spec, ClientSecurityInfo info, Xid xid) {
        Vector<Object> v = new Vector<Object>(3);
        v.addElement(spec);
        v.addElement(info);
        v.addElement(xid);
        return this.xid2Connections.get(v) != null;
    }

    public void emptyResourcePool(ResourceSpec spec) {
        ResourcePool pool;
        String poolName = spec.getConnectionPoolName();
        if (poolName != null && (pool = (ResourcePool)this.poolTable.get(poolName)) != null) {
            pool.emptyPool();
        }
    }

    public ResourceReferenceDescriptor getResourceReference(String jndiName) {
        InvocationManager i = Switch.getSwitch().getInvocationManager();
        if (i == null) {
            return null;
        }
        ComponentInvocation inv = null;
        inv = i.getCurrentInvocation();
        if (inv == null) {
            return null;
        }
        int invType = inv.getInvocationType();
        Set refs = null;
        Object container = inv.getContainerContext();
        JndiNameEnvironment env = (JndiNameEnvironment)Switch.getSwitch().getDescriptorFor(container);
        if (env == null) {
            return null;
        }
        refs = env.getResourceReferenceDescriptors();
        Iterator iter = refs.iterator();
        while (iter.hasNext()) {
            ResourceReferenceDescriptor ref = (ResourceReferenceDescriptor)iter.next();
            String name = ref.getJndiName();
            if (!jndiName.equals(name)) continue;
            return ref;
        }
        return null;
    }

    private ResourceManager getResourceManager(ResourceSpec spec) {
        if (spec.isPM()) {
            return this.sysResourceManager;
        }
        if (spec.isNonTx()) {
            return this.noTxResourceManager;
        }
        return this.resourceManager;
    }

    private static void assertit(boolean value) {
        if (!value) {
            Exception e = new Exception();
            _logger.log(Level.WARNING, "poolmgr.assert_exception", e);
        }
    }

    public void resizeAllPools(boolean forced) {
        Hashtable cloneTable = (Hashtable)this.poolTable.clone();
        Enumeration e = cloneTable.elements();
        while (e.hasMoreElements()) {
            try {
                ((ResourcePool)e.nextElement()).resizePool(forced);
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "poolmgr.pool_resize_error", ex);
            }
        }
    }

    public void putbackDirectToPool(ResourceHandle h, String poolName) {
        ResourcePool pool;
        if (poolName != null && (pool = (ResourcePool)this.poolTable.get(poolName)) != null) {
            pool.resourceClosed(h);
        }
    }

    public void killPool(String poolName) {
        ResourcePool pool = (ResourcePool)this.poolTable.get(poolName);
        if (pool != null) {
            pool.cancelResizerTask();
            pool.emptyPool();
            this.poolTable.remove(poolName);
        }
        try {
            ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
            if (runtime.getEnviron() == 1) {
                String fPoolName = poolName;
                if (this.isJdbcPool(fPoolName)) {
                    this.disableJDBCPoolMonitoring(fPoolName);
                } else {
                    this.disableConnectorConnectionPoolMonitoring(fPoolName);
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.INFO, "poolmon.cannot_unreg");
        }
    }

    private void disableConnectorConnectionPoolMonitoring(final String fPoolName) {
        if (this.getConnectorPoolMonitoringLevel() != MonitoringLevel.OFF) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PoolManagerImpl.this.monitoringRegistry_.unregisterConnectorConnectionPoolStats(fPoolName);
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_unreg", mre.getMessage());
                    }
                    return null;
                }
            });
        }
    }

    private void disableJDBCPoolMonitoring(final String fPoolName) {
        if (this.getJdbcPoolMonitoringLevel() != MonitoringLevel.OFF) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PoolManagerImpl.this.monitoringRegistry_.unregisterJDBCConnectionPoolStats(fPoolName);
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_unreg", mre.getMessage());
                    }
                    return null;
                }
            });
        }
    }

    public void reconfigPoolProperties(ConnectorConnectionPool ccp) throws PoolingException {
        String poolName = ccp.getName();
        PoolManager poolmgr = Switch.getSwitch().getPoolManager();
        ResourcePool pool = (ResourcePool)poolmgr.getPoolTable().get(poolName);
        if (pool != null) {
            pool.reconfigPoolProperties(ccp);
        }
    }

    public void setMonitoringEnabled(String poolName, boolean monitoringEnabled) {
        ResourcePool pool = (ResourcePool)this.poolTable.get(poolName);
        if (pool != null) {
            pool.setMonitoringEnabled(monitoringEnabled);
        }
    }

    public boolean switchOnMatching(String poolName) {
        PoolManager poolmgr = Switch.getSwitch().getPoolManager();
        ResourcePool pool = (ResourcePool)poolmgr.getPoolTable().get(poolName);
        if (pool != null) {
            pool.switchOnMatching();
            return true;
        }
        return false;
    }

    private boolean isJdbcPool(String poolName) {
        JdbcConnectionPool[] pools = ResourcesUtil.getInstance().getJdbcConnectionPools();
        for (int i = 0; i < pools.length; ++i) {
            if (!poolName.equals(pools[i].getName())) continue;
            return true;
        }
        return false;
    }

    public Hashtable getPoolTable() {
        return this.poolTable;
    }

    public void initializeMonitoring() {
        try {
            final ConnectorServiceMonitoringLevelListener csMonitoringListener = new ConnectorServiceMonitoringLevelListener();
            final JDBCPoolMonitoringLevelListener jdbcMonitoringListener = new JDBCPoolMonitoringLevelListener();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServerContext ctxt = ApplicationServer.getServerContext();
                    if (ctxt != null) {
                        PoolManagerImpl.this.monitoringRegistry_ = ctxt.getMonitoringRegistry();
                        PoolManagerImpl.this.monitoringRegistry_.registerMonitoringLevelListener((MonitoringLevelListener)csMonitoringListener, MonitoredObjectType.CONNECTOR_SERVICE);
                        PoolManagerImpl.this.monitoringRegistry_.registerMonitoringLevelListener((MonitoringLevelListener)jdbcMonitoringListener, MonitoredObjectType.JDBC_CONN_POOL);
                    }
                    return null;
                }
            });
            _logger.log(Level.FINE, "poolmon.init_monitoring_registry");
        }
        catch (Exception e) {
            _logger.log(Level.INFO, "poolmon.error_registering_listener", e);
        }
    }

    private MonitoringLevel getJdbcPoolMonitoringLevel() {
        MonitoringLevel off;
        Config cfg = null;
        MonitoringLevel l = off = MonitoringLevel.OFF;
        try {
            cfg = ServerBeansFactory.getConfigBean(ApplicationServer.getServerContext().getConfigContext());
            String lvl = cfg.getMonitoringService().getModuleMonitoringLevels().getJdbcConnectionPool();
            l = MonitoringLevel.instance((String)lvl);
            if (l == null) {
                return off;
            }
        }
        catch (Exception e) {
            return off;
        }
        return l;
    }

    private MonitoringLevel getConnectorPoolMonitoringLevel() {
        MonitoringLevel off;
        Config cfg = null;
        MonitoringLevel l = off = MonitoringLevel.OFF;
        try {
            cfg = ServerBeansFactory.getConfigBean(ApplicationServer.getServerContext().getConfigContext());
            String lvl = cfg.getMonitoringService().getModuleMonitoringLevels().getConnectorConnectionPool();
            l = MonitoringLevel.instance((String)lvl);
            if (l == null) {
                return off;
            }
        }
        catch (Exception e) {
            return off;
        }
        return l;
    }

    public void killAllPools() {
        Enumeration pools = this.poolTable.elements();
        this.logFine("---Killing all pools");
        while (pools.hasMoreElements()) {
            ResourcePool pool = (ResourcePool)pools.nextElement();
            if (pool == null) continue;
            String name = pool.getPoolName();
            try {
                this.logFine("Now killing pool : " + name);
                this.killPool(name);
            }
            catch (Exception e) {
                this.logFine("Error killing pool : " + name + " :: " + e.getMessage());
            }
        }
    }

    public void killFreeConnectionsInPools() {
        Enumeration pools = this.poolTable.elements();
        this.logFine("-----Killing all free connections in pools");
        while (pools.hasMoreElements()) {
            ResourcePool pool = (ResourcePool)pools.nextElement();
            if (pool == null) continue;
            String name = pool.getPoolName();
            try {
                if (name == null) continue;
                ResourcePool poolToKill = (ResourcePool)this.poolTable.get(name);
                if (poolToKill != null) {
                    pool.emptyFreeConnectionsInPool();
                }
                this.logFine("Now killing free connections in pool : " + name);
            }
            catch (Exception e) {
                this.logFine("Error killing pool : " + name + " :: " + e.getMessage());
            }
        }
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }

    class Resizer
    extends TimerTask {
        Resizer() {
        }

        public void run() {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "PoolMgr: resize pool");
            }
            PoolManagerImpl.this.resizeAllPools(false);
        }
    }

    class SynchronizationListener
    implements Synchronization {
        private Transaction tran;

        SynchronizationListener(Transaction tran) {
            this.tran = tran;
        }

        public void afterCompletion(int status) {
            try {
                PoolManagerImpl.this.transactionCompleted(this.tran, status);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void beforeCompletion() {
        }
    }
}

