/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.resource.MonitorableResourcePool;
import com.sun.enterprise.resource.PoolCounters;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Transaction;

public class IASNonSharedResourcePool
implements MonitorableResourcePool {
    private static final boolean debug = false;
    private static StringManager localStrings = StringManager.getManager(IASNonSharedResourcePool.class);
    private ArrayList resources;
    private ArrayList free;
    private long idletime;
    private String name;
    private String connectionPoolName;
    private ResourceSpec resourceSpec;
    private ResourceAllocator allocator;
    private int maxPoolSize;
    private int steadyPoolSize;
    private int resizeQuantity;
    private int maxWaitTime;
    private boolean requireConnectionValidation = false;
    private boolean failAllConnections = false;
    private boolean matchConnections = true;
    private String validationType = null;
    private String userTable = null;
    private boolean poolInitialized = false;
    private TimerTask resizerTask;
    private boolean monitoringEnabled;
    private PoolCounters poolCounters = null;
    private LinkedList waitQueue = new LinkedList();
    private HashMap nonTxOpsResourceMap = null;
    private boolean noNonTxOps;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    private boolean inTx() {
        ComponentInvocation inv = Switch.getSwitch().getInvocationManager().getCurrentInvocation();
        if (inv == null) {
            throw new InvocationException();
        }
        Transaction tran = inv.getTransaction();
        return tran != null;
    }

    public IASNonSharedResourcePool(String poolName) throws PoolingException {
        this.connectionPoolName = poolName;
        this.name = poolName;
        this.setPoolConfiguration();
        this.monitoringEnabled = false;
        this.resources = new ArrayList(this.maxPoolSize);
        this.free = new ArrayList(this.maxPoolSize);
    }

    private void setPoolConfiguration() throws PoolingException {
        ConnectorConnectionPool poolResource;
        Context ic = Switch.getSwitch().getNamingManager().getInitialContext();
        try {
            String jndiNameOfPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(this.connectionPoolName);
            poolResource = (ConnectorConnectionPool)ic.lookup(jndiNameOfPool);
        }
        catch (NamingException ex) {
            throw new PoolingException(ex);
        }
        this.idletime = Integer.parseInt(poolResource.getIdleTimeoutInSeconds()) * 1000;
        this.maxPoolSize = Integer.parseInt(poolResource.getMaxPoolSize());
        this.steadyPoolSize = Integer.parseInt(poolResource.getSteadyPoolSize());
        if (this.maxPoolSize < this.steadyPoolSize) {
            this.maxPoolSize = this.steadyPoolSize;
        }
        this.resizeQuantity = Integer.parseInt(poolResource.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(poolResource.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        this.failAllConnections = poolResource.isFailAllConnections();
        this.matchConnections = poolResource.matchConnections();
    }

    private synchronized void initPool(ResourceSpec resourceSpec, ResourceAllocator allocator) throws PoolingException {
        if (this.poolInitialized) {
            return;
        }
        this.resourceSpec = resourceSpec;
        this.allocator = allocator;
        this.createSteadyResources();
        if (this.idletime > 0L) {
            this.scheduleResizerTask();
        }
        this.poolInitialized = true;
    }

    private void scheduleResizerTask() {
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
            this.resizerTask = null;
        }
        this.resizerTask = new Resizer();
        Timer timer = Switch.getSwitch().getTimer();
        timer.scheduleAtFixedRate(this.resizerTask, this.idletime, this.idletime);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("schduled resizer task");
        }
    }

    public synchronized void addResource(ResourceSpec spec, ResourceHandle h) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resource added: " + spec + "," + h);
        }
        ResourceState state = new ResourceState();
        this.resources.add(h);
        h.setResourceState(state);
        state.setEnlisted(false);
        state.setBusy(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle getResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result = null;
        long startTime = 0L;
        long elapsedWaitTime = 0L;
        long remainingWaitTime = 0L;
        Object waitMonitor = new Object();
        if (this.maxWaitTime > 0) {
            startTime = System.currentTimeMillis();
        }
        while (true) {
            if ((result = this.internalGetResource(spec, alloc, tran)) != null) {
                if (this.monitoringEnabled) {
                    ++this.poolCounters.numConnAcquired;
                    elapsedWaitTime = System.currentTimeMillis() - startTime;
                    this.poolCounters.setWaitTime(elapsedWaitTime);
                }
                return result;
            }
            if (this.maxWaitTime > 0) {
                elapsedWaitTime = System.currentTimeMillis() - startTime;
                if (elapsedWaitTime < (long)this.maxWaitTime) {
                    remainingWaitTime = (long)this.maxWaitTime - elapsedWaitTime;
                } else {
                    if (this.monitoringEnabled) {
                        ++this.poolCounters.numConnTimedOut;
                    }
                    String msg = localStrings.getString("poolmgr.no.available.resource", "No available resource. Wait-time expired.");
                    throw new PoolingException(msg);
                }
            }
            Object object = waitMonitor;
            synchronized (object) {
                LinkedList linkedList = this.waitQueue;
                synchronized (linkedList) {
                    this.waitQueue.addLast(waitMonitor);
                }
                try {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Resource Pool: getting on wait queue");
                    }
                    waitMonitor.wait(remainingWaitTime);
                }
                catch (InterruptedException ex) {
                    break;
                }
                linkedList = this.waitQueue;
                synchronized (linkedList) {
                    this.waitQueue.remove(waitMonitor);
                }
            }
        }
        return result;
    }

    private ResourceHandle internalGetResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result;
        block7: {
            if (!this.poolInitialized) {
                this.initPool(spec, alloc);
            }
            result = null;
            try {
                J2EETransaction j2eetran;
                Set set;
                if (tran == null || (set = (j2eetran = (J2EETransaction)tran).getResources(this.connectionPoolName)) == null) break block7;
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    ResourceHandle h = (ResourceHandle)iter.next();
                    if (h.hasConnectionErrorOccurred()) {
                        iter.remove();
                        continue;
                    }
                    ResourceState state = this.getResourceState(h);
                    if (!state.isFree() || this.matchConnections && !alloc.matchConnection(h)) continue;
                    if (h.hasConnectionErrorOccurred()) {
                        iter.remove();
                        continue;
                    }
                    state.setBusy(true);
                    alloc.fillInResourceObjects(h);
                    result = h;
                    break;
                }
            }
            catch (ClassCastException e) {
                _logger.log(Level.FINE, "Pool: getResource : transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
            }
        }
        if (result == null && (result = this.getUnenlistedResource(spec, alloc, tran)) != null && this.monitoringEnabled) {
            this.poolCounters.incrementNumConnUsed();
        }
        return result;
    }

    private synchronized ResourceHandle getUnenlistedResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result = null;
        Iterator iter = this.free.iterator();
        while (iter.hasNext()) {
            boolean hasMatched;
            ResourceHandle h = (ResourceHandle)iter.next();
            if (h.hasConnectionErrorOccurred()) {
                iter.remove();
                continue;
            }
            boolean bl = hasMatched = this.matchConnections ? alloc.matchConnection(h) : true;
            if (h.hasConnectionErrorOccurred()) {
                if (this.failAllConnections) {
                    result = this.createSingleResourceAndAdjustPool(alloc, spec);
                    break;
                }
                iter.remove();
                continue;
            }
            if (!hasMatched) continue;
            result = h;
            break;
        }
        if (result != null) {
            ResourceState state = this.getResourceState(result);
            state.setBusy(true);
            this.free.remove(result);
            alloc.fillInResourceObjects(result);
        } else if (this.resources.size() < this.maxPoolSize) {
            result = alloc.createResource();
            this.addResource(spec, result);
            alloc.fillInResourceObjects(result);
            if (this.monitoringEnabled) {
                ++this.poolCounters.numConnCreated;
            }
        }
        return result;
    }

    private ResourceHandle createSingleResourceAndAdjustPool(ResourceAllocator alloc, ResourceSpec spec) throws PoolingException {
        if (this.free.size() != 0) {
            ResourceHandle rHandle = (ResourceHandle)this.free.get(0);
            this.resources.remove(rHandle);
            this.free.remove(rHandle);
        }
        ResourceHandle result = alloc.createResource();
        this.addResource(spec, result);
        alloc.fillInResourceObjects(result);
        if (this.monitoringEnabled) {
            ++this.poolCounters.numConnCreated;
        }
        return result;
    }

    private synchronized void createSteadyResources() throws PoolingException {
        for (int i = 0; i < this.steadyPoolSize; ++i) {
            this.createResourceAndAddToPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyResource(ResourceHandle resourceHandle) {
        try {
            try {
                resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "poolmgr.destroy_resource_failed");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "poolmgr.destroy_resource_failed", ex);
                }
                Object var4_3 = null;
                if (this.monitoringEnabled) {
                    ++this.poolCounters.numConnDestroyed;
                    if (resourceHandle.getResourceState().isBusy()) {
                        this.poolCounters.decrementNumConnUsed();
                    }
                }
            }
            Object var4_2 = null;
            if (this.monitoringEnabled) {
                ++this.poolCounters.numConnDestroyed;
                if (resourceHandle.getResourceState().isBusy()) {
                    this.poolCounters.decrementNumConnUsed();
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.monitoringEnabled) {
                ++this.poolCounters.numConnDestroyed;
                if (resourceHandle.getResourceState().isBusy()) {
                    this.poolCounters.decrementNumConnUsed();
                }
            }
            throw throwable;
        }
    }

    public void resourceClosed(ResourceHandle h) throws IllegalStateException {
        ResourceState state;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceClosed: " + h);
        }
        if ((state = this.getResourceState(h)) == null || !state.isBusy()) {
            throw new IllegalStateException("state is null : " + (state == null) + " ::: state.isBusy() : " + state.isBusy());
        }
        state.setBusy(false);
        state.touchTimestamp();
        if (state.isUnenlisted()) {
            this.freeUnenlistedResource(h);
            if (this.monitoringEnabled) {
                this.poolCounters.decrementNumConnUsed();
            }
        }
        if (this.monitoringEnabled) {
            ++this.poolCounters.numConnReleased;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceFreed: " + h);
        }
    }

    private synchronized void freeUnenlistedResource(ResourceHandle h) {
        this.free.add(h);
        this.notifyWaitingThreads();
    }

    public synchronized void resourceErrorOccurred(ResourceHandle h) throws IllegalStateException {
        ResourceState state;
        this.logFine("Pool: resourceErrorOccurred: " + h);
        if (this.failAllConnections) {
            this.doFailAllConnectionsProcessing();
            return;
        }
        if (this.monitoringEnabled) {
            ++this.poolCounters.numConnFailedValidation;
        }
        if ((state = this.getResourceState(h)) == null) {
            throw new IllegalStateException();
        }
        this.resources.remove(h);
        this.destroyResource(h);
    }

    private void doFailAllConnectionsProcessing() {
        if (this.monitoringEnabled) {
            this.poolCounters.numConnFailedValidation += (long)this.resources.size();
        }
        this.emptyPool();
        try {
            this.createSteadyResources();
        }
        catch (PoolingException pe) {
            this.logFine("in doFailAllConnectionsProcessing couldn't create steady resources");
        }
    }

    public void resourceEnlisted(Transaction tran, ResourceHandle resource) throws IllegalStateException {
        try {
            J2EETransaction j2eetran = (J2EETransaction)tran;
            HashSet<ResourceHandle> set = j2eetran.getResources(this.connectionPoolName);
            if (set == null) {
                set = new HashSet<ResourceHandle>();
                j2eetran.setResources(set, this.connectionPoolName);
            }
            set.add(resource);
        }
        catch (ClassCastException e) {
            _logger.log(Level.FINE, "Pool: resourceEnlisted:transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
        }
        ResourceState state = this.getResourceState(resource);
        state.setEnlisted(true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceEnlisted: " + resource);
        }
    }

    public synchronized void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        try {
            J2EETransaction j2eetran = (J2EETransaction)tran;
            Set set = j2eetran.getResources(this.connectionPoolName);
            if (set == null) {
                return;
            }
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                ResourceHandle resource = (ResourceHandle)iter.next();
                ResourceState state = this.getResourceState(resource);
                state.setEnlisted(false);
                if (state.isFree()) {
                    this.free.add(resource);
                    if (this.monitoringEnabled) {
                        this.poolCounters.decrementNumConnUsed();
                    }
                }
                iter.remove();
                this.notifyWaitingThreads();
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Pool: transactionCompleted: " + resource);
            }
        }
        catch (ClassCastException e) {
            _logger.log(Level.FINE, "Pool: transactionCompleted: transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingThreads() {
        Object waitMonitor = null;
        LinkedList linkedList = this.waitQueue;
        synchronized (linkedList) {
            if (this.waitQueue.size() > 0) {
                waitMonitor = this.waitQueue.removeFirst();
            }
        }
        if (waitMonitor != null) {
            linkedList = waitMonitor;
            synchronized (linkedList) {
                waitMonitor.notify();
            }
        }
    }

    public int getNumThreadWaiting() {
        return this.waitQueue.size();
    }

    public long getNumConnFailedValidation() {
        return this.poolCounters.numConnFailedValidation;
    }

    public long getNumConnTimedOut() {
        return this.poolCounters.numConnTimedOut;
    }

    public synchronized long getNumConnFree() {
        return this.poolCounters.currNumConnFree;
    }

    public long getMaxNumConnFree() {
        return this.poolCounters.maxNumConnFree;
    }

    public long getMinNumConnFree() {
        if (this.poolCounters.minNumConnFree != Long.MAX_VALUE) {
            return this.poolCounters.minNumConnFree;
        }
        return 0L;
    }

    public synchronized long getNumConnInUse() {
        return this.poolCounters.currNumConnUsed;
    }

    public long getMaxNumConnUsed() {
        return this.poolCounters.maxNumConnUsed;
    }

    public long getMaxConnRequestWaitTime() {
        return this.poolCounters.maxConnectionRequestWait;
    }

    public long getMinConnRequestWaitTime() {
        if (this.poolCounters.minConnectionRequestWait != Long.MAX_VALUE) {
            return this.poolCounters.minConnectionRequestWait;
        }
        return 0L;
    }

    public long getTotalConnectionRequestWaitTime() {
        return this.poolCounters.totalConnectionRequestWait;
    }

    public long getMinNumConnUsed() {
        if (this.poolCounters.minNumConnUsed != Long.MAX_VALUE) {
            return this.poolCounters.minNumConnUsed;
        }
        return 0L;
    }

    public long getNumConnCreated() {
        return this.poolCounters.numConnCreated;
    }

    public long getNumConnDestroyed() {
        return this.poolCounters.numConnDestroyed;
    }

    public long getNumConnAcquired() {
        return this.poolCounters.numConnAcquired;
    }

    public long getNumConnReleased() {
        return this.poolCounters.numConnReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resizePool(boolean forced) {
        int count = 0;
        LinkedList linkedList = this.waitQueue;
        synchronized (linkedList) {
            if (this.waitQueue.size() > 0) {
                return;
            }
        }
        this.removeInvalidResources();
        int overSize = this.resources.size() - this.steadyPoolSize;
        if (overSize > 0) {
            int numResourcesToBeDestroyed = this.resizeQuantity < overSize ? this.resizeQuantity : overSize;
            Iterator iter = this.free.iterator();
            long currentTime = System.currentTimeMillis();
            while (numResourcesToBeDestroyed > 0 && iter.hasNext()) {
                ResourceHandle h = (ResourceHandle)iter.next();
                ResourceState state = this.getResourceState(h);
                if (!forced && currentTime - state.getTimestamp() <= this.idletime) continue;
                this.resources.remove(h);
                this.destroyResource(h);
                iter.remove();
                --numResourcesToBeDestroyed;
            }
        }
        if (this.resources.size() < this.steadyPoolSize) {
            for (int i = this.resources.size(); i < this.steadyPoolSize; ++i) {
                try {
                    this.createResourceAndAddToPool();
                    continue;
                }
                catch (PoolingException ex) {
                    _logger.log(Level.WARNING, "resource_pool.resize_pool_error", ex.getMessage());
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: Name = " + this.name);
            _logger.log(Level.FINE, "Pool: Idle resources freed: " + count);
            _logger.log(Level.FINE, "Pool: Resource held: " + this.resources.size());
        }
    }

    private void removeInvalidResources() {
        try {
            HashSet<Object> freeManagedConnections = new HashSet<Object>();
            Iterator iter = this.free.iterator();
            while (iter.hasNext()) {
                ResourceHandle element = (ResourceHandle)iter.next();
                freeManagedConnections.add(element.getResource());
            }
            _logger.log(Level.FINE, "Sending to RA a set of free connections of size", new Integer(freeManagedConnections.size()));
            Set invalidManagedConnections = this.allocator.getInvalidConnections(freeManagedConnections);
            if (invalidManagedConnections != null) {
                _logger.log(Level.FINE, "Received from RA invalid connections # ", new Integer(invalidManagedConnections.size()));
                Iterator iter2 = invalidManagedConnections.iterator();
                while (iter2.hasNext()) {
                    ManagedConnection invalidManagedConnection = (ManagedConnection)iter2.next();
                    Iterator freeResourcesIter = this.free.iterator();
                    while (freeResourcesIter.hasNext()) {
                        ResourceHandle handle = (ResourceHandle)freeResourcesIter.next();
                        if (!invalidManagedConnection.equals(handle.getResource())) continue;
                        this.resources.remove(handle);
                        this.destroyResource(handle);
                        freeResourcesIter.remove();
                    }
                }
            } else {
                _logger.log(Level.FINE, "RA does not support ValidatingManagedConnectionFactory");
            }
        }
        catch (ResourceException re) {
            _logger.log(Level.FINE, "ResourceException while trying to get invalid connections from MCF", re);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Exception while trying to get invalid connections from MCF", e);
        }
    }

    private ResourceState getResourceState(ResourceHandle h) {
        return h.getResourceState();
    }

    public synchronized void emptyPool() {
        this.logFine("EmptyPool: Name = " + this.name);
        Iterator iter = this.resources.iterator();
        while (iter.hasNext()) {
            ResourceHandle h = (ResourceHandle)iter.next();
            this.destroyResource(h);
        }
        this.free.clear();
        this.resources.clear();
    }

    public synchronized void emptyFreeConnectionsInPool() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Emptying free connections in pool : " + this.name);
        }
        Iterator iter = this.free.iterator();
        while (iter.hasNext()) {
            ResourceHandle h = (ResourceHandle)iter.next();
            this.resources.remove(h);
            this.destroyResource(h);
        }
        this.free.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Pool [");
        sb.append(this.name);
        sb.append("] PoolSize=");
        sb.append(this.resources.size());
        sb.append("  FreeResources=");
        sb.append(this.free.size());
        sb.append("  QueueSize=");
        sb.append(this.waitQueue.size());
        return sb.toString();
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void setMonitoringEnabled(boolean _monitoringEnabled) {
        int numConnFree;
        int n = numConnFree = this.poolInitialized ? this.free.size() : this.steadyPoolSize;
        if (this.poolCounters == null) {
            this.poolCounters = new PoolCounters(numConnFree);
        }
        if (!_monitoringEnabled) {
            this.poolCounters.reset(numConnFree);
        }
        this.monitoringEnabled = _monitoringEnabled;
    }

    public synchronized void reconfigPoolProperties(ConnectorConnectionPool poolResource) throws PoolingException {
        int _idleTime = Integer.parseInt(poolResource.getIdleTimeoutInSeconds()) * 1000;
        if ((long)_idleTime != this.idletime && _idleTime != 0) {
            this.scheduleResizerTask();
        }
        if (_idleTime == 0) {
            this.cancelResizerTask();
        }
        this.idletime = _idleTime;
        int _maxPoolSize = Integer.parseInt(poolResource.getMaxPoolSize());
        if (_maxPoolSize < this.maxPoolSize) {
            int toKill = this.resources.size() - _maxPoolSize;
            this.killExtraResources(toKill);
        }
        this.maxPoolSize = _maxPoolSize < this.steadyPoolSize ? this.steadyPoolSize : _maxPoolSize;
        int _steadyPoolSize = Integer.parseInt(poolResource.getSteadyPoolSize());
        if (_steadyPoolSize > this.steadyPoolSize) {
            this.increaseSteadyPoolSize(_steadyPoolSize);
        }
        this.steadyPoolSize = _steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : _steadyPoolSize;
        this.resizeQuantity = Integer.parseInt(poolResource.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(poolResource.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        this.failAllConnections = poolResource.isFailAllConnections();
    }

    private void killExtraResources(int numToKill) {
        this.cancelResizerTask();
        Iterator iter = this.free.iterator();
        for (int i = 0; iter.hasNext() && i < numToKill; ++i) {
            ResourceHandle h = (ResourceHandle)iter.next();
            ResourceState s = this.getResourceState(h);
            this.resources.remove(h);
            this.destroyResource(h);
            iter.remove();
        }
        this.scheduleResizerTask();
    }

    private void increaseSteadyPoolSize(int newSteadyPoolSize) throws PoolingException {
        this.cancelResizerTask();
        for (int i = this.resources.size(); i < newSteadyPoolSize; ++i) {
            this.createResourceAndAddToPool();
        }
        this.scheduleResizerTask();
    }

    private void createResourceAndAddToPool() throws PoolingException {
        ResourceHandle resourceHandle = this.allocator.createResource();
        this.addResource(this.resourceSpec, resourceHandle);
        this.getResourceState(resourceHandle).setBusy(false);
        this.free.add(resourceHandle);
        if (this.monitoringEnabled) {
            ++this.poolCounters.numConnCreated;
        }
    }

    public void switchOnMatching() {
        this.matchConnections = true;
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    public String getPoolName() {
        return this.connectionPoolName;
    }

    public synchronized void cancelResizerTask() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.finest("Cancelling resizer");
        }
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
        }
        this.resizerTask = null;
    }

    public synchronized void dumpPoolStatus() {
        _logger.log(Level.INFO, "Name of pool :" + this.connectionPoolName);
        _logger.log(Level.INFO, "Free connections :" + this.free.size());
        _logger.log(Level.INFO, "Total connections :" + this.resources.size());
        _logger.log(Level.INFO, "Pool's matching is :" + this.matchConnections);
        _logger.log(Level.INFO, "Free Table is :" + this.free);
        _logger.log(Level.INFO, "Resource Table is :" + this.resources);
    }

    public PoolCounters getPoolCounters() {
        return this.poolCounters;
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    class Resizer
    extends TimerTask {
        Resizer() {
        }

        public void run() {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IASNonSharedResourcePool: resize pool " + IASNonSharedResourcePool.this.name);
            }
            IASNonSharedResourcePool.this.resizePool(false);
        }
    }
}

