/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.naming.SerialContextProvider;
import com.sun.enterprise.naming.TransientContext;
import com.sun.enterprise.util.ORBManager;
import com.sun.logging.LogDomains;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class SerialContextProviderImpl
extends PortableRemoteObject
implements SerialContextProvider {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    public static final String SERIAL_CONTEXT_PROVIDER_NAME = "SerialContextProvider";
    private TransientContext rootContext = new TransientContext();

    public static void initSerialContextProvider() throws RemoteException {
        try {
            SerialContextProviderImpl impl = new SerialContextProviderImpl();
            Tie servantsTie = Util.getTie(impl);
            POA rootPOA = (POA)ORBManager.getORB().resolve_initial_references("RootPOA");
            Policy[] policy = new Policy[]{rootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION), rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
            POA poa = rootPOA.create_POA("SerialContextProviderPOA", null, policy);
            poa.the_POAManager().activate();
            Object provider = poa.servant_to_reference((Servant)servantsTie);
            Object objRef = ORBManager.getORB().resolve_initial_references("NameService");
            NamingContext ncRef = NamingContextHelper.narrow((Object)objRef);
            NameComponent nc = new NameComponent(SERIAL_CONTEXT_PROVIDER_NAME, "");
            NameComponent[] path = new NameComponent[]{nc};
            ncRef.rebind(path, provider);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise_naming.excep_in_insertserialcontextprovider", ex);
            RemoteException re = new RemoteException("initSerialCtxProvider error");
            re.initCause(ex);
            throw re;
        }
    }

    private SerialContextProviderImpl() throws RemoteException {
    }

    public java.lang.Object lookup(String name) throws NamingException, RemoteException {
        try {
            Reference ref;
            _logger.fine(" SerialContextProviderImpl :: lookup " + name);
            java.lang.Object obj = this.rootContext.lookup(name);
            if (obj instanceof Reference && (ref = (Reference)obj).getFactoryClassName().equals("com.sun.enterprise.naming.factory.IIOPObjectFactory")) {
                Hashtable<String, ORB> env = new Hashtable<String, ORB>();
                ORB orb = ORBManager.getORB();
                env.put("java.naming.corba.orb", orb);
                obj = NamingManager.getObjectInstance(obj, new CompositeName(name), null, env);
            }
            _logger.fine("Lookup of " + name + " successful");
            return obj;
        }
        catch (NamingException ne) {
            boolean isLoaded = this.checkAndLoadResource(name);
            _logger.fine("CheckAndLoad Resource of " + name + " was " + isLoaded);
            if (isLoaded) {
                java.lang.Object i = this.rootContext.lookup(name);
                return i;
            }
            throw ne;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            RemoteException re = new RemoteException("", e);
            throw re;
        }
    }

    private boolean checkAndLoadResource(String name) {
        boolean res = false;
        ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
        if (connectorRuntime.isServer()) {
            res = connectorRuntime.checkAndLoadResource(name);
        }
        return res;
    }

    public void bind(String name, java.lang.Object obj) throws NamingException, RemoteException {
        this.rootContext.bind(name, obj);
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException, RemoteException {
        this.rootContext.rebind(name, obj);
    }

    public void unbind(String name) throws NamingException, RemoteException {
        this.rootContext.unbind(name);
    }

    public void rename(String oldname, String newname) throws NamingException, RemoteException {
        this.rootContext.rename(oldname, newname);
    }

    public Hashtable list() throws RemoteException {
        return this.rootContext.list();
    }

    public Hashtable list(String name) throws NamingException, RemoteException {
        Hashtable ne = this.rootContext.listContext(name);
        return ne;
    }

    public Context createSubcontext(String name) throws NamingException, RemoteException {
        Context ctx = this.rootContext.createSubcontext(name);
        return ctx;
    }

    public void destroySubcontext(String name) throws NamingException, RemoteException {
        this.rootContext.destroySubcontext(name);
    }
}

