/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.enterprise.loader.JasperAdapter;
import com.sun.enterprise.util.Print;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class EJBClassLoader
extends SecureClassLoader
implements JasperAdapter {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private List urlSet = Collections.synchronizedList(new ArrayList());
    private Map notFoundResources = new HashMap();
    private Map notFoundClasses = new HashMap();
    private boolean doneCalled = false;
    private String doneSnapshot;

    public EJBClassLoader() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ClassLoader: " + this + " is getting created.");
        }
    }

    public EJBClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void done() {
        if (this.doneCalled) {
            return;
        }
        this.doneSnapshot = "EJBClassLoader.done() called ON " + this.toString() + "\n AT " + new Date() + " \n BY :" + Print.printStackTraceToString();
        this.doneCalled = true;
        for (int i = 0; i < this.urlSet.size(); ++i) {
            URLEntry u = (URLEntry)this.urlSet.get(i);
            if (u.zip != null) {
                try {
                    u.zip.close();
                }
                catch (IOException ioe) {
                    _logger.log(Level.FINE, "exception closing URLEntry zip" + ioe);
                }
            }
            u = null;
        }
        if (this.urlSet != null) {
            this.urlSet.clear();
        }
        if (this.notFoundResources != null) {
            this.notFoundResources.clear();
        }
        if (this.notFoundClasses != null) {
            this.notFoundClasses.clear();
        }
        this.urlSet = null;
        this.notFoundResources = null;
        this.notFoundClasses = null;
    }

    public synchronized void appendURL(URL url) {
        try {
            if (url == null) {
                _logger.log(Level.INFO, "loader.ejbclassloader_bad_url_entry", url);
                return;
            }
            URLEntry entry = new URLEntry(url);
            if (!this.urlSet.contains(entry)) {
                this.urlSet.add(entry);
                if (entry.isJar) {
                    this.checkManifest(entry.zip, entry.file);
                }
            } else {
                _logger.log(Level.FINE, "[EJB-CL] Ignoring duplicate URL: " + url);
                if (entry.zip != null) {
                    try {
                        entry.zip.close();
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.FINE, "exception closing zip for duplicate URLEntry " + url, ioe);
                    }
                }
            }
            this.notFoundResources.clear();
            this.notFoundClasses.clear();
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, "loader.ejbclassloader_bad_url_entry", url);
            _logger.log(Level.SEVERE, "loader.ejbclassloader_malformed_url", ioe);
        }
    }

    public synchronized URL[] getURLs() {
        URL[] url = null;
        if (this.urlSet != null) {
            url = new URL[this.urlSet.size()];
            for (int i = 0; i < url.length; ++i) {
                url[i] = ((URLEntry)this.urlSet.get((int)i)).source;
            }
        } else {
            url = new URL[]{};
        }
        return url;
    }

    public String getClasspath() {
        StringBuffer strBuf = null;
        URL[] urls = this.getURLs();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].getProtocol().equals("file")) continue;
                if (strBuf == null) {
                    strBuf = new StringBuffer();
                }
                if (i > 0) {
                    strBuf.append(File.pathSeparator);
                }
                strBuf.append(urls[i].getFile());
            }
        }
        return strBuf != null ? strBuf.toString() : null;
    }

    private URL findResource0(final URLEntry res, final String name) {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (res.isJar) {
                    try {
                        JarEntry jarEntry = res.zip.getJarEntry(name);
                        if (jarEntry != null) {
                            return new URL("jar:" + res.source + "!/" + name);
                        }
                    }
                    catch (IOException e) {
                        _logger.log(Level.FINE, "loader.excep_in_ejbclassloader", e);
                    }
                } else {
                    try {
                        File resourceFile = new File(res.file.getCanonicalPath() + File.separator + name);
                        if (resourceFile.exists()) {
                            return resourceFile.toURL();
                        }
                    }
                    catch (IOException e) {
                        _logger.log(Level.FINE, "loader.excep_in_ejbclassloader", e);
                    }
                }
                return null;
            }
        });
        return (URL)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL findResource(String name) {
        if (this.doneCalled) {
            _logger.log(Level.WARNING, "loader.ejbclassloader_done_already_called", new Object[]{name, this.doneSnapshot});
            return null;
        }
        String nf = (String)this.notFoundResources.get(name);
        if (nf != null && nf.equals(name)) {
            return null;
        }
        for (int i = 0; i < this.urlSet.size(); ++i) {
            URL url = this.findResource0((URLEntry)this.urlSet.get(i), name);
            if (url == null) continue;
            return url;
        }
        Map map = this.notFoundResources;
        synchronized (map) {
            this.notFoundResources.put(name, name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkManifest(JarFile jar, File file) throws IOException {
        if (jar == null || file == null) {
            return;
        }
        Manifest man = jar.getManifest();
        if (man == null) {
            return;
        }
        EJBClassLoader eJBClassLoader = this;
        synchronized (eJBClassLoader) {
            String cp = man.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (cp == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(cp, " ");
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                File newFile = new File(file.getParentFile(), entry);
                try {
                    this.appendURL(newFile.toURL());
                }
                catch (MalformedURLException ex) {
                    _logger.log(Level.SEVERE, "loader.ejbclassloader_malformed_url", ex);
                }
            }
        }
    }

    private byte[] loadClassData0(final URLEntry res, final String entryName) {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                block10: {
                    InputStream classStream = null;
                    try {
                        byte[] byArray;
                        block11: {
                            if (res.isJar) {
                                JarFile zip = res.zip;
                                ZipEntry entry = zip.getEntry(entryName);
                                if (entry != null) {
                                    classStream = zip.getInputStream(entry);
                                    byte[] classData = EJBClassLoader.this.getClassData(classStream);
                                    return classData;
                                }
                                break block10;
                            }
                            File classFile = new File(res.file, entryName.replace('/', File.separatorChar));
                            if (!classFile.exists()) break block10;
                            try {
                                byte[] classData;
                                classStream = new FileInputStream(classFile);
                                byArray = classData = EJBClassLoader.this.getClassData(classStream);
                                Object var6_9 = null;
                                if (classStream == null) break block11;
                            }
                            catch (Throwable throwable) {
                                Object var6_10 = null;
                                if (classStream != null) {
                                    try {
                                        classStream.close();
                                    }
                                    catch (IOException closeIOE) {
                                        _logger.log(Level.FINE, "loader.excep_in_ejbclassloader", closeIOE);
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                classStream.close();
                            }
                            catch (IOException closeIOE) {
                                _logger.log(Level.FINE, "loader.excep_in_ejbclassloader", closeIOE);
                            }
                        }
                        return byArray;
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.FINE, "loader.excep_in_ejbclassloader", ioe);
                    }
                }
                return null;
            }
        });
        return (byte[])result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.doneCalled) {
            _logger.log(Level.WARNING, "loader.ejbclassloader_done_already_called", new Object[]{name, this.doneSnapshot});
            throw new ClassNotFoundException(name);
        }
        String nf = (String)this.notFoundClasses.get(name);
        if (nf != null && nf.equals(name)) {
            throw new ClassNotFoundException(name);
        }
        String entryName = name.replace('.', '/') + ".class";
        for (int i = 0; i < this.urlSet.size(); ++i) {
            String packageName;
            int lastPackageSep;
            URLEntry u = (URLEntry)this.urlSet.get(i);
            byte[] result = null;
            result = this.loadClassData0(u, entryName);
            if (result == null) continue;
            if (PreprocessorUtil.isPreprocessorEnabled()) {
                result = PreprocessorUtil.processClass(entryName, result);
            }
            if ((lastPackageSep = name.lastIndexOf(46)) != -1 && this.getPackage(packageName = name.substring(0, lastPackageSep)) == null) {
                try {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException iae) {
                    _logger.log(Level.FINE, "duplicate package definition attempt for " + packageName, iae);
                }
            }
            Class<?> clz = this.defineClass(name, result, 0, result.length);
            return clz;
        }
        Map map = this.notFoundClasses;
        synchronized (map) {
            this.notFoundClasses.put(name, name);
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassData(InputStream istream) throws IOException {
        BufferedInputStream bstream = null;
        ByteArrayOutputStream bout = null;
        try {
            bstream = new BufferedInputStream(istream);
            byte[] buf = new byte[4096];
            bout = new ByteArrayOutputStream();
            int num = 0;
            while ((num = bstream.read(buf)) != -1) {
                bout.write(buf, 0, num);
            }
        }
        finally {
            if (bstream != null) {
                bstream.close();
            }
        }
        return bout.toByteArray();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("EJBClassLoader : \n");
        if (this.doneCalled) {
            buffer.append("doneCalled = true\n");
            if (this.doneSnapshot != null) {
                buffer.append("doneSnapshot = " + this.doneSnapshot);
            }
        } else {
            buffer.append("urlSet = " + this.urlSet + "\n");
            buffer.append("doneCalled = false \n");
        }
        buffer.append(" Parent -> " + this.getParent() + "\n");
        return buffer.toString();
    }

    protected static class URLEntry {
        URL source = null;
        File file = null;
        JarFile zip = null;
        boolean isJar = false;

        URLEntry(URL url) throws IOException {
            this.source = url;
            this.file = new File(url.getFile());
            this.isJar = this.file.isFile();
            if (this.isJar) {
                this.zip = new JarFile(this.file);
            }
        }

        public String toString() {
            return "URLEntry : " + this.source.toString();
        }

        public boolean equals(Object obj) {
            boolean tf = false;
            if (obj instanceof URLEntry) {
                URLEntry e = (URLEntry)obj;
                if (this.source.equals(e.source)) {
                    tf = true;
                }
            }
            return tf;
        }

        public int hashCode() {
            return this.source.hashCode();
        }
    }
}

