/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.deployment.backend.DeployableObjectInfo;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.ModuleInfo;
import com.sun.enterprise.deployment.util.ModuleContentLinker;
import com.sun.enterprise.instance.ExceptionType;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.Localizer;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.instance.ModulesManager;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.io.FileUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class WebModulesManager
extends ModulesManager {
    public WebModulesManager(InstanceEnvironment env) throws ConfigException {
        super(env, true);
    }

    public WebModulesManager(InstanceEnvironment env, boolean useBackupServerXml) throws ConfigException {
        super(env, useBackupServerXml);
        WebModule[] jArray = ((Applications)this.configBean).getWebModule();
        if (jArray != null) {
            for (int i = 0; i < jArray.length; ++i) {
                jArray[i].setConfigContext(this.configContext);
                jArray[i].setXPath(ServerXPathHelper.getWebModuleIdXpathExpression(jArray[i].getName()));
            }
        }
    }

    private WebModule getWebModule(String modId) throws ConfigException {
        WebModule mod = ((Applications)this.configBean).getWebModuleByName(modId);
        if (mod == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.NO_SUCH_WEB_MOD));
        }
        return mod;
    }

    public WebModule[] listWebModules() throws ConfigException {
        WebModule[] modules = ((Applications)this.configBean).getWebModule();
        if (modules == null) {
            return new WebModule[0];
        }
        ArrayList<WebModule> list = new ArrayList<WebModule>();
        for (int i = 0; i < modules.length; ++i) {
            if (!this.isReferenced(modules[i].getName())) continue;
            list.add(modules[i]);
        }
        WebModule[] refList = new WebModule[list.size()];
        return list.toArray(refList);
    }

    public List listIds() {
        ArrayList<String> arr = new ArrayList<String>();
        WebModule[] mods = ((Applications)this.configBean).getWebModule();
        if (mods == null) {
            return arr;
        }
        for (int i = 0; i < mods.length; ++i) {
            String name = mods[i].getName();
            if (!this.isReferenced(name)) continue;
            arr.add(name);
        }
        return arr;
    }

    public void remove(String modId) throws ConfigException {
        WebModule backEm = ((Applications)this.configBean).getWebModuleByName(modId);
        ((Applications)this.configBean).removeWebModule(backEm);
    }

    protected boolean isRegistered(String modId, ConfigBean bean) {
        WebModule cb = null;
        try {
            cb = ((Applications)bean).getWebModuleByName(modId);
        }
        catch (Exception cn) {
            // empty catch block
        }
        return cb != null;
    }

    public boolean isEnabled(String modId) throws ConfigException {
        return this.getWebModule(modId).isEnabled();
    }

    public boolean isSystem(String modId) throws ConfigException {
        WebModule wm = this.getWebModule(modId);
        String resourceType = wm.getObjectType();
        return resourceType.startsWith("system-");
    }

    public boolean isSystemAdmin(String modId) throws ConfigException {
        WebModule wm = this.getWebModule(modId);
        String resourceType = wm.getObjectType();
        return resourceType.startsWith("system-admin");
    }

    public void setEnable(String modId, boolean enable) throws ConfigException {
        this.getWebModule(modId).setEnabled(enable);
    }

    public void setOptionalAttributes(String modId, Properties optionalAttributes) throws ConfigException {
        if (optionalAttributes != null) {
            WebModule wm = this.getWebModule(modId);
            Enumeration<Object> tags = optionalAttributes.keys();
            while (tags.hasMoreElements()) {
                String tag = (String)tags.nextElement();
                String value = optionalAttributes.getProperty(tag);
                wm.setAttributeValue(tag, value);
            }
        }
    }

    public String getLocation(String name) throws ConfigException {
        WebModule webModule = ((Applications)this.configBean).getWebModuleByName(name);
        String location = null;
        if (webModule != null) {
            location = webModule.getLocation();
        }
        return this.resolvePath(location);
    }

    public void setLocation(String name, String location) throws ConfigException {
        WebModule webModule = ((Applications)this.configBean).getWebModuleByName(name);
        if (webModule != null) {
            webModule.setLocation(location);
        }
    }

    public String getJSPLocation(String name) {
        ModuleEnvironment menv = this.instanceEnvironment.getModuleEnvironment(name, DeployableObjectType.WEB);
        return menv.getModuleJSPPath();
    }

    public String getStubLocation(String name) {
        ModuleEnvironment menv = this.instanceEnvironment.getModuleEnvironment(name, DeployableObjectType.WEB);
        return menv.getModuleStubPath();
    }

    public String getGeneratedXMLLocation(String name) {
        ModuleEnvironment menv = this.instanceEnvironment.getModuleEnvironment(name, DeployableObjectType.WEB);
        return menv.getModuleGeneratedXMLPath();
    }

    public void register(DeployableObjectInfo info) throws ConfigException {
        if (!(info instanceof ModuleInfo)) {
            throw new ConfigException(Localizer.getValue(ExceptionType.BAD_WEB_MOD_INFO));
        }
        ModuleInfo modInfo = (ModuleInfo)info;
        this.regMod(modInfo, this.configContext, this.configBean);
    }

    private void regMod(ModuleInfo modInfo, ConfigContext ctx, ConfigBean cb) throws ConfigException {
        if (modInfo == null || !modInfo.isWeb()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.WRONG_MOD_INFO));
        }
        WebModule em = new WebModule();
        em.setName(modInfo.getName());
        em.setLocation(RelativePathResolver.unresolvePath(modInfo.getRootPath().getAbsolutePath(), new String[]{"com.sun.aas.instanceRoot", "com.sun.aas.installRoot"}));
        boolean exists = this.isRegistered(modInfo.getName(), cb);
        if (exists) {
            WebModule oldEm = ((Applications)cb).getWebModuleByName(modInfo.getName());
            ((Applications)cb).removeWebModule(oldEm);
        }
        ((Applications)cb).addWebModule(em);
        em.setConfigContext(this.configContext);
        em.setXPath(ServerXPathHelper.getWebModuleIdXpathExpression(em.getName()));
    }

    public String getDescription(String modId) throws ConfigException {
        return this.getWebModule(modId).getDescription();
    }

    public void setDescription(String modId, String desc) throws ConfigException {
        this.getWebModule(modId).setDescription(desc);
    }

    public String getVirtualServers(String modId) throws ConfigException {
        Server server = ServerBeansFactory.getServerBean(this.configContext);
        ApplicationRef ar = server.getApplicationRefByRef(modId);
        return ar.getVirtualServers();
    }

    public String getContextRoot(String modId) throws ConfigException {
        return this.getWebModule(modId).getContextRoot();
    }

    public void setContextRoot(String modId, String value) throws ConfigException {
        this.getWebModule(modId).setContextRoot(value);
    }

    public Application getDescriptor(String modId, ClassLoader cl, String moduleLoc, boolean validateXML) throws ConfigException {
        Application app = this.getDescriptor(modId, moduleLoc, validateXML);
        app.setClassLoader(cl);
        return app;
    }

    public Application getDescriptor(String modId, String modDir) throws ConfigException {
        return this.getDescriptor(modId, modDir, false);
    }

    public Application getDescriptor(String modId, String modDir, boolean validateXml) throws ConfigException {
        Application application = this.getRegisteredDescriptor(modId);
        if (application != null) {
            return application;
        }
        try {
            WebArchivist webArchivist = new WebArchivist();
            webArchivist.setXMLValidation(validateXml);
            FileArchive archive = new FileArchive();
            if (this.isSystemAdmin(modId)) {
                archive.open(modDir);
            } else {
                String xmlDir = this.getGeneratedXMLLocation(modId);
                if (FileUtils.safeIsDirectory(xmlDir)) {
                    archive.open(xmlDir);
                } else {
                    _logger.log(Level.WARNING, "core.no_xmldir", new Object[]{xmlDir, modDir});
                    archive.open(modDir);
                }
            }
            application = ApplicationArchivist.openArchive(modId, webArchivist, archive, true);
            if (!application.getWebServiceDescriptors().isEmpty()) {
                ModuleContentLinker visitor = new ModuleContentLinker(archive);
                application.visit(visitor);
            }
            this.registerDescriptor(modId, application);
            return application;
        }
        catch (IOException ioe) {
            throw new ConfigException(Localizer.getValue(ExceptionType.IO_ERROR_LOADING_DD, modId), ioe);
        }
        catch (Throwable t) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_LOAD, modId), t);
        }
    }
}

