/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.backend.DeployableObjectInfo;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.instance.DescriptorArchivist;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.ExceptionType;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.Localizer;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseManager {
    protected ConfigContext configContext;
    protected ConfigBean configBean;
    private DasConfig appConfig;
    protected InstanceEnvironment instanceEnvironment;
    protected boolean useBackupServerXml = true;
    protected static final String SYSTEM_PREFIX = "system-";
    protected static final String SYSTEM_ADMIN_PREFIX = "system-admin";
    protected static Logger _logger;
    private static Map registeredDescriptors;
    private static final String DEBUG_OPTION = "-g";
    private static final String OPTIMIZE_OPTION = "-O";
    static final /* synthetic */ boolean $assertionsDisabled;

    public BaseManager(InstanceEnvironment env, boolean useBackupServerXml) throws ConfigException {
        this.instanceEnvironment = env;
        try {
            AdminContext ac;
            AdminService as;
            this.useBackupServerXml = useBackupServerXml;
            String fileUrl = useBackupServerXml ? this.instanceEnvironment.getBackupConfigFilePath() : this.instanceEnvironment.getConfigFilePath();
            if (useBackupServerXml && (as = AdminService.getAdminService()) != null && (ac = as.getAdminContext()) != null) {
                this.configContext = ac.getAdminConfigContext();
            }
            if (this.configContext == null) {
                this.configContext = ConfigFactory.createConfigContext(fileUrl);
            }
            this.configBean = ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_APPLICATIONS);
            if (this.configBean == null) {
                this.configBean = new Applications();
            }
            this.appConfig = ServerBeansFactory.getDasConfigBean(this.configContext);
            if (this.appConfig == null) {
                this.appConfig = new DasConfig();
            }
        }
        catch (Exception e) {
            throw new ConfigException(Localizer.getValue(ExceptionType.MISSING_SERVER_NODE), e);
        }
    }

    public static String isRegisteredAnywhere(InstanceEnvironment ienv, String id) {
        try {
            BaseManager[] mans = new BaseManager[]{new WebModulesManager(ienv), new EjbModulesManager(ienv), new AppclientModulesManager(ienv), new ConnectorModulesManager(ienv), new AppsManager(ienv)};
            String[] errors = new String[]{"Web Module", "EJB Module", "App Client Module", "Connector Module", "Application"};
            for (int i = 0; i < mans.length; ++i) {
                if (!mans[i].listIds().contains(id)) continue;
                return errors[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Application getDescriptor(String modId, ClassLoader cl, boolean validateXML) throws ConfigException {
        return this.getDescriptor(modId, cl, this.getLocation(modId), validateXML);
    }

    public Application getDescriptor(String modId, ClassLoader cl) throws ConfigException {
        return this.getDescriptor(modId, cl, this.getLocation(modId), false);
    }

    public abstract Application getDescriptor(String var1, ClassLoader var2, String var3, boolean var4) throws ConfigException;

    public boolean isByteCodePreprocessingEnabled() throws ConfigException {
        boolean result = false;
        JavaConfig jc = ServerBeansFactory.getJavaConfigBean(this.configContext);
        if (jc != null && jc.getBytecodePreprocessors() != null) {
            result = true;
        }
        return result;
    }

    public String[] getBytecodeProcessorClassNames() throws ConfigException {
        String[] result = null;
        JavaConfig jc = ServerBeansFactory.getJavaConfigBean(this.configContext);
        if (jc != null) {
            String value = jc.getBytecodePreprocessors();
            _logger.log(Level.INFO, "core.preprocessor_class_name", value);
            result = value.split(",");
        }
        return result;
    }

    public boolean isDynamicReloadEnabled() {
        return this.appConfig.isDynamicReloadEnabled();
    }

    public long getReloadPollIntervalInMillis() {
        long pollIntv;
        String intv = this.appConfig.getDynamicReloadPollIntervalInSeconds();
        try {
            pollIntv = Long.parseLong(intv) * 1000L;
        }
        catch (NumberFormatException nme) {
            BaseManager baseManager = this;
            intv = baseManager.appConfig.getDefaultDynamicReloadPollIntervalInSeconds();
            try {
                pollIntv = Long.parseLong(intv) * 1000L;
            }
            catch (NumberFormatException ne) {
                pollIntv = 2000L;
            }
        }
        return pollIntv;
    }

    public List getSystemCPathPrefixNSuffix() throws ConfigException {
        String suffix;
        ArrayList<String> classPath = new ArrayList<String>();
        JavaConfig jconfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        String prefix = jconfig.getClasspathPrefix();
        if (prefix != null) {
            StringTokenizer st = new StringTokenizer(prefix, File.pathSeparator);
            while (st.hasMoreTokens()) {
                classPath.add(st.nextToken());
            }
        }
        if ((suffix = jconfig.getClasspathSuffix()) != null) {
            StringTokenizer st = new StringTokenizer(suffix, File.pathSeparator);
            while (st.hasMoreTokens()) {
                classPath.add(st.nextToken());
            }
        }
        return classPath;
    }

    public List getSystemClasspath() throws ConfigException {
        String suffix;
        String serverClasspath;
        ArrayList<String> classPath = new ArrayList<String>();
        JavaConfig jconfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        String prefix = jconfig.getClasspathPrefix();
        if (prefix != null) {
            StringTokenizer st = new StringTokenizer(prefix, File.pathSeparator);
            while (st.hasMoreTokens()) {
                classPath.add(st.nextToken());
            }
        }
        if ((serverClasspath = jconfig.getServerClasspath()) != null) {
            StringTokenizer st = new StringTokenizer(serverClasspath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                classPath.add(st.nextToken());
            }
        }
        if ((suffix = jconfig.getClasspathSuffix()) != null) {
            StringTokenizer st = new StringTokenizer(suffix, File.pathSeparator);
            while (st.hasMoreTokens()) {
                classPath.add(st.nextToken());
            }
        }
        return classPath;
    }

    public List getSharedClasspath() throws ConfigException {
        ArrayList<String> classpath = new ArrayList<String>();
        ConnectorModule[] mods = ((Applications)this.configBean).getConnectorModule();
        if (mods != null) {
            for (int i = 0; i < mods.length; ++i) {
                classpath.add(mods[i].getLocation());
            }
        }
        return classpath;
    }

    public List getRmicOptions() throws ConfigException {
        ArrayList<String> rmicOptions = new ArrayList<String>();
        JavaConfig jconfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        String options = jconfig.getRmicOptions();
        if (options == null) {
            options = jconfig.getDefaultRmicOptions();
        }
        StringTokenizer st = new StringTokenizer(options, " ");
        while (st.hasMoreTokens()) {
            String op = st.nextToken();
            rmicOptions.add(op);
            _logger.log(Level.FINE, "Detected Rmic option: " + op);
        }
        return rmicOptions;
    }

    public List getJavacOptions() throws ConfigException {
        ArrayList<String> javacOptions = new ArrayList<String>();
        JavaConfig jconfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        String options = jconfig.getJavacOptions();
        if (options == null) {
            options = jconfig.getDefaultJavacOptions();
        }
        StringTokenizer st = new StringTokenizer(options, " ");
        while (st.hasMoreTokens()) {
            String op = st.nextToken();
            if (op.startsWith(DEBUG_OPTION) || op.startsWith(OPTIMIZE_OPTION)) {
                javacOptions.add(op);
                continue;
            }
            _logger.log(Level.WARNING, "core.unsupported_javac_option", op);
        }
        return javacOptions;
    }

    public boolean isEnvClasspathIgnored() throws ConfigException {
        JavaConfig jconfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        return jconfig.isEnvClasspathIgnored();
    }

    public final boolean isIASOwned(String id) {
        if (!$assertionsDisabled && this.instanceEnvironment == null) {
            throw new AssertionError();
        }
        try {
            return this.instanceEnvironment.isIASOwned(this.getLocation(id));
        }
        catch (Exception e) {
            return false;
        }
    }

    public void refreshConfigContext(ConfigContext ctx) throws ConfigException {
        this.configContext = ctx;
        this.configBean = ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_APPLICATIONS);
    }

    public void refreshConfigContext() throws ConfigException {
        this.configContext.refresh(true);
        this.configBean = ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_APPLICATIONS);
    }

    public InstanceEnvironment getInstanceEnvironment() {
        return this.instanceEnvironment;
    }

    public boolean isShared(String id) throws ConfigException {
        throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.UNSUPPORTED, "isShared()"));
    }

    public void setShared(String modId, boolean shared) throws ConfigException {
        throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.UNSUPPORTED, "setShared()"));
    }

    public String getStubLocation(String id) {
        throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.UNSUPPORTED, "getStubLocation()"));
    }

    public boolean isRegistered(String id) {
        return this.isRegistered(id, this.configBean);
    }

    public void saveConfigContext() throws ConfigException {
        if (!this.useBackupServerXml) {
            throw new ConfigException(Localizer.getValue(ExceptionType.CANT_APPLY));
        }
        this.configContext.flush();
    }

    public void applyServerXmlChanges() throws ConfigException {
        if (!this.useBackupServerXml) {
            throw new ConfigException(Localizer.getValue(ExceptionType.CANT_APPLY));
        }
        this.configContext.flush();
        this.instanceEnvironment.applyServerXmlChanges(false);
    }

    public void setVirtualServers(String modId, String value) throws ConfigException {
    }

    public String getContextRoot(String id) throws ConfigException {
        throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.UNSUPPORTED, "getContextRoot()"));
    }

    public void setContextRoot(String id, String value) throws ConfigException {
        throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.UNSUPPORTED, "setContextRoot()"));
    }

    public abstract Map getRegisteredDescriptors();

    public void registerDescriptor(String registrationName, Application descriptor) {
        Map map = this.getRegisteredDescriptors();
        if (map == null) {
            return;
        }
        map.put(registrationName, descriptor);
    }

    public Application getRegisteredDescriptor(String registrationName) {
        Map map = this.getRegisteredDescriptors();
        if (map == null) {
            return null;
        }
        return (Application)map.get(registrationName);
    }

    public void unregisterDescriptor(String registrationName) {
        Map map = this.getRegisteredDescriptors();
        if (map == null) {
            return;
        }
        map.remove(registrationName);
    }

    public void saveAppDescriptor(String appId, Application appDes, String appDir, String generatedAppDir, boolean isVirtual) throws ConfigException {
        try {
            if (isVirtual) {
                appDes.setVirtual(true);
            }
            FileArchive archive = new FileArchive();
            archive.open(generatedAppDir);
            FileArchive archive2 = new FileArchive();
            archive2.open(appDir);
            DescriptorArchivist archivist = new DescriptorArchivist();
            archivist.write(appDes, (AbstractArchive)archive2, (AbstractArchive)archive);
            Archivist.copyExtraElements(archive2, archive);
        }
        catch (Throwable t) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_SAVE, appId), t);
        }
    }

    boolean isReferenced(String appId) {
        try {
            return ServerHelper.serverReferencesApplication(this.configContext, this.instanceEnvironment.getName(), appId);
        }
        catch (ConfigException ex) {
            _logger.log(Level.WARNING, "isReferenced.unexpectedException", ex);
            return false;
        }
    }

    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    public abstract String getLocation(String var1) throws ConfigException;

    public abstract void setLocation(String var1, String var2) throws ConfigException;

    public abstract String getGeneratedXMLLocation(String var1);

    public abstract boolean isEnabled(String var1) throws ConfigException;

    public abstract void setEnable(String var1, boolean var2) throws ConfigException;

    public abstract boolean isSystem(String var1) throws ConfigException;

    public abstract boolean isSystemAdmin(String var1) throws ConfigException;

    public abstract void setOptionalAttributes(String var1, Properties var2) throws ConfigException;

    public abstract String getDescription(String var1) throws ConfigException;

    public abstract void setDescription(String var1, String var2) throws ConfigException;

    protected abstract boolean isRegistered(String var1, ConfigBean var2);

    public abstract void remove(String var1) throws ConfigException;

    public abstract void register(DeployableObjectInfo var1) throws ConfigException;

    public abstract List listIds() throws ConfigException;

    static {
        $assertionsDisabled = !BaseManager.class.desiredAssertionStatus();
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
    }
}

