/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.diagnostics.ObjectAnalyzer;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationEnvironment {
    private String mAppName = null;
    private String mAppPath = null;
    private String mAppGeneratedXMLPath = null;
    private String mAppStubPath = null;
    private String mAppBackupPath = null;
    private String mAppJSPPath = null;
    private InstanceEnvironment mInstance = null;
    private static Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ApplicationEnvironment(InstanceEnvironment instance, String appName) {
        if (instance == null || appName == null) {
            throw new IllegalArgumentException();
        }
        this.mInstance = instance;
        this.mAppName = appName;
        this.createAppPath();
        this.createAppStubPath();
        this.createAppBackupPath();
        this.createAppJSPPath();
        this.createAppGeneratedXMLPath();
    }

    private void createAppPath() {
        String applicationRepositoryDirPath = this.mInstance.getApplicationRepositoryPath();
        String[] onlyFolderNames = new String[]{applicationRepositoryDirPath, this.mAppName};
        this.mAppPath = StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    private void createAppBackupPath() {
        String applicationBackupRepositoryDirPath = this.mInstance.getApplicationBackupRepositoryPath();
        String[] onlyFolderNames = new String[]{applicationBackupRepositoryDirPath, this.mAppName};
        this.mAppBackupPath = StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public String getAppPath() {
        return this.mAppPath;
    }

    public void createAppStubPath() {
        String[] onlyFolderNames = new String[]{this.mInstance.getApplicationStubPath(), this.mAppName};
        this.mAppStubPath = StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public void createAppGeneratedXMLPath() {
        String[] onlyFolderNames = new String[]{this.mInstance.getApplicationGeneratedXMLPath(), this.mAppName};
        this.mAppGeneratedXMLPath = StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public void createAppJSPPath() {
        String[] onlyFolderNames = new String[]{this.mInstance.getApplicationCompileJspPath(), this.mAppName};
        this.mAppJSPPath = StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public String getAppJSPPath() {
        if (!$assertionsDisabled && !StringUtils.ok((String)this.mAppJSPPath)) {
            throw new AssertionError();
        }
        return this.mAppJSPPath;
    }

    public String getAppStubPath() {
        return this.mAppStubPath;
    }

    public String getAppGeneratedXMLPath() {
        return this.mAppGeneratedXMLPath;
    }

    public String toString() {
        return ObjectAnalyzer.toString(this);
    }

    public static void main(String[] args) {
        InstanceEnvironment env = new InstanceEnvironment("foo");
        ApplicationEnvironment ae = new ApplicationEnvironment(env, "myapp");
        _logger.log(Level.INFO, "core.appenv_dump");
        _logger.log(Level.INFO, ae.toString());
    }

    static {
        $assertionsDisabled = !ApplicationEnvironment.class.desiredAssertionStatus();
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
    }
}

