/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.Cache;
import com.sun.ejb.ComponentContext;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.tx.JTSEvent;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.enterprise.resource.PoolManagerImpl;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.transaction.JTSConfigChangeEventListener;
import com.sun.enterprise.transaction.TransactionAdminBean;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.AdminUtil;
import com.sun.jts.jta.TransactionImpl;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.pi.InterceptorImpl;
import com.sun.logging.LogDomains;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.SingleThreadModel;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class J2EETransactionManagerImpl
implements J2EETransactionManager {
    static Logger _logger;
    private static final String TX_TIMEOUT = "transaction.timeout";
    private static final String TX_OPT = "transaction.nonXA.optimization";
    private TransactionManager tm;
    private boolean multipleEnlistDelists = false;
    private static StringManager sm;
    protected InvocationManager invMgr;
    protected PoolManager poolmgr;
    protected int transactionTimeout;
    protected boolean useLAO = true;
    protected Hashtable statusMap;
    protected Vector activeTransactions;
    protected boolean monitoringEnabled = false;
    protected static int[] JTAStatus;
    protected static String[] STATUS;
    protected int m_transCommitted = 0;
    protected int m_transRolledback = 0;
    protected int m_transInFlight = 0;
    private Cache resourceTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public J2EETransactionManagerImpl() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: Initializing distributed TM...");
        }
        this.tm = TransactionManagerImpl.getTransactionManagerImpl();
        this.poolmgr = new PoolManagerImpl();
        Switch.getSwitch().setPoolManager(this.poolmgr);
        ResourceInstaller installer = new ResourceInstaller();
        Switch.getSwitch().setResourceInstaller(installer);
        int maxEntries = 8192;
        float loadFactor = 0.75f;
        try {
            String mEnlistDelists;
            String loadFactorValue;
            float f;
            String maxEntriesValue = System.getProperty("JTA_RESOURCE_TABLE_MAX_ENTRIES");
            int temp = Integer.parseInt(maxEntriesValue);
            if (temp > 0) {
                maxEntries = temp;
            }
            if ((f = Float.parseFloat(loadFactorValue = System.getProperty("JTA_RESOURCE_TABLE_DEFAULT_LOAD_FACTOR"))) > 0.0f) {
                loadFactor = f;
            }
            if ("true".equals(mEnlistDelists = System.getProperty("ALLOW_MULTIPLE_ENLISTS_DELISTS"))) {
                this.multipleEnlistDelists = true;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "TM: multiple enlists, delists are enabled");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        Properties cacheProps = null;
        this.resourceTable = new BaseCache();
        ((BaseCache)this.resourceTable).init(maxEntries, loadFactor, cacheProps);
        this.invMgr = Switch.getSwitch().getInvocationManager();
        ServerContext sCtx = ApplicationServer.getServerContext();
        if (sCtx != null) {
            ConfigContext ctx = sCtx.getConfigContext();
            TransactionService txnService = null;
            try {
                txnService = ServerBeansFactory.getTransactionServiceBean(ctx);
                this.transactionTimeout = Integer.parseInt(txnService.getTimeoutInSeconds());
                ElementProperty[] eprops = txnService.getElementProperty();
                for (int index = 0; index < eprops.length; ++index) {
                    if (!"use-last-agent-optimization".equals(eprops[index].getName()) || !"false".equals(eprops[index].getValue())) continue;
                    this.useLAO = false;
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "TM: LAO is disabled");
                }
            }
            catch (ConfigException e) {
                throw new RuntimeException(sm.getString("enterprise_distributedtx.config_excep", e));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: Tx Timeout = " + this.transactionTimeout);
        }
        this.activeTransactions = new Vector();
        this.statusMap = new Hashtable();
        for (int i = 0; i < JTAStatus.length; ++i) {
            this.statusMap.put(new Integer(JTAStatus[i]), STATUS[i]);
        }
        try {
            String doStats = System.getProperty("MONITOR_JTA_RESOURCE_TABLE_STATISTICS");
            if (Boolean.getBoolean(doStats)) {
                this.registerStatisticMonitorTask();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static J2EETransactionManager createTransactionManager() {
        J2EETransactionManagerImpl j2eeTM;
        ServerConfiguration sc = ServerConfiguration.getConfiguration();
        String txOpt = sc.getProperty(TX_OPT);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: Tx Opt = " + txOpt);
        }
        if (txOpt != null && txOpt.equals("false")) {
            j2eeTM = new J2EETransactionManagerImpl();
        } else {
            J2EETransaction.j2eeTM = j2eeTM = new J2EETransactionManagerOpt();
        }
        return j2eeTM;
    }

    private static void print(String s) {
        _logger.log(Level.FINE, s);
    }

    public boolean isNullTransaction() {
        try {
            return InterceptorImpl.isTxCtxtNull();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void recover(XAResource[] resourceList) {
        int size = resourceList.length;
        Vector<XAResource> v = new Vector<XAResource>();
        for (int i = 0; i < size; ++i) {
            v.addElement(resourceList[i]);
        }
        TransactionManagerImpl cfr_ignored_0 = (TransactionManagerImpl)this.tm;
        TransactionManagerImpl.recover(v.elements());
    }

    public boolean enlistResource(Transaction tran, ResourceHandle h) throws RollbackException, IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: enlistResource");
        }
        if (h.isTransactional() && (!h.isEnlisted() || !h.isShareable() || this.multipleEnlistDelists)) {
            XAResource res = h.getXAResource();
            boolean result = tran.enlistResource(res);
            if (!h.isEnlisted()) {
                this.poolmgr.resourceEnlisted(tran, h);
            }
            return result;
        }
        return true;
    }

    public boolean enlistLAOResource(Transaction tran, ResourceHandle h) throws RollbackException, IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: enlistLAOResource");
        }
        if (h.isTransactional()) {
            XAResource res = h.getXAResource();
            boolean result = tran.enlistResource(res);
            return result;
        }
        return true;
    }

    public void enlistComponentResources() throws RemoteException {
        ComponentInvocation inv;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: enlistComponentResources");
        }
        if ((inv = this.invMgr.getCurrentInvocation()) == null) {
            throw new InvocationException();
        }
        try {
            Transaction tran = this.getTransaction();
            inv.setTransaction(tran);
            this.enlistComponentResources(inv);
        }
        catch (InvocationException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", ex);
            throw new RemoteException("", ex.getNestedException());
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", ex);
            throw new RemoteException("", ex);
        }
    }

    public void delistComponentResources(boolean suspend) throws RemoteException {
        ComponentInvocation inv;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: delistComponentResources");
        }
        if ((inv = this.invMgr.getCurrentInvocation()) == null) {
            throw new InvocationException();
        }
        try {
            this.delistComponentResources(inv, suspend);
        }
        catch (InvocationException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", ex);
            throw new RemoteException("", ex.getNestedException());
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", ex);
            throw new RemoteException("", ex);
        }
    }

    public void registerComponentResource(ResourceHandle h) {
        Object instance;
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        if (inv != null) {
            instance = inv.getInstance();
            if (instance == null) {
                return;
            }
        } else {
            throw new InvocationException();
        }
        h.setComponentInstance(instance);
        List l = this.getResourceList(instance, inv);
        l.add(h);
    }

    public void unregisterComponentResource(ResourceHandle h) {
        Object instance = h.getComponentInstance();
        if (instance == null) {
            return;
        }
        h.setComponentInstance(null);
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        List l = null;
        l = inv != null ? this.getExistingResourceList(instance, inv) : this.getExistingResourceList(instance);
        if (l != null) {
            l.remove(h);
        }
    }

    private void handleResourceError(ResourceHandle h, Exception ex, Transaction tran, ComponentInvocation inv) {
        if (_logger.isLoggable(Level.FINE) && h.isTransactional()) {
            _logger.log(Level.FINE, "TM: HandleResourceError " + h.getXAResource() + "," + ex);
        }
        try {
            if (tran != null && h.isTransactional()) {
                tran.delistResource(h.getXAResource(), 0x4000000);
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        if (ex instanceof RollbackException) {
            return;
        }
        if (ex instanceof IllegalStateException) {
            try {
                h.getResourceAllocator().closeUserConnection(h);
            }
            catch (Exception ex2) {}
        } else {
            try {
                h.getResourceAllocator().destroyResource(h);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    private void enlistComponentResources(ComponentInvocation inv) throws InvocationException {
        try {
            Transaction tran = inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                List l = this.getResourceList(inv.getInstance(), inv);
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    ResourceHandle h = (ResourceHandle)it.next();
                    try {
                        this.enlistResource(tran, h);
                    }
                    catch (Exception ex) {
                        it.remove();
                        this.handleResourceError(h, ex, tran, inv);
                    }
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", ex);
        }
    }

    private void delistComponentResources(ComponentInvocation inv, boolean suspend) throws InvocationException {
        try {
            Transaction tran = inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                ArrayList l = this.getExistingResourceList(inv.getInstance(), inv);
                if (l == null) {
                    l = new ArrayList(0);
                }
                Iterator it = l.iterator();
                int flag = 0x4000000;
                if (suspend) {
                    flag = 0x2000000;
                }
                while (it.hasNext()) {
                    ResourceHandle h = (ResourceHandle)it.next();
                    try {
                        this.delistResource(tran, h, flag);
                    }
                    catch (IllegalStateException ex) {
                    }
                    catch (Exception ex) {
                        it.remove();
                        this.handleResourceError(h, ex, tran, inv);
                    }
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", ex);
        }
    }

    private boolean isTransactionActive(Transaction tran) {
        return tran != null;
    }

    public void preInvoke(ComponentInvocation prev) throws InvocationException {
        if (prev != null && prev.getTransaction() != null && !prev.isTransactionCompleting()) {
            this.delistComponentResources(prev, true);
        }
    }

    public void postInvoke(ComponentInvocation curr, ComponentInvocation prev) throws InvocationException {
        if (curr != null && curr.getTransaction() != null) {
            this.delistComponentResources(curr, false);
        }
        if (prev != null && prev.getTransaction() != null && !prev.isTransactionCompleting()) {
            this.enlistComponentResources(prev);
        }
    }

    public void componentDestroyed(Object instance) {
        List l;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: componentDestroyed" + instance);
        }
        if ((l = (List)this.resourceTable.get(this.getInstanceKey(instance))) != null) {
            this.resourceTable.remove(this.getInstanceKey(instance));
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ResourceHandle h = (ResourceHandle)it.next();
                try {
                    h.getResourceAllocator().closeUserConnection(h);
                }
                catch (PoolingException ex) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.WARNING, "enterprise_distributedtx.pooling_excep", ex);
                }
            }
            l.clear();
        }
    }

    public void ejbDestroyed(ComponentContext context) {
        List l;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, " ejbDestroyed: " + context);
        }
        if ((l = context.getResourceList()) != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ResourceHandle h = (ResourceHandle)it.next();
                try {
                    h.getResourceAllocator().closeUserConnection(h);
                }
                catch (PoolingException ex) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.WARNING, "enterprise_distributedtx.pooling_excep", ex);
                }
            }
            l.clear();
        }
    }

    private Object getInstanceKey(Object instance) {
        Vector<Object> key = null;
        if (instance instanceof Servlet || instance instanceof Filter) {
            if (instance instanceof SingleThreadModel) {
                key = instance;
            } else {
                Vector<Object> pair = new Vector<Object>(2);
                pair.addElement(instance);
                pair.addElement(Thread.currentThread());
                key = pair;
            }
        } else {
            key = instance;
        }
        return key;
    }

    public List getExistingResourceList(Object instance) {
        Object key = this.getInstanceKey(instance);
        return (List)this.resourceTable.get(key);
    }

    public List getExistingResourceList(Object instance, ComponentInvocation inv) {
        List l = null;
        if (inv.getInvocationType() == 1) {
            ComponentContext ctx = inv.context;
            if (ctx != null) {
                l = ctx.getResourceList();
            }
            return l;
        }
        Object key = this.getInstanceKey(instance);
        return (List)this.resourceTable.get(key);
    }

    public List getResourceList(Object instance) {
        Object key = this.getInstanceKey(instance);
        ArrayList l = (ArrayList)this.resourceTable.get(key);
        if (l == null) {
            l = new ArrayList();
            this.resourceTable.put(key, l);
        }
        return l;
    }

    private List getResourceList(Object instance, ComponentInvocation inv) {
        List l = null;
        if (inv.getInvocationType() == 1) {
            ComponentContext ctx = inv.context;
            l = ctx != null ? ctx.getResourceList() : new ArrayList(0);
        } else {
            Object key = this.getInstanceKey(instance);
            l = (List)this.resourceTable.get(key);
            if (l == null) {
                l = new ArrayList();
                this.resourceTable.put(key, l);
            }
        }
        return l;
    }

    public boolean delistResource(Transaction tran, ResourceHandle h, int flag) throws IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: delistResource");
        }
        if (!h.isShareable() || this.multipleEnlistDelists) {
            if (h.isTransactional()) {
                return tran.delistResource(h.getXAResource(), flag);
            }
            return true;
        }
        return true;
    }

    public void registerSynchronization(Synchronization sync) throws IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: registerSynchronization");
        }
        try {
            Transaction tran = this.getTransaction();
            if (tran != null) {
                tran.registerSynchronization(sync);
            }
        }
        catch (RollbackException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.rollbackexcep_in_regsynch", ex);
            throw new IllegalStateException();
        }
    }

    public void begin(int timeout) throws NotSupportedException, SystemException {
        ((TransactionManagerImpl)this.tm).begin(timeout);
        if (this.monitoringEnabled) {
            Transaction tran = this.tm.getTransaction();
            this.activeTransactions.addElement(tran);
            ++this.m_transInFlight;
        }
    }

    public void checkTransactionExport(boolean isLocal) {
    }

    public void checkTransactionImport() {
    }

    public void begin() throws NotSupportedException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: begin");
        }
        ((TransactionManagerImpl)this.tm).begin(this.transactionTimeout);
        if (this.monitoringEnabled) {
            Transaction tran = this.tm.getTransaction();
            this.activeTransactions.addElement(tran);
            ++this.m_transInFlight;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: commit");
        }
        Transaction obj = null;
        if (this.monitoringEnabled) {
            obj = this.tm.getTransaction();
        }
        if (this.invMgr.isInvocationStackEmpty()) {
            try {
                this.tm.commit();
                if (!this.monitoringEnabled) return;
                this.monitorTxCompleted(obj, true);
                return;
            }
            catch (RollbackException e) {
                if (!this.monitoringEnabled) throw e;
                this.monitorTxCompleted(obj, false);
                throw e;
            }
            catch (HeuristicRollbackException e) {
                if (!this.monitoringEnabled) throw e;
                this.monitorTxCompleted(obj, false);
                throw e;
            }
            catch (HeuristicMixedException e) {
                if (!this.monitoringEnabled) throw e;
                this.monitorTxCompleted(obj, true);
                throw e;
            }
        }
        ComponentInvocation curr = null;
        try {
            curr = this.invMgr.getCurrentInvocation();
            curr.setTransactionCompeting(true);
            this.tm.commit();
            if (!this.monitoringEnabled) return;
            this.monitorTxCompleted(obj, true);
            return;
        }
        catch (InvocationException ex) {
            if ($assertionsDisabled) return;
            throw new AssertionError();
        }
        catch (RollbackException e) {
            if (!this.monitoringEnabled) throw e;
            this.monitorTxCompleted(obj, false);
            throw e;
        }
        catch (HeuristicRollbackException e) {
            if (!this.monitoringEnabled) throw e;
            this.monitorTxCompleted(obj, false);
            throw e;
        }
        catch (HeuristicMixedException e) {
            if (!this.monitoringEnabled) throw e;
            this.monitorTxCompleted(obj, true);
            throw e;
        }
        finally {
            if (curr != null) {
                curr.setTransactionCompeting(false);
            }
        }
    }

    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.tm.getTransaction();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: resume");
        }
        this.tm.resume(tobj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: rollback");
        }
        Transaction obj = null;
        if (this.monitoringEnabled) {
            obj = this.tm.getTransaction();
        }
        if (this.invMgr.isInvocationStackEmpty()) {
            this.tm.rollback();
        } else {
            ComponentInvocation curr = null;
            try {
                curr = this.invMgr.getCurrentInvocation();
                curr.setTransactionCompeting(true);
                this.tm.rollback();
            }
            catch (InvocationException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            finally {
                if (curr != null) {
                    curr.setTransactionCompeting(false);
                }
            }
        }
        if (this.monitoringEnabled) {
            this.monitorTxCompleted(obj, false);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: setRollbackOnly");
        }
        this.tm.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            seconds = 0;
        }
        this.transactionTimeout = seconds;
    }

    public Transaction suspend() throws SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TM: suspend");
        }
        return this.tm.suspend();
    }

    public ArrayList getActiveTransactions() {
        ArrayList<TransactionAdminBean> tranBeans = new ArrayList<TransactionAdminBean>();
        Vector active = (Vector)this.activeTransactions.clone();
        for (int i = 0; i < active.size(); ++i) {
            try {
                Transaction tran = (Transaction)active.elementAt(i);
                String id = "unknown";
                long startTime = 0L;
                long elapsedTime = 0L;
                String status = "unknown";
                if (tran instanceof TransactionImpl) {
                    id = ((TransactionImpl)tran).getTransactionId();
                    startTime = ((TransactionImpl)tran).getStartTime();
                } else if (tran instanceof J2EETransaction) {
                    id = ((J2EETransaction)tran).getTransactionId();
                    startTime = ((J2EETransaction)tran).getStartTime();
                }
                elapsedTime = System.currentTimeMillis() - startTime;
                status = (String)this.statusMap.get(new Integer(tran.getStatus()));
                TransactionAdminBean tBean = new TransactionAdminBean(tran, id, status, elapsedTime);
                tranBeans.add(tBean);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return tranBeans;
    }

    public void forceRollback(Transaction tran) throws IllegalStateException, SystemException {
        if (tran != null) {
            tran.setRollbackOnly();
        }
    }

    public int getNumberOfTransactionsCommitted() {
        return this.m_transCommitted;
    }

    public int getNumberOfTransactionsRolledBack() {
        return this.m_transRolledback;
    }

    public int getNumberOfActiveTransactions() {
        return this.m_transInFlight;
    }

    public synchronized void freeze() {
        if (AdminUtil.isFrozenAll()) {
            return;
        }
        AdminUtil.freezeAll();
    }

    public synchronized void unfreeze() {
        if (AdminUtil.isFrozenAll()) {
            AdminUtil.unfreezeAll();
        }
    }

    public synchronized boolean isFrozen() {
        return AdminUtil.isFrozenAll();
    }

    public void recreate(Xid xid, long timeout) throws WorkException {
        TransactionManagerImpl cfr_ignored_0 = (TransactionManagerImpl)this.tm;
        TransactionManagerImpl.recreate(xid, timeout);
    }

    public void release(Xid xid) throws WorkException {
        TransactionManagerImpl cfr_ignored_0 = (TransactionManagerImpl)this.tm;
        TransactionManagerImpl.release(xid);
    }

    public XATerminator getXATerminator() {
        TransactionManagerImpl cfr_ignored_0 = (TransactionManagerImpl)this.tm;
        return TransactionManagerImpl.getXATerminator();
    }

    protected void monitorTxCompleted(Object tran, boolean committed) {
        if (tran == null || !this.activeTransactions.remove(tran)) {
            return;
        }
        if (committed) {
            ++this.m_transCommitted;
        } else {
            ++this.m_transRolledback;
        }
        --this.m_transInFlight;
    }

    public void setMonitoringEnabled(boolean enabled) {
        this.monitoringEnabled = enabled;
        this.m_transCommitted = 0;
        this.m_transRolledback = 0;
        this.m_transInFlight = 0;
        this.activeTransactions.removeAllElements();
    }

    public boolean isTimedOut() {
        return false;
    }

    private void registerStatisticMonitorTask() {
        StatisticMonitorTask task = new StatisticMonitorTask();
        Timer timer = Switch.getSwitch().getTimer();
        int statInterval = 120000;
        try {
            String interval = System.getProperty("MONITOR_JTA_RESOURCE_TABLE_SECONDS");
            int temp = Integer.parseInt(interval);
            if (temp > 0) {
                statInterval = temp;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        timer.scheduleAtFixedRate((TimerTask)task, 0L, (long)statInterval);
    }

    static {
        $assertionsDisabled = !J2EETransactionManagerImpl.class.desiredAssertionStatus();
        _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
        sm = StringManager.getManager(J2EETransactionManagerImpl.class);
        JTAStatus = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        STATUS = new String[]{"Active", "MarkedRollback", "Prepared", "Committed", "RolledBack", "UnKnown", "NoTransaction", "Preparing", "Committing", "RollingBack"};
        AdminEventListenerRegistry.addEventListener(JTSEvent.eventType, new JTSConfigChangeEventListener());
    }

    class StatisticMonitorTask
    extends TimerTask {
        StatisticMonitorTask() {
        }

        public void run() {
            if (J2EETransactionManagerImpl.this.resourceTable != null) {
                Map stats = J2EETransactionManagerImpl.this.resourceTable.getStats();
                Iterator it = stats.keySet().iterator();
                System.out.println("********** J2EETransactionManagerImpl.resourceTable stats *****");
                while (it.hasNext()) {
                    String key = (String)it.next();
                    System.out.println(key + ": " + stats.get(key).toString());
                }
            }
        }
    }
}

