/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.ComponentValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;

public class EjbBundleValidator
extends ComponentValidator
implements EjbBundleVisitor {
    protected EjbBundleDescriptor ejbBundleDescriptor = null;
    protected EjbDescriptor ejb = null;

    public void accept(EjbBundleDescriptor bundleDescriptor) {
        this.ejbBundleDescriptor = bundleDescriptor;
        if (!bundleDescriptor.areResourceReferencesValid()) {
            throw new RuntimeException("Incorrectly resolved role references");
        }
    }

    public void accept(EjbDescriptor ejb) {
        this.ejb = ejb;
    }

    public void accept(WebService webService) {
    }

    public void accept(EjbReference ejbRef) {
        DOLUtils.getDefaultLogger().fine("Visiting Ref" + ejbRef);
        if (ejbRef.getEjbDescriptor() != null) {
            return;
        }
        if (ejbRef.getJndiName() != null && ejbRef.getJndiName().length() != 0 && (!ejbRef.isLocal() || ejbRef.isLocal() && ejbRef.getLinkName() == null)) {
            DOLUtils.getDefaultLogger().fine("Ref " + ejbRef.getName() + " is bound to Ejb with JNDI Name " + ejbRef.getJndiName());
            if (this.getEjbDescriptors() != null) {
                Iterator iter = this.getEjbDescriptors().iterator();
                while (iter.hasNext()) {
                    EjbDescriptor ejb = (EjbDescriptor)iter.next();
                    if (!ejbRef.getJndiName().equals(ejb.getJndiName())) continue;
                    ejbRef.setEjbDescriptor(ejb);
                    return;
                }
            }
        }
        if (ejbRef.getLinkName() == null) {
            if (ejbRef.isLocal()) {
                DOLUtils.getDefaultLogger().info("Cannot resolve reference " + ejbRef);
                throw new RuntimeException("Cannot resolve reference " + ejbRef);
            }
            DOLUtils.getDefaultLogger().fine("Warning: Unresolved ejb-ref " + ejbRef);
            return;
        }
        String homeClassName = ejbRef.getEjbHomeInterface();
        String intfClassName = ejbRef.getEjbInterface();
        String type = ejbRef.getType();
        EjbDescriptor ejbReferee = null;
        String linkName = ejbRef.getLinkName();
        int ind = linkName.lastIndexOf(35);
        if (ind != -1) {
            BundleDescriptor refereeJar;
            String ejbName = linkName.substring(ind + 1);
            String jarPath = linkName.substring(0, ind);
            BundleDescriptor referringJar = ejbRef.getReferringBundleDescriptor();
            if (referringJar == null) {
                ejbRef.setReferringBundleDescriptor(this.getBundleDescriptor());
                referringJar = this.getBundleDescriptor();
            }
            if (this.getApplication() != null && (refereeJar = this.getApplication().getRelativeBundle(referringJar, jarPath)) != null && refereeJar instanceof EjbBundleDescriptor) {
                ejbReferee = ((EjbBundleDescriptor)refereeJar).getEjbByName(ejbName);
            }
        } else if (this.getApplication() != null && this.getApplication().hasEjbByName(linkName)) {
            ejbReferee = this.getApplication().getEjbByName(ejbRef.getLinkName());
        } else if (this.ejb != null) {
            try {
                ejbReferee = this.ejb.getEjbBundleDescriptor().getEjbByName(ejbRef.getLinkName());
            }
            catch (IllegalArgumentException e) {
                DOLUtils.getDefaultLogger().info("Warning: Unresolved <ejb-link>: " + linkName);
                return;
            }
        }
        if (ejbReferee == null) {
            if (ejbRef.isLocal()) {
                DOLUtils.getDefaultLogger().info("Error: Unresolved <ejb-link>: " + linkName);
                throw new RuntimeException("Error: Unresolved <ejb-link>: " + linkName);
            }
            DOLUtils.getDefaultLogger().info("Warning: Unresolved <ejb-link>: " + linkName);
            return;
        }
        ejbRef.setEjbDescriptor(ejbReferee);
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Done Visiting " + this.ejb.getName() + " reference " + ejbRef);
        }
        if (!homeClassName.equals(ejbRef.getEjbHomeInterface())) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{linkName, ejbRef.getEjbHomeInterface()});
            ejbRef.setEjbHomeInterface(ejbRef.getEjbHomeInterface());
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{linkName, ejbRef.getEjbHomeInterface()});
        }
        if (!intfClassName.equals(ejbRef.getEjbInterface())) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{linkName, ejbRef.getEjbInterface()});
            ejbRef.setEjbInterface(ejbRef.getEjbInterface());
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{linkName, ejbRef.getEjbInterface()});
        }
        if (!type.equals(ejbRef.getType())) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{linkName, ejbRef.getType()});
            ejbRef.setType(ejbRef.getType());
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{linkName, ejbRef.getType()});
        }
    }

    protected Collection getEjbDescriptors() {
        if (this.ejbBundleDescriptor != null) {
            return this.ejbBundleDescriptor.getEjbs();
        }
        return null;
    }

    protected Application getApplication() {
        return null;
    }

    protected BundleDescriptor getBundleDescriptor() {
        return this.ejbBundleDescriptor;
    }
}

