/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.ui;

import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.diagnostics.Reporter;
import com.sun.enterprise.util.diagnostics.SystemProps;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SystemPropertiesSetter {
    private static final boolean debug = false;
    private static final String IAS_SERVER_HOME = "com.sun.aas.instanceRoot";
    private static final String RI_SERVER_HOME = "com.sun.enterprise.home";
    private static final String SYSTEM_PROPS_FILENAME = "ias_startup.properties";
    private static String DEFAULT_IAS_UNIX_HOME = "/j2ee";
    private static String DEFAULT_IAS_WIN_HOME = "C:\\j2ee";
    private static String REPORTER_LEVEL = "com.iplanet.util.diagnostic.Reporter.severityLevel";
    private static final String STARS = "****************************************************";
    private String computerName;
    private Properties iasProps;
    private File propsFile = null;
    private static boolean byron = false;

    public SystemPropertiesSetter(Properties p) {
        this.iasProps = p;
        this.set();
    }

    public SystemPropertiesSetter() {
        String home = System.getProperty(IAS_SERVER_HOME);
        Reporter.crit("home: " + home);
        if (home == null || home.length() <= 0) {
            String dirName = File.separatorChar == '\\' ? DEFAULT_IAS_WIN_HOME : DEFAULT_IAS_UNIX_HOME;
            this.propsFile = new File(dirName, SYSTEM_PROPS_FILENAME);
            Reporter.verbose("Null or empty required command-line define: com.sun.aas.instanceRoot\nTrying the default: " + FileUtils.safeGetCanonicalPath(this.propsFile));
        } else {
            this.propsFile = new File(new File(home), SYSTEM_PROPS_FILENAME);
        }
        this.checkPropsFile();
        if (this.propsFile == null) {
            return;
        }
        this.readProps();
        this.set();
    }

    public SystemPropertiesSetter(File f) {
        if (f == null || !f.exists()) {
            return;
        }
        this.propsFile = f.isDirectory() ? new File(f, SYSTEM_PROPS_FILENAME) : f;
        this.checkPropsFile();
        if (this.propsFile == null) {
            return;
        }
        this.readProps();
        this.set();
    }

    public SystemPropertiesSetter(String s) {
        this(new File(s));
    }

    private void set() {
        this.setComputerName();
        this.trimProps();
        this.replaceMacros();
        this.setReporter();
        this.removePropsAlreadyInSystem();
        this.fixFilePaths();
        this.addToSystemProps();
    }

    private void checkPropsFile() {
        if (this.propsFile == null) {
            return;
        }
        if (!this.propsFile.exists()) {
            Reporter.error("System Properties File points to a file that doesn't exist: " + this.propsFile);
            this.propsFile = null;
            return;
        }
        if (this.propsFile.isDirectory()) {
            Reporter.error("System Properties File points to a directory, not a file: " + this.propsFile);
            this.propsFile = null;
            return;
        }
        Reporter.verbose("Using System Properties File: " + this.propsFile);
    }

    private void readProps() {
        new File(this.propsFile, SYSTEM_PROPS_FILENAME);
        if (!this.propsFile.exists()) {
            this.goodbye("ias Startup Properties file doesn't exist: " + this.propsFile.getAbsolutePath());
        }
        if (this.propsFile.isDirectory()) {
            this.goodbye("ias Startup Properties file isn't a file.  It is a directory: " + this.propsFile.getAbsolutePath());
        }
        try {
            FileInputStream fis = new FileInputStream(this.propsFile);
            this.iasProps = new Properties();
            this.iasProps.load(fis);
        }
        catch (Exception e) {
            this.goodbye("Error reading iAS Server Properties, File: " + this.propsFile.getAbsolutePath() + ", " + e);
        }
    }

    private void trimProps() {
        Iterator it = this.getSetIterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String val = (String)entry.getValue();
            entry.setValue(val.trim());
        }
    }

    private void setComputerName() {
        try {
            this.computerName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.goodbye("Can't figure out what the computer's name is. InetAddress.getLocalHost().getHostName() threw an Exception: " + e);
        }
    }

    private void replaceMacros() {
        String macro1Name = "%IAS_HOME%";
        String macro1Value = this.getIasDir();
        String macro2Name = "%COMPUTER_NAME%";
        String macro2Value = this.computerName;
        Iterator it = this.getSetIterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String val = (String)entry.getValue();
            val = StringUtils.replace((String)val, (String)macro1Name, (String)macro1Value);
            val = StringUtils.replace((String)val, (String)macro2Name, (String)macro2Value);
            entry.setValue(val);
        }
    }

    private void setReporter() {
        String s = System.getProperty(REPORTER_LEVEL);
        if (!StringUtils.ok((String)s)) {
            s = this.iasProps.getProperty(REPORTER_LEVEL);
        }
        if (StringUtils.ok((String)s)) {
            Reporter.setSeverityLevel(s);
        } else {
            Reporter.setSeverityLevel(1000);
        }
    }

    private String getIasDir() {
        String s = this.iasProps.getProperty(IAS_SERVER_HOME);
        if (StringUtils.ok((String)s)) {
            return s;
        }
        s = System.getProperty(IAS_SERVER_HOME);
        if (StringUtils.ok((String)s)) {
            return s;
        }
        s = this.iasProps.getProperty(RI_SERVER_HOME);
        if (StringUtils.ok((String)s)) {
            return s;
        }
        s = System.getProperty(RI_SERVER_HOME);
        if (StringUtils.ok((String)s)) {
            return s;
        }
        s = this.getDefaultIasHome();
        Reporter.verbose("Setting com.sun.aas.instanceRoot and com.sun.enterprise.hometo: " + s);
        this.iasProps.setProperty(IAS_SERVER_HOME, s);
        this.iasProps.setProperty(RI_SERVER_HOME, s);
        return s;
    }

    private void removePropsAlreadyInSystem() {
        Iterator it = this.getSetIterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            if (System.getProperty(key) == null) continue;
            it.remove();
        }
    }

    private void fixFilePaths() {
        Iterator it = this.getSetIterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String val = (String)entry.getValue();
            if (val.indexOf(47) < 0 && val.indexOf(92) < 0) continue;
            val = OS.isUNIX() ? val.replace('\\', '/') : val.replace('/', '\\');
            entry.setValue(val);
        }
    }

    private void addToSystemProps() {
        if (this.iasProps.size() <= 0) {
            return;
        }
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)this.iasProps);
        System.setProperties(sysProps);
    }

    private void dumpNewSystemProps() {
        Map.Entry entry;
        int longestKey = 0;
        System.out.println("About to add these properties to the system:");
        Iterator it = this.getSetIterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            int len = ((String)entry.getKey()).length();
            if (len <= longestKey) continue;
            longestKey = len;
        }
        ++longestKey;
        it = this.getSetIterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            String s = StringUtils.padRight((String)((String)entry.getKey()), (int)longestKey);
            s = s + "= ";
            s = s + (String)entry.getValue();
            System.out.println(s);
        }
    }

    private Iterator getSetIterator() {
        Set<Map.Entry<Object, Object>> set = this.iasProps.entrySet();
        return set.iterator();
    }

    private void goodbye(String s) {
        System.out.println("****************************************************\n**** Can't start Server: " + s + "\n" + STARS);
        System.exit(1);
    }

    private String getDefaultIasHome() {
        if (OS.isWindows()) {
            return DEFAULT_IAS_WIN_HOME;
        }
        return DEFAULT_IAS_UNIX_HOME;
    }

    public static void main(String[] args) {
        Reporter.setSeverityLevel(0);
        if (byron) {
            args = new String[]{"C:\\j2ee\\config", "C:\\iplanet\\ias7se_src\\iplanet\\ias\\server\\src\\java\\com\\iplanet\\ias\\deployment\\ias_startup.properties"};
        }
        Reporter.verbose("Testing the default location...");
        new SystemPropertiesSetter();
        for (int i = 0; args != null && i < args.length; ++i) {
            Reporter.verbose("Testing arg" + i);
            new SystemPropertiesSetter(new File(args[i]));
        }
        System.out.println(SystemProps.toStringStatic());
    }
}

