/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;

class SimplePersistence {
    private Properties props = new Properties();
    private File persistenceFile = null;
    private static final String persistenceFileRootName = "ui.properties";

    SimplePersistence() {
        this.init();
        this.load();
    }

    String getProperty(String key) {
        return this.props.getProperty(key);
    }

    Properties getProperties() {
        return this.props;
    }

    void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    private void init() {
        String aFile = "SimplePersistence.class";
        URL url = this.getClass().getResource("SimplePersistence.class");
        String filename = url.getPath();
        if (this.canWrite(filename)) {
            filename = filename.substring(0, filename.indexOf("SimplePersistence.class"));
            filename = filename + persistenceFileRootName;
            this.persistenceFile = new File(filename);
        } else {
            this.persistenceFile = new File(System.getProperty("java.io.tmpdir"));
            this.persistenceFile = new File(this.persistenceFile, persistenceFileRootName);
        }
        if (!this.persistenceFile.exists()) {
            this.store();
        }
        System.out.println("Persistence File: " + this.persistenceFile.getAbsolutePath());
    }

    private void load() {
        try {
            FileInputStream in = new FileInputStream(this.persistenceFile);
            this.props.load(in);
            ((InputStream)in).close();
            System.out.println(this.props);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void store() {
        try {
            FileOutputStream os = new FileOutputStream(this.persistenceFile);
            this.props.store(os, "DBETestToolUI Properties");
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean canWrite(String fname) {
        File f = new File(fname);
        if (f.exists()) {
            return f.canWrite();
        }
        try {
            return f.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        SimplePersistence sp = new SimplePersistence();
    }
}

