/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.ui;

import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.ui.DBETestTool;
import com.sun.enterprise.deployment.ui.SimplePersistence;
import com.sun.enterprise.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DBETestToolGUI
extends JFrame
implements ActionListener {
    private SimplePersistence persist = new SimplePersistence();
    private JButton submit;
    private JButton cancel;
    private JComboBox command;
    private JComboBox type;
    private JCheckBox forced;
    private JCheckBox noEJBC;
    private JCheckBox jspc;
    private JTextField fileSource;
    private JTextField name;
    private JTextField contextRoot;
    private JTextField instance;
    private JTextField installRoot;
    private JTextField domain;
    private JTextField domains;
    private GridBagLayout gb;
    private GridBagConstraints gbc;
    private Container contentPane;
    private static final String p_command = "command";
    private static final String p_type = "type";
    private static final String p_forced = "forced";
    private static final String p_noEJBC = "noejbc";
    private static final String p_jspc = "jspc";
    private static final String p_fileSource = "file";
    private static final String p_name = "name";
    private static final String p_contextRoot = "contextroot";
    private static final String p_instance = "instance";
    private static final String p_installRoot = "installRoot";
    private static final String p_domain = "domain";
    private static final String p_domains = "domains";
    private static final String[] commandStrings = new String[]{DeploymentCommand.DEPLOY.toString(), DeploymentCommand.UNDEPLOY.toString()};
    private static final String[] typeStrings = new String[]{DeployableObjectType.APP.toString(), DeployableObjectType.EJB.toString(), DeployableObjectType.WEB.toString(), DeployableObjectType.CONN.toString()};

    public DBETestToolGUI() {
        this.setTitle("S1AS Standalone Deployment Tool");
        this.setSize(600, 200);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.initGridBag();
        this.initComponents();
        this.addComponents();
        this.diskToDialog();
    }

    public void junk() {
        JButton b = new JButton("...");
        JTextField f = new JTextField();
        f.setColumns(30);
        JPanel jp = new JPanel();
        jp.add(f);
        jp.add(b);
        this.add(jp, 0, 6, 1, 1);
    }

    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.submit) {
            this.dialogToDisk();
            this.deploy();
        } else if (source == this.cancel) {
            this.dispose();
        }
    }

    private void deploy() {
        try {
            DBETestTool dtt = new DBETestTool();
            dtt.setInstallRoot(this.installRoot.getText());
            dtt.setFileSource(this.fileSource.getText());
            dtt.setType(DeployableObjectType.valueOf((String)this.type.getSelectedItem()));
            dtt.setCommand(DeploymentCommand.valueOf((String)this.command.getSelectedItem()));
            dtt.setDomainsName(this.domains.getText());
            dtt.setDomainName(this.domain.getText());
            dtt.setInstance(this.instance.getText());
            dtt.setForced(this.forced.isSelected());
            dtt.setNoEJBC(this.noEJBC.isSelected());
            dtt.setPrecompileJSP(this.jspc.isSelected());
            String cr = this.contextRoot.getText();
            String nam = this.name.getText();
            if (StringUtils.ok((String)cr)) {
                dtt.setContextRoot(cr);
            }
            if (StringUtils.ok((String)nam)) {
                dtt.setName(nam);
            }
            System.out.println(dtt.toString());
            dtt.doRequest();
        }
        catch (IASDeploymentException de) {
            de.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.command = new JComboBox<String>(commandStrings);
        this.command.setSelectedIndex(0);
        this.type = new JComboBox<String>(typeStrings);
        this.type.setSelectedIndex(0);
        this.fileSource = new JTextField();
        this.name = new JTextField();
        this.contextRoot = new JTextField();
        this.instance = new JTextField("server");
        this.installRoot = new JTextField();
        this.domain = new JTextField("domain1");
        this.domains = new JTextField(p_domains);
        this.forced = new JCheckBox("Forced");
        this.noEJBC = new JCheckBox("Turn-off EJBC");
        this.jspc = new JCheckBox("JSP Precompile");
        this.submit = new JButton("Submit");
        this.cancel = new JButton("Cancel");
        this.submit.addActionListener(this);
        this.cancel.addActionListener(this);
    }

    private void initGridBag() {
        this.contentPane = this.getContentPane();
        this.gb = new GridBagLayout();
        this.contentPane.setLayout(this.gb);
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 0;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.anchor = 10;
    }

    private void addComponents() {
        this.gbc.anchor = 10;
        this.gbc.fill = 0;
        this.add(this.command, "Command:", 1, 0, 1, 1);
        this.add(this.type, "Type: ", 3, 0, 1, 1);
        this.gbc.fill = 2;
        this.add(this.fileSource, "File Source:", 1, 1, 1, 1);
        this.add(this.name, "Name: ", 3, 1, 1, 1);
        this.add(this.contextRoot, "Context Root: ", 1, 2, 1, 1);
        this.add(this.instance, "Instance Name: ", 3, 2, 1, 1);
        this.add(this.domains, "Domains Name: ", 1, 3, 1, 1);
        this.add(this.domain, "Domain Name: ", 3, 3, 1, 1);
        this.add(this.installRoot, "Installation Directory: ", 1, 4, 1, 1);
        this.gbc.anchor = 10;
        this.gbc.fill = 0;
        this.add(this.forced, 2, 4, 1, 1);
        this.add(this.noEJBC, 3, 4, 1, 1);
        this.add(this.jspc, 0, 5, 1, 1);
        this.add(this.submit, 1, 5, 2, 1);
        this.add(this.cancel, 2, 5, 2, 1);
    }

    private void diskToDialog() {
        this.diskToJComboBox(p_command, commandStrings, this.command);
        this.diskToJComboBox(p_type, typeStrings, this.type);
        this.diskToJTextField(p_fileSource, this.fileSource);
        this.diskToJTextField(p_name, this.name);
        this.diskToJTextField(p_contextRoot, this.contextRoot);
        this.diskToJTextField(p_instance, this.instance);
        this.diskToJTextField(p_installRoot, this.installRoot);
        this.diskToJTextField(p_domain, this.domain);
        this.diskToJTextField(p_domains, this.domains);
        this.diskToJCheckBox(p_noEJBC, this.noEJBC);
        this.diskToJCheckBox(p_jspc, this.jspc);
        this.diskToJCheckBox(p_forced, this.forced);
    }

    private void diskToJComboBox(String key, String[] vals, JComboBox cb) {
        String s = this.persist.getProperty(key);
        for (int i = 0; s != null && i < vals.length; ++i) {
            if (!s.equals(vals[i])) continue;
            cb.setSelectedIndex(i);
            break;
        }
    }

    private void diskToJTextField(String key, JTextField f) {
        String s = this.persist.getProperty(key);
        if (s != null) {
            f.setText(s);
        }
    }

    private void diskToJCheckBox(String key, JCheckBox cb) {
        String s = this.persist.getProperty(key);
        if (s != null && s.equals("true")) {
            cb.setSelected(true);
        }
    }

    private void dialogToDisk() {
        this.JTextFieldToDisk(p_fileSource, this.fileSource);
        this.JTextFieldToDisk(p_name, this.name);
        this.JTextFieldToDisk(p_contextRoot, this.contextRoot);
        this.JTextFieldToDisk(p_instance, this.instance);
        this.JTextFieldToDisk(p_installRoot, this.installRoot);
        this.JTextFieldToDisk(p_domain, this.domain);
        this.JTextFieldToDisk(p_domains, this.domains);
        this.persist.setProperty(p_type, this.type.getSelectedItem().toString());
        this.persist.setProperty(p_command, this.type.getSelectedItem().toString());
        this.persist.setProperty(p_noEJBC, "" + this.noEJBC.isSelected());
        this.persist.setProperty(p_jspc, "" + this.jspc.isSelected());
        this.persist.setProperty(p_forced, "" + this.forced.isSelected());
        this.persist.store();
    }

    private void JTextFieldToDisk(String key, JTextField f) {
        String s = f.getText();
        if (!StringUtils.ok((String)s)) {
            return;
        }
        this.persist.setProperty(key, s);
    }

    private void add(Component c, int x, int y, int w, int h) {
        this.gbc.gridx = x;
        this.gbc.gridy = y;
        this.gbc.gridwidth = w;
        this.gbc.gridheight = h;
        this.getContentPane().add(c, this.gbc);
    }

    private void add(Component c, String label, int x, int y, int w, int h) {
        int originalAnchor = this.gbc.anchor;
        int originalFill = this.gbc.fill;
        this.gbc.anchor = 13;
        this.gbc.fill = 0;
        this.add(new JLabel(label), x - 1, y, w, h);
        this.gbc.anchor = originalAnchor;
        this.gbc.fill = originalFill;
        this.add(c, x, y, w, h);
    }

    public static void main(String[] args) {
        DBETestToolGUI gui = new DBETestToolGUI();
        gui.show();
    }
}

