/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartPhase
extends DeploymentPhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(StartPhase.class);

    public StartPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "Start";
    }

    public void runPhase(DeploymentPhaseContext phaseCtx) {
        boolean success;
        String type = null;
        DeploymentRequest req = phaseCtx.getDeploymentRequest();
        DeploymentStatus status = phaseCtx.getDeploymentStatus();
        DeploymentTarget target = (DeploymentTarget)req.getTarget();
        if (target == null) {
            String msg = localStrings.getString("enterprise.deployment.phasing.start.targetnotspecified");
            sLogger.log(Level.FINEST, msg);
            status.setStageStatus(2);
            return;
        }
        this.prePhaseNotify(this.getPrePhaseEvent(req));
        int actionCode = req.getActionCode();
        type = req.isApplication() ? null : DeploymentServiceUtils.getModuleTypeString(req.getType());
        try {
            success = target.sendStartEvent(actionCode, req.getName(), type, req.isForced());
        }
        catch (DeploymentTargetException dte) {
            status.setStageStatus(0);
            if (dte.getCause() != null) {
                status.setStageException(dte.getCause());
                status.setStageStatusMessage(dte.getMessage());
            }
            return;
        }
        if (success) {
            status.setStageStatus(2);
        } else {
            status.setStageStatus(0);
            status.setStageStatusMessage("Application failed to load");
        }
        this.postPhaseNotify(this.getPostPhaseEvent(req));
    }

    private DeploymentEvent getPrePhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(5, new DeploymentEventInfo(req));
    }

    private DeploymentEvent getPostPhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(6, new DeploymentEventInfo(req));
    }
}

