/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.exception.DeploymentException;
import com.sun.enterprise.admin.common.exception.ServerInstanceException;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.DeploymentNotificationHelper;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.HostAndPort;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deployment.backend.ClientJarMakerRegistry;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentRequestRegistry;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DeploymentServiceUtils {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(DeploymentServiceUtils.class);
    private static final Object[] emptyParams = new Object[0];
    private static final String[] emptySignature = new String[0];
    private static final String CREATE_J2EE_APPLICATION = "createJ2eeApplication";
    private static final String CREATE_EJB_MODULE = "createEjbModule";
    private static final String CREATE_WEB_MODULE = "createWebModule";
    private static final String CREATE_CONNECTOR_MODULE = "createConnectorModule";
    private static final String CREATE_APPCLIENT_MODULE = "createAppclientModule";
    private static final String GET_J2EE_APPLICATION = "getJ2eeApplicationByName";
    private static final String GET_EJB_MODULE = "getEjbModuleByName";
    private static final String GET_WEB_MODULE = "getWebModuleByName";
    private static final String GET_CONNECTOR_MODULE = "getConnectorModuleByName";
    private static final String GET_APPCLIENT_MODULE = "getAppclientModuleByName";
    private static final String REMOVE_J2EE_APPLICATION = "removeJ2eeApplicationByName";
    private static final String REMOVE_EJB_MODULE = "removeEjbModuleByName";
    private static final String REMOVE_WEB_MODULE = "removeWebModuleByName";
    private static final String REMOVE_CONNECTOR_MODULE = "removeConnectorModuleByName";
    private static final String REMOVE_APPCLIENT_MODULE = "removeAppclientModuleByName";
    private static final String appsConfigMBeanName = "com.sun.appserv:type=applications,category=config";
    private static final String SYSTEM_PREFIX = "system-";
    private static final String ADMIN_VS = "__asadmin";
    private static final String PORT = "port";
    private static final String DEF_VS = "default-virtual-server";
    private static final String SERVER_NAME = "server-name";
    private static final String REDIRECT_PORT = "redirect-port";
    private static final String SEC_ENABLED = "security-enabled";
    private static final String LISTENER_ENABLED = "enabled";
    private static final String OBJECT_TYPE = "object-type";
    private static final String HOSTS = "hosts";
    private static final String HTTP_LISTENERS = "http_listeners";
    private static final String DEFAULT_WEB_MODULE = "default_web_module";
    private static final String STATE = "state";
    private static final String ID = "id";
    private static final DeployableObjectType[] deployableObjectTypes = new DeployableObjectType[]{DeployableObjectType.APP, DeployableObjectType.EJB, DeployableObjectType.WEB, DeployableObjectType.CONN, DeployableObjectType.CAR};
    private static String[] httpListenerAttrNames = new String[]{"enabled", "default-virtual-server", "server-name", "redirect-port", "port", "security-enabled", "id"};
    private static String[] vsAttrNames = new String[]{"hosts", "http_listeners", "default_web_module", "state", "id"};

    public static String getClientJarPath(String moduleID) {
        ClientJarMakerRegistry registry = ClientJarMakerRegistry.getInstance();
        if (registry.isRegistered(moduleID)) {
            registry.waitForCompletion(moduleID);
        }
        return moduleID + "Client.jar";
    }

    static boolean multicastEvent(int eventType, String entityName, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, null, targetName);
    }

    static boolean multicastEvent(int eventType, String entityName, String moduleType, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, moduleType, false, targetName);
    }

    static boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, moduleType, cascade, false, targetName);
    }

    static boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade, boolean forceDeploy, String targetName) throws IASDeploymentException {
        try {
            ConfigContext config = DeploymentServiceUtils.getConfigContext();
            if (config != null && config.isChanged()) {
                config.flush();
            }
        }
        catch (ConfigException ce) {
            throw new IASDeploymentException(ce);
        }
        try {
            return DeploymentNotificationHelper.multicastEvent(eventType, entityName, moduleType, cascade, forceDeploy, targetName);
        }
        catch (Throwable t) {
            throw new IASDeploymentException(t);
        }
    }

    public static String getModuleTypeString(DeployableObjectType moduleType) {
        String moduleTypeString = null;
        if (moduleType.equals(DeployableObjectType.EJB)) {
            moduleTypeString = "ejb";
        } else if (moduleType.equals(DeployableObjectType.WEB)) {
            moduleTypeString = "web";
        } else if (moduleType.equals(DeployableObjectType.CONN)) {
            moduleTypeString = "connector";
        } else if (moduleType.equals(DeployableObjectType.CAR)) {
            moduleTypeString = "appclient";
        }
        return moduleTypeString;
    }

    public static String getLocation(File appDir) {
        if (appDir != null) {
            return RelativePathResolver.unresolvePath(appDir.getAbsolutePath(), new String[]{"com.sun.aas.instanceRoot", "com.sun.aas.installRoot"});
        }
        return null;
    }

    public static String getLocation(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appId}, new String[]{"java.lang.String"});
            String location = (String)mbs.getAttribute(componentON, ServerTags.LOCATION);
            return new RelativePathResolver().resolve(location);
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isEnabled(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appId}, new String[]{"java.lang.String"});
            String enabled = (String)mbs.getAttribute(componentON, ServerTags.ENABLED);
            return Boolean.valueOf(enabled);
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isDirectoryDeployed(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appId}, new String[]{"java.lang.String"});
            String directoryDeployed = (String)mbs.getAttribute(componentON, ServerTags.DIRECTORY_DEPLOYED);
            return Boolean.valueOf(directoryDeployed);
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static String getObjectType(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            if (type.isCAR()) {
                return null;
            }
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appId}, new String[]{"java.lang.String"});
            String objectType = (String)mbs.getAttribute(componentON, ServerTags.OBJECT_TYPE);
            return objectType;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static void setContextRoot(String appId, DeployableObjectType type, String contextRoot) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appId}, new String[]{"java.lang.String"});
            if (contextRoot != null && contextRoot.length() > 0) {
                Attribute contextRootAttr = new Attribute(ServerTags.CONTEXT_ROOT, contextRoot);
                mbs.setAttribute(componentON, contextRootAttr);
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isSystem(String appId, DeployableObjectType type) throws IASDeploymentException {
        String objectType = DeploymentServiceUtils.getObjectType(appId, type);
        if (objectType != null) {
            return objectType.startsWith(SYSTEM_PREFIX);
        }
        return false;
    }

    public static void addToConfig(DeploymentRequest request) throws IASDeploymentException {
        try {
            Properties optionalAttributes;
            String dirDeployed;
            String availEnabled;
            String contextRoot;
            String enabled;
            String description;
            String location;
            String name = request.getName();
            DeployableObjectType type = request.getType();
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            String createOperationName = DeploymentServiceUtils.getCreateOperationName(type);
            AttributeList attrList = new AttributeList();
            if (name != null && name.length() > 0) {
                Attribute nameAttr = new Attribute(ServerTags.NAME, name);
                attrList.add(nameAttr);
            }
            if ((location = DeploymentServiceUtils.getLocation(request.getDeployedDirectory())) != null && location.length() > 0) {
                Attribute locationAttr = new Attribute(ServerTags.LOCATION, location);
                attrList.add(locationAttr);
            }
            if ((description = request.getDescription()) != null && description.length() > 0) {
                Attribute descriptionAttr = new Attribute(ServerTags.DESCRIPTION, description);
                attrList.add(descriptionAttr);
            }
            if (!request.getType().isCAR() && (enabled = String.valueOf(request.isStartOnDeploy())) != null && enabled.length() > 0) {
                Attribute enableAttr = new Attribute(ServerTags.ENABLED, enabled);
                attrList.add(enableAttr);
            }
            if (request.getType().isWEB() && (contextRoot = request.getContextRoot()) != null && contextRoot.length() > 0) {
                Attribute contextRootAttr = new Attribute(ServerTags.CONTEXT_ROOT, contextRoot);
                attrList.add(contextRootAttr);
            }
            if (!request.getType().isCAR() && !request.getType().isCONN() && (availEnabled = String.valueOf(request.isAvailabilityEnabled())) != null && availEnabled.length() > 0) {
                Attribute availEnabledAttr = new Attribute(ServerTags.AVAILABILITY_ENABLED, availEnabled);
                attrList.add(availEnabledAttr);
            }
            if ((dirDeployed = String.valueOf(request.isDirectoryDeployed())) != null && dirDeployed.length() > 0) {
                Attribute dirDeployedAttr = new Attribute(ServerTags.DIRECTORY_DEPLOYED, dirDeployed);
                attrList.add(dirDeployedAttr);
            }
            if ((optionalAttributes = request.getOptionalAttributes()) != null) {
                Properties mProps = (Properties)optionalAttributes.clone();
                try {
                    mProps.remove(ServerTags.VIRTUAL_SERVERS);
                }
                catch (Exception re) {
                    // empty catch block
                }
                Enumeration<Object> tags = mProps.keys();
                while (tags.hasMoreElements()) {
                    String tag = (String)tags.nextElement();
                    String value = mProps.getProperty(tag);
                    if (!(tag != null & tag.length() > 0) || value == null || value.length() <= 0) continue;
                    Attribute optionalAttr = new Attribute(tag, value);
                    attrList.add(optionalAttr);
                }
            }
            String[] signature = new String[]{AttributeList.class.getName()};
            Object[] params = new Object[]{attrList};
            mbs.invoke(appsConfigMBean, createOperationName, params, signature);
            DeploymentServiceUtils.getConfigContext().flush();
            DeploymentServiceUtils.getConfigContext().resetConfigChangeList();
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static void removeFromConfig(String name, DeployableObjectType type) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{name}, new String[]{"java.lang.String"});
            if (componentON != null) {
                String removeOperationName = DeploymentServiceUtils.getRemoveOperationName(type);
                mbs.invoke(appsConfigMBean, removeOperationName, new Object[]{name}, new String[]{"java.lang.String"});
                DeploymentServiceUtils.getConfigContext().flush();
                DeploymentServiceUtils.getConfigContext().resetConfigChangeList();
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isRegistered(String appName, DeployableObjectType type) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = null;
            try {
                componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appName}, new String[]{"java.lang.String"});
            }
            catch (Exception cn) {
                // empty catch block
            }
            return componentON != null;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static ConfigContext getConfigContext() {
        try {
            AdminService adminService = AdminService.getAdminService();
            if (adminService != null) {
                ConfigContext config = adminService.getAdminContext().getAdminConfigContext();
                return config;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getInstanceName() {
        return ApplicationServer.getServerContext().getInstanceName();
    }

    public static String getDomainName() throws IASDeploymentException {
        try {
            AdminService adminService = AdminService.getAdminService();
            if (adminService != null) {
                String domainName = adminService.getAdminContext().getDomainName();
                return domainName;
            }
            return null;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static void validate(String appID, DeployableObjectType type, String action) throws IASDeploymentException {
        boolean allowSystemAppModification = Boolean.valueOf(System.getProperty("com.sun.aas.deployment.AllowSysAppDeployment", "false"));
        if (allowSystemAppModification) {
            return;
        }
        if (DeploymentServiceUtils.isSystem(appID, type)) {
            String msg = localStrings.getString("enterprise.deployment.phasing.component_is_system", new Object[]{action});
            throw new IASDeploymentException(msg);
        }
    }

    public static void checkWebModuleReferences(String webModuleName) throws IASDeploymentException {
        ArrayList<String> virtualServerIds = new ArrayList<String>();
        try {
            Config config = (Config)ConfigBeansFactory.getConfigBeanByXPath(DeploymentServiceUtils.getConfigContext(), ServerXPathHelper.XPATH_CONFIG);
            HttpService httpService = config.getHttpService();
            VirtualServer[] virtualServers = httpService.getVirtualServer();
            for (int j = 0; j < virtualServers.length; ++j) {
                VirtualServer aServer = virtualServers[j];
                String defWebModule = aServer.getDefaultWebModule();
                if (defWebModule == null || !defWebModule.equals(webModuleName)) continue;
                virtualServerIds.add(aServer.getId());
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
        if (!virtualServerIds.isEmpty()) {
            throw new IASDeploymentException(localStrings.getString("enterprise.deployment.phasing.def_web_module_refs_exist", virtualServerIds.toString(), webModuleName));
        }
    }

    public static void checkAbort(String moduleID) throws IASDeploymentException {
        DeploymentRequest request = DeploymentRequestRegistry.getRegistry().getDeploymentRequest(moduleID);
        if (request != null && request.isAborted()) {
            DeploymentRequestRegistry.getRegistry().removeDeploymentRequest(moduleID);
            String msg = localStrings.getString("enterprise.deployment.phasing.operation.abort", new Object[]{moduleID});
            throw new IASDeploymentException(msg);
        }
    }

    public static DeployableObjectType getTypeFromFile(String filePath) throws DeploymentException {
        if (filePath == null) {
            throw new DeploymentException("deploy file not specified");
        }
        try {
            return DeployableObjectType.valueOf(new File(filePath));
        }
        catch (IASDeploymentException ex) {
            throw new DeploymentException("Unknown deployable object type specified: " + ex.getMessage());
        }
    }

    public static DeploymentTarget getAndValidateDeploymentTarget(String targetName, String appName, boolean isDeleting) throws IASDeploymentException {
        try {
            DeploymentTarget target = DeploymentTargetFactory.getDeploymentTargetFactory().getTarget(DeploymentServiceUtils.getConfigContext(), DeploymentServiceUtils.getDomainName(), targetName);
            if (targetName == null) {
                targetName = target.getTarget().getName();
            }
            if (target.getTarget().getType() == TargetType.SERVER || target.getTarget().getType() == TargetType.DAS) {
                if (isDeleting) {
                    if (!ServerHelper.serverReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                        throw new IASDeploymentException(localStrings.getString("serverApplicationRefDoesNotExist", targetName, appName));
                    }
                } else if (ServerHelper.serverReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                    throw new IASDeploymentException(localStrings.getString("serverApplicationRefAlreadyExists", appName, targetName));
                }
            } else if (target.getTarget().getType() == TargetType.CLUSTER) {
                if (isDeleting) {
                    if (!ClusterHelper.clusterReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                        throw new IASDeploymentException(localStrings.getString("clusterApplicationRefDoesNotExist", targetName, appName));
                    }
                } else if (ClusterHelper.clusterReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                    throw new IASDeploymentException(localStrings.getString("clusterApplicationRefAlreadyExists", appName, targetName));
                }
            }
            return target;
        }
        catch (IASDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IASDeploymentException(ex);
        }
    }

    public static void setHostAndPort(DeploymentRequest req) throws ServerInstanceException {
        String virtualServers = (String)req.getOptionalAttributes().get(ServerTags.VIRTUAL_SERVERS);
        if (virtualServers == null) {
            HostAndPort hap = DeploymentServiceUtils.getHostAndPort(false);
            if (hap != null) {
                req.setHttpHostName(DeploymentServiceUtils.getHostName(hap));
                req.setHttpPort(DeploymentServiceUtils.getPort(hap, false));
            }
            if ((hap = DeploymentServiceUtils.getHostAndPort(true)) != null) {
                req.setHttpsHostName(DeploymentServiceUtils.getHostName(hap));
                req.setHttpsPort(DeploymentServiceUtils.getPort(hap, true));
            }
        } else {
            StringTokenizer st = new StringTokenizer(virtualServers, ",");
            if (st.hasMoreTokens()) {
                String aVirtualServer = st.nextToken();
                HostAndPort hap = DeploymentServiceUtils.getVirtualServerHostAndPort(aVirtualServer, false);
                if (hap != null) {
                    req.setHttpHostName(DeploymentServiceUtils.getHostName(hap));
                    req.setHttpPort(DeploymentServiceUtils.getPort(hap, false));
                }
                if ((hap = DeploymentServiceUtils.getVirtualServerHostAndPort(aVirtualServer, true)) != null) {
                    req.setHttpsHostName(DeploymentServiceUtils.getHostName(hap));
                    req.setHttpsPort(DeploymentServiceUtils.getPort(hap, true));
                }
            }
        }
    }

    private static String getHostName(HostAndPort hap) {
        String hostName = hap.getHost();
        if (hostName == null || hostName.trim().equals("")) {
            hostName = DeploymentServiceUtils.getDefaultHostName();
        }
        return hostName;
    }

    private static String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            sLogger.log(Level.FINEST, "mbean.get_local_host_error", uhe);
            sLogger.log(Level.INFO, "mbean.use_default_host");
        }
        return defaultHostName;
    }

    private static int getPort(HostAndPort hap, boolean securityEnabled) {
        int port = hap.getPort();
        if (port == 0) {
            port = DeploymentServiceUtils.getDefaultPort(securityEnabled);
        }
        return port;
    }

    private static int getDefaultPort(boolean securityEnabled) {
        int port = 0;
        port = securityEnabled ? 8181 : 8080;
        sLogger.log(Level.INFO, "mbean.use_default_port", String.valueOf(port));
        return port;
    }

    private static Object getNamedAttributeValue(AttributeList attrs, String attrName) {
        if (attrs == null || attrName == null) {
            return null;
        }
        Object value = null;
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            if (!attrName.equals(attr.getName())) continue;
            value = attr.getValue();
            break;
        }
        return value;
    }

    private static HostAndPort getHostAndPort(boolean securityEnabled) throws ServerInstanceException {
        HostAndPort hAndp = null;
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName objectName = new ObjectName(DeploymentServiceUtils.getDomainName() + ":type=configs,category=config");
            String operationName1 = "getConfig";
            ObjectName[] configs = (ObjectName[])mbs.invoke(objectName, operationName1, emptyParams, emptySignature);
            String configName = (String)mbs.getAttribute(configs[0], "name");
            ObjectName httpService = new ObjectName(DeploymentServiceUtils.getDomainName() + ":type=http-service,config=" + configName + ",category=config");
            String operationName2 = "getHttpListener";
            ObjectName[] httpListener = (ObjectName[])mbs.invoke(httpService, operationName2, emptyParams, emptySignature);
            String serverName = null;
            int port = 0;
            for (int i = 0; i < httpListener.length; ++i) {
                boolean sec_on;
                String vs;
                boolean enabled;
                AttributeList attrs = mbs.getAttributes(httpListener[i], httpListenerAttrNames);
                Boolean bb = Boolean.valueOf((String)DeploymentServiceUtils.getNamedAttributeValue(attrs, LISTENER_ENABLED));
                boolean bl = enabled = bb == null ? false : bb;
                if (!enabled || ADMIN_VS.equals(vs = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, DEF_VS))) continue;
                bb = Boolean.valueOf((String)DeploymentServiceUtils.getNamedAttributeValue(attrs, SEC_ENABLED));
                boolean bl2 = sec_on = bb == null ? false : bb;
                if (securityEnabled != sec_on) continue;
                serverName = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, SERVER_NAME);
                if (serverName == null || serverName.trim().equals("")) {
                    serverName = DeploymentServiceUtils.getDefaultHostName();
                }
                String portStr = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, PORT);
                String redirPort = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, REDIRECT_PORT);
                if (redirPort != null && !redirPort.trim().equals("")) {
                    portStr = redirPort;
                }
                String resolvedPort = new PropertyResolver(DeploymentServiceUtils.getConfigContext(), DeploymentServiceUtils.getInstanceName()).resolve(portStr);
                port = Integer.parseInt(resolvedPort);
                break;
            }
            hAndp = new HostAndPort(serverName, port);
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return hAndp;
    }

    private static HostAndPort getVirtualServerHostAndPort(String vs, boolean securityEnabled) throws ServerInstanceException {
        String serverName = null;
        int port = 0;
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName objectName = new ObjectName(DeploymentServiceUtils.getDomainName() + ":type=configs,category=config");
            String operationName1 = "getConfig";
            ObjectName[] configs = (ObjectName[])mbs.invoke(objectName, operationName1, emptyParams, emptySignature);
            String configName = (String)mbs.getAttribute(configs[0], "name");
            ObjectName httpService = new ObjectName(DeploymentServiceUtils.getDomainName() + ":type=http-service,config=" + configName + ",category=config");
            String operationName2 = "getHttpListener";
            ObjectName[] httpListener = (ObjectName[])mbs.invoke(httpService, operationName2, emptyParams, emptySignature);
            operationName2 = "getVirtualServer";
            ObjectName[] virtualServer = (ObjectName[])mbs.invoke(httpService, operationName2, emptyParams, emptySignature);
            for (int i = 0; i < virtualServer.length; ++i) {
                AttributeList vsAttrs = mbs.getAttributes(virtualServer[i], vsAttrNames);
                String id = (String)DeploymentServiceUtils.getNamedAttributeValue(vsAttrs, ID);
                if (!id.equals(vs)) continue;
                String httpListeners = (String)DeploymentServiceUtils.getNamedAttributeValue(vsAttrs, "http-listeners");
                String vsHttpListener = null;
                List httpListenerList = StringUtils.parseStringList((String)httpListeners, (String)" ,");
                ListIterator hlListIter = httpListenerList.listIterator();
                while (hlListIter.hasNext()) {
                    vsHttpListener = (String)hlListIter.next();
                    for (int j = 0; j < httpListener.length; ++j) {
                        boolean sec_on;
                        boolean enabled;
                        AttributeList attrs = mbs.getAttributes(httpListener[j], httpListenerAttrNames);
                        String listenerId = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, ID);
                        if (!listenerId.equals(vsHttpListener)) continue;
                        Boolean bb = Boolean.valueOf((String)DeploymentServiceUtils.getNamedAttributeValue(attrs, LISTENER_ENABLED));
                        boolean bl = enabled = bb == null ? false : bb;
                        if (!enabled) continue;
                        bb = Boolean.valueOf((String)DeploymentServiceUtils.getNamedAttributeValue(attrs, SEC_ENABLED));
                        boolean bl2 = sec_on = bb == null ? false : bb;
                        if (securityEnabled != sec_on) continue;
                        serverName = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, SERVER_NAME);
                        if (serverName == null || serverName.trim().equals("")) {
                            serverName = DeploymentServiceUtils.getDefaultHostName();
                        }
                        String portStr = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, PORT);
                        String redirPort = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, REDIRECT_PORT);
                        if (redirPort != null && !redirPort.trim().equals("")) {
                            portStr = redirPort;
                        }
                        String resolvedPort = new PropertyResolver(DeploymentServiceUtils.getConfigContext(), DeploymentServiceUtils.getInstanceName()).resolve(portStr);
                        port = Integer.parseInt(resolvedPort);
                        return new HostAndPort(serverName, port);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return null;
    }

    public static DeploymentTarget getDeploymentTarget(String targetName) throws IASDeploymentException {
        try {
            DeploymentTarget target = DeploymentTargetFactory.getDeploymentTargetFactory().getTarget(DeploymentServiceUtils.getConfigContext(), DeploymentServiceUtils.getDomainName(), targetName);
            return target;
        }
        catch (IASDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IASDeploymentException(ex);
        }
    }

    public static void checkAppReferencesBeforeUndeployFromDomain(String appName) throws IASDeploymentException {
        try {
            if (ApplicationHelper.isApplicationReferenced(DeploymentServiceUtils.getConfigContext(), appName)) {
                throw new IASDeploymentException(localStrings.getString("applicationIsReferenced", appName, ApplicationHelper.getApplicationReferenceesAsString(DeploymentServiceUtils.getConfigContext(), appName)));
            }
        }
        catch (IASDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IASDeploymentException(ex);
        }
    }

    public static DeployableObjectType getRegisteredType(String name) throws DeploymentException {
        try {
            for (int i = 0; i < deployableObjectTypes.length; ++i) {
                if (!DeploymentServiceUtils.isRegistered(name, deployableObjectTypes[i])) continue;
                return deployableObjectTypes[i];
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage());
        }
        throw new DeploymentException("Component not registered");
    }

    static String getCreateOperationName(DeployableObjectType type) throws IASDeploymentException {
        if (type.isAPP()) {
            return CREATE_J2EE_APPLICATION;
        }
        if (type.isEJB()) {
            return CREATE_EJB_MODULE;
        }
        if (type.isWEB()) {
            return CREATE_WEB_MODULE;
        }
        if (type.isCONN()) {
            return CREATE_CONNECTOR_MODULE;
        }
        if (type.isCAR()) {
            return CREATE_APPCLIENT_MODULE;
        }
        return null;
    }

    static String getGetOperationName(DeployableObjectType type) throws IASDeploymentException {
        if (type.isAPP()) {
            return GET_J2EE_APPLICATION;
        }
        if (type.isEJB()) {
            return GET_EJB_MODULE;
        }
        if (type.isWEB()) {
            return GET_WEB_MODULE;
        }
        if (type.isCONN()) {
            return GET_CONNECTOR_MODULE;
        }
        if (type.isCAR()) {
            return GET_APPCLIENT_MODULE;
        }
        return null;
    }

    static String getRemoveOperationName(DeployableObjectType type) throws IASDeploymentException {
        if (type.isAPP()) {
            return REMOVE_J2EE_APPLICATION;
        }
        if (type.isEJB()) {
            return REMOVE_EJB_MODULE;
        }
        if (type.isWEB()) {
            return REMOVE_WEB_MODULE;
        }
        if (type.isCONN()) {
            return REMOVE_CONNECTOR_MODULE;
        }
        if (type.isCAR()) {
            return REMOVE_APPCLIENT_MODULE;
        }
        return null;
    }
}

