/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.WebServiceEndpointRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.web.WebBundleRuntimeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServletNode
extends DeploymentDescriptorNode {
    private WebComponentDescriptor descriptor;

    public ServletNode() {
        this.registerElementHandler(new XMLElement("webservice-endpoint"), WebServiceEndpointRuntimeNode.class);
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("servlet-name".equals(element.getQName())) {
            WebBundleDescriptor parentDesc = ((WebBundleRuntimeNode)this.getParentNode()).getWebBundleDescriptor();
            if (parentDesc instanceof WebBundleDescriptor) {
                this.descriptor = parentDesc.getWebComponentByCanonicalName(value);
            }
        } else if ("principal-name".equals(element.getQName())) {
            if (this.descriptor != null && this.descriptor.getRunAsIdentity() != null) {
                this.descriptor.getRunAsIdentity().setPrincipal(value);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebComponentDescriptor descriptor) {
        WebServicesDescriptor webServices = descriptor.getWebBundleDescriptor().getWebServices();
        if (descriptor.getRunAsIdentity() != null || webServices.hasEndpointsImplementedBy(descriptor)) {
            Element servletNode = ServletNode.appendChild(parent, nodeName);
            ServletNode.appendTextChild((Node)servletNode, "servlet-name", descriptor.getCanonicalName());
            if (descriptor.getRunAsIdentity() != null) {
                Element principalNode = ServletNode.appendChild(servletNode, "principal");
                ServletNode.appendTextChild((Node)principalNode, "name", descriptor.getRunAsIdentity().getPrincipal());
            }
            WebServiceEndpointRuntimeNode wsRuntime = new WebServiceEndpointRuntimeNode();
            wsRuntime.writeWebServiceEndpointInfo((Node)servletNode, descriptor);
            return servletNode;
        }
        return null;
    }
}

