/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.NameValuePairNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.common.MessageSecurityBindingNode;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceRefPortInfoRuntimeNode
extends DeploymentDescriptorNode {
    private String namespaceUri;

    public ServiceRefPortInfoRuntimeNode() {
        this.registerElementHandler(new XMLElement("stub-property"), NameValuePairNode.class, "addStubProperty");
        this.registerElementHandler(new XMLElement("call-property"), NameValuePairNode.class, "addCallProperty");
        this.registerElementHandler(new XMLElement("message-security-binding"), MessageSecurityBindingNode.class, "setMessageSecurityBinding");
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("service-endpoint-interface", "setServiceEndpointInterface");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        String name = element.getQName();
        if ("namespaceURI".equals(name)) {
            this.namespaceUri = value;
        } else if ("localpart".equals(name)) {
            ServiceRefPortInfo desc = (ServiceRefPortInfo)this.getDescriptor();
            QName wsdlPort = new QName(this.namespaceUri, value);
            desc.setWsdlPort(wsdlPort);
            this.namespaceUri = null;
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, ServiceRefPortInfo desc) {
        NameValuePairDescriptor next;
        Node serviceRefPortInfoRuntimeNode = super.writeDescriptor(parent, nodeName, desc);
        ServiceRefPortInfoRuntimeNode.appendTextChild(serviceRefPortInfoRuntimeNode, "service-endpoint-interface", desc.getServiceEndpointInterface());
        QName port = desc.getWsdlPort();
        if (port != null) {
            Element wsdlPortNode = ServiceRefPortInfoRuntimeNode.appendChild(serviceRefPortInfoRuntimeNode, "wsdl-port");
            ServiceRefPortInfoRuntimeNode.appendTextChild((Node)wsdlPortNode, "namespaceURI", port.getNamespaceURI());
            ServiceRefPortInfoRuntimeNode.appendTextChild((Node)wsdlPortNode, "localpart", port.getLocalPart());
        }
        NameValuePairNode nameValueNode = new NameValuePairNode();
        Set stubProperties = desc.getStubProperties();
        Iterator iter = stubProperties.iterator();
        while (iter.hasNext()) {
            next = (NameValuePairDescriptor)iter.next();
            nameValueNode.writeDescriptor(serviceRefPortInfoRuntimeNode, "stub-property", next);
        }
        iter = desc.getCallProperties().iterator();
        while (iter.hasNext()) {
            next = (NameValuePairDescriptor)iter.next();
            nameValueNode.writeDescriptor(serviceRefPortInfoRuntimeNode, "call-property", next);
        }
        MessageSecurityBindingDescriptor messageSecBindingDesc = desc.getMessageSecurityBinding();
        if (messageSecBindingDesc != null) {
            MessageSecurityBindingNode messageSecBindingNode = new MessageSecurityBindingNode();
            messageSecBindingNode.writeDescriptor(serviceRefPortInfoRuntimeNode, "message-security-binding", messageSecBindingDesc);
        }
        return serviceRefPortInfoRuntimeNode;
    }
}

