/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.EjbLocalReferenceNode;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.ServiceReferenceNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.ejb.SecurityIdentityNode;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import org.w3c.dom.Node;

public abstract class EjbNode
extends DisplayableComponentNode {
    public EjbNode() {
        this.registerElementHandler(new XMLElement("env-entry"), EnvEntryNode.class, "addEnvironmentProperty");
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbReferenceNode.class);
        this.registerElementHandler(new XMLElement("ejb-local-ref"), EjbLocalReferenceNode.class);
        this.registerElementHandler(new XMLElement("service-ref"), ServiceReferenceNode.class, "addServiceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class, "addResourceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("security-identity"), SecurityIdentityNode.class);
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class, "addJmsDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class);
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbReference) {
            DOLUtils.getDefaultLogger().fine("Adding ejb ref " + newDescriptor);
            this.getEjbDescriptor().addEjbReferenceDescriptor((EjbReference)newDescriptor);
        } else if (newDescriptor instanceof RunAsIdentityDescriptor) {
            DOLUtils.getDefaultLogger().fine("Adding security-identity" + newDescriptor);
            this.getEjbDescriptor().setUsesCallerIdentity(false);
            this.getEjbDescriptor().setRunAsIdentity((RunAsIdentityDescriptor)newDescriptor);
        } else if (newDescriptor instanceof MessageDestinationReferenceDescriptor) {
            MessageDestinationReferenceDescriptor msgDestRef = (MessageDestinationReferenceDescriptor)newDescriptor;
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)this.getParentNode().getDescriptor();
            msgDestRef.setReferringBundleDescriptor(ejbBundle);
            this.getEjbDescriptor().addMessageDestinationReferenceDescriptor(msgDestRef);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    public Object getDescriptor() {
        return this.getEjbDescriptor();
    }

    public abstract EjbDescriptor getEjbDescriptor();

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-name", "setName");
        table.put("ejb-class", "setEjbClassName");
        return table;
    }

    protected void writeCommonHeaderEjbDescriptor(Node ejbNode, Descriptor descriptor) {
        EjbNode.appendTextChild(ejbNode, "ejb-name", descriptor.getName());
    }

    protected void writeSecurityIdentityDescriptor(Node parent, EjbDescriptor descriptor) {
        if (!descriptor.getUsesCallerIdentity() && descriptor.getRunAsIdentity() == null) {
            return;
        }
        SecurityIdentityNode node = new SecurityIdentityNode();
        node.writeDescriptor(parent, "security-identity", descriptor);
    }
}

