/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.IASEjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.ejb.CmpFieldNode;
import com.sun.enterprise.deployment.node.ejb.InterfaceBasedEjbNode;
import com.sun.enterprise.deployment.node.ejb.QueryNode;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class EjbEntityNode
extends InterfaceBasedEjbNode {
    private EjbEntityDescriptor descriptor;

    public EjbEntityNode() {
        this.registerElementHandler(new XMLElement("cmp-field"), CmpFieldNode.class);
        this.registerElementHandler(new XMLElement("query"), QueryNode.class);
    }

    public EjbDescriptor getEjbDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (EjbEntityDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
            this.descriptor.setEjbBundleDescriptor((EjbBundleDescriptor)this.getParentNode().getDescriptor());
        }
        return this.descriptor;
    }

    private EjbCMPEntityDescriptor getCMPEntityDescriptor() {
        EjbDescriptor current = this.getEjbDescriptor();
        if (!(current instanceof EjbCMPEntityDescriptor)) {
            this.descriptor = new IASEjbCMPEntityDescriptor(current);
        }
        return (EjbCMPEntityDescriptor)this.descriptor;
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof FieldDescriptor) {
            this.getCMPEntityDescriptor().getPersistenceDescriptor().addCMPField((FieldDescriptor)newDescriptor);
        } else if (newDescriptor instanceof QueryDescriptor) {
            QueryDescriptor newQuery = (QueryDescriptor)newDescriptor;
            this.getCMPEntityDescriptor().getPersistenceDescriptor().setQueryFor(newQuery.getQueryMethodDescriptor(), newQuery);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("persistence-type", "setPersistenceType");
        table.put("prim-key-class", "setPrimaryKeyClassName");
        table.put("reentrant", "setReentrant");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("cmp-version".equals(element.getQName())) {
            if ("1.x".equals(value)) {
                this.getCMPEntityDescriptor().setCMPVersion(1);
            } else if ("2.x".equals(value)) {
                this.getCMPEntityDescriptor().setCMPVersion(2);
            }
        } else if ("abstract-schema-name".equals(element.getQName())) {
            this.getCMPEntityDescriptor().setAbstractSchemaName(value);
        } else if ("primkey-field".equals(element.getQName())) {
            this.getCMPEntityDescriptor().setPrimaryKeyFieldDesc(new FieldDescriptor(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {
        Set queriedMethods;
        EjbCMPEntityDescriptor cmpDesc;
        if (!(descriptor instanceof EjbEntityDescriptor)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        EjbEntityDescriptor ejbDesc = (EjbEntityDescriptor)descriptor;
        Node ejbNode = super.writeDescriptor(parent, nodeName, descriptor);
        this.writeDisplayableComponentInfo(ejbNode, descriptor);
        this.writeCommonHeaderEjbDescriptor(ejbNode, ejbDesc);
        EjbEntityNode.appendTextChild(ejbNode, "persistence-type", ejbDesc.getPersistenceType());
        EjbEntityNode.appendTextChild(ejbNode, "prim-key-class", ejbDesc.getPrimaryKeyClassName());
        EjbEntityNode.appendTextChild(ejbNode, "reentrant", ejbDesc.getReentrant());
        if (ejbDesc instanceof EjbCMPEntityDescriptor) {
            cmpDesc = (EjbCMPEntityDescriptor)ejbDesc;
            if (cmpDesc.getCMPVersion() == 1) {
                EjbEntityNode.appendTextChild(ejbNode, "cmp-version", "1.x");
            } else {
                EjbEntityNode.appendTextChild(ejbNode, "cmp-version", "2.x");
            }
            EjbEntityNode.appendTextChild(ejbNode, "abstract-schema-name", cmpDesc.getAbstractSchemaName());
            CmpFieldNode cmpNode = new CmpFieldNode();
            Iterator fields = cmpDesc.getPersistenceDescriptor().getCMPFields().iterator();
            while (fields.hasNext()) {
                FieldDescriptor aField = (FieldDescriptor)fields.next();
                cmpNode.writeDescriptor(ejbNode, "cmp-field", aField);
            }
            if (cmpDesc.getPrimaryKeyFieldDesc() != null) {
                EjbEntityNode.appendTextChild(ejbNode, "primkey-field", cmpDesc.getPrimaryKeyFieldDesc().getName());
            }
        }
        this.writeEnvEntryDescriptors(ejbNode, ejbDesc.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(ejbNode, ejbDesc.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(ejbNode, ejbDesc.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(ejbNode, ejbDesc.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(ejbNode, ejbDesc.getJmsDestinationReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(ejbNode, ejbDesc.getMessageDestinationReferenceDescriptors().iterator());
        this.writeRoleReferenceDescriptors(ejbNode, ejbDesc.getRoleReferences().iterator());
        this.writeSecurityIdentityDescriptor(ejbNode, ejbDesc);
        if (ejbDesc instanceof EjbCMPEntityDescriptor && (queriedMethods = (cmpDesc = (EjbCMPEntityDescriptor)ejbDesc).getPersistenceDescriptor().getQueriedMethods()).size() > 0) {
            QueryNode queryNode = new QueryNode();
            Iterator e = queriedMethods.iterator();
            while (e.hasNext()) {
                queryNode.writeDescriptor(ejbNode, "query", cmpDesc.getPersistenceDescriptor().getQueryFor((MethodDescriptor)e.next()));
            }
        }
        return ejbNode;
    }
}

