/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.connector.LicenseNode;
import com.sun.enterprise.deployment.node.connector.OutBoundRANode;
import com.sun.enterprise.deployment.node.connector.RANode;
import java.util.Map;
import org.w3c.dom.Node;

public class ConnectorNode
extends BundleNode
implements RootXMLNode {
    private ConnectorDescriptor descriptor;
    public static String VERSION_10 = "1.0";
    public static String VERSION_15;
    private String specVersion;
    public static final String PUBLIC_DTD_ID_10 = "-//Sun Microsystems, Inc.//DTD Connector 1.0//EN";
    public static final String SYSTEM_ID_10 = "http://java.sun.com/dtd/connector_1_0.dtd";
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Connector 1.5//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/connector_1_5.dtd";
    public static final String SCHEMA_ID = "connector_1_5.xsd";
    public static final String SPEC_VERSION;
    public static final XMLElement tag;

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_10, SYSTEM_ID_10);
        return tag.getQName();
    }

    public ConnectorNode() {
        this.registerElementHandler(new XMLElement("license"), LicenseNode.class, "setLicenseDescriptor");
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (ConnectorDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        this.getDescriptor();
        if (this.descriptor == null) {
            throw new RuntimeException("Trying to set values on a null descriptor");
        }
        if (attributeName.getQName().equals("version")) {
            this.descriptor.setSpecVersion(value);
            this.specVersion = value;
            return true;
        }
        return attributeName.getQName().equals("id");
    }

    public void setElementValue(XMLElement element, String value) {
        this.getDescriptor();
        if (this.descriptor == null) {
            throw new RuntimeException("Trying to set values on a null descriptor");
        }
        if ("spec-version".equals(element.getQName())) {
            this.descriptor.setSpecVersion(value);
            this.specVersion = value;
        } else if ("version".equals(element.getQName())) {
            this.descriptor.setResourceAdapterVersion(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public boolean handlesElement(XMLElement element) {
        if ("resourceadapter".equals(element.getQName())) {
            return false;
        }
        return super.handlesElement(element);
    }

    public XMLNode getHandlerFor(XMLElement element) {
        if ("resourceadapter".equals(element.getQName())) {
            if (VERSION_10.equals(this.specVersion)) {
                OutBoundRANode outboundRANode = new OutBoundRANode(element);
                outboundRANode.setParentNode(this);
                outboundRANode.createConDefDescriptorFor10();
                return outboundRANode;
            }
            RANode raNode = new RANode(element);
            raNode.setParentNode(this);
            return raNode;
        }
        return super.getHandlerFor(element);
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    public void addDescriptor(Object newDescriptor) {
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("vendor-name", "setVendorName");
        table.put("eis-type", "setEisType");
        table.put("resourceadapter-version", "setResourceAdapterVersion");
        return table;
    }

    public String getDocType() {
        return null;
    }

    public String getSystemID() {
        return SCHEMA_ID;
    }

    public Node writeDescriptor(Node parent, Descriptor descriptor) {
        if (!(descriptor instanceof ConnectorDescriptor)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handle descriptors of type " + descriptor.getClass());
        }
        ConnectorDescriptor conDesc = (ConnectorDescriptor)descriptor;
        conDesc.setSpecVersion(VERSION_15);
        Node connectorNode = super.writeDescriptor(parent, conDesc);
        ConnectorNode.appendTextChild(connectorNode, "vendor-name", conDesc.getVendorName());
        ConnectorNode.appendTextChild(connectorNode, "eis-type", conDesc.getEisType());
        ConnectorNode.appendTextChild(connectorNode, "resourceadapter-version", conDesc.getResourceAdapterVersion());
        LicenseNode licenseNode = new LicenseNode();
        connectorNode = licenseNode.writeDescriptor(connectorNode, conDesc);
        RANode raNode = new RANode();
        connectorNode = raNode.writeDescriptor(connectorNode, conDesc);
        return connectorNode;
    }

    public String getSpecVersion() {
        return SPEC_VERSION;
    }

    static {
        SPEC_VERSION = VERSION_15 = "1.5";
        tag = new XMLElement("connector");
    }
}

