/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.EjbLocalReferenceNode;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.ServiceReferenceNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import org.w3c.dom.Node;

public class AppClientNode
extends BundleNode
implements RootXMLNode {
    private ApplicationClientDescriptor descriptor;
    public static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
    public static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/application-client_1_2.dtd";
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/application-client_1_3.dtd";
    public static final String SCHEMA_ID = "application-client_1_4.xsd";
    public static final String SPEC_VERSION = "1.4";
    public static final XMLElement tag = new XMLElement("application-client");

    public AppClientNode() {
        this.registerElementHandler(new XMLElement("env-entry"), EnvEntryNode.class, "addEnvironmentProperty");
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbReferenceNode.class);
        this.registerElementHandler(new XMLElement("ejb-local-ref"), EjbLocalReferenceNode.class);
        this.registerElementHandler(new XMLElement("service-ref"), ServiceReferenceNode.class, "addServiceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class, "addResourceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class, "addJmsDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class, "addMessageDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationNode.class, "addMessageDestination");
    }

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbReference) {
            DOLUtils.getDefaultLogger().fine("Adding ejb ref " + newDescriptor);
            ((ApplicationClientDescriptor)this.getDescriptor()).addEjbReferenceDescriptor((EjbReference)newDescriptor);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (ApplicationClientDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("callback-handler", "setCallbackHandler");
        return table;
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    public String getDocType() {
        return null;
    }

    public String getSystemID() {
        return SCHEMA_ID;
    }

    public Node writeDescriptor(Node parent, Descriptor descriptor) {
        if (!(descriptor instanceof ApplicationClientDescriptor)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handle descriptors of type " + descriptor.getClass());
        }
        ApplicationClientDescriptor appclientDesc = (ApplicationClientDescriptor)descriptor;
        Node appclientNode = super.writeDescriptor(parent, appclientDesc);
        this.writeEnvEntryDescriptors(appclientNode, appclientDesc.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(appclientNode, appclientDesc.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(appclientNode, appclientDesc.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(appclientNode, appclientDesc.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(appclientNode, appclientDesc.getJmsDestinationReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(appclientNode, appclientDesc.getMessageDestinationReferenceDescriptors().iterator());
        AppClientNode.appendTextChild(appclientNode, "callback-handler", appclientDesc.getCallbackHandler());
        this.writeMessageDestinations(appclientNode, appclientDesc.getMessageDestinations().iterator());
        return appclientNode;
    }

    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

