/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.WebServiceHandlerNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceReferenceNode
extends DisplayableComponentNode {
    private String serviceEndpointInterface = null;
    private ServiceRefPortInfo portInfo = null;

    public ServiceReferenceNode() {
        this.registerElementHandler(new XMLElement("handler"), WebServiceHandlerNode.class, "addHandler");
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("service-ref-name", "setName");
        table.put("service-interface", "setServiceInterface");
        table.put("wsdl-file", "setWsdlFileUri");
        table.put("jaxrpc-mapping-file", "setMappingFileUri");
        return table;
    }

    private ServiceReferenceDescriptor getServiceReferenceDescriptor() {
        return (ServiceReferenceDescriptor)this.getDescriptor();
    }

    public void setElementValue(XMLElement element, String value) {
        String qname = element.getQName();
        if ("service-endpoint-interface".equals(qname)) {
            this.portInfo = this.getServiceReferenceDescriptor().getPortInfoBySEI(value);
            if (this.portInfo == null) {
                this.portInfo = this.getServiceReferenceDescriptor().addContainerManagedPort(value);
            }
        } else if ("service-qname".equals(qname)) {
            String prefix = this.getPrefixFromQName(value);
            String localPart = this.getLocalPartFromQName(value);
            String namespaceUri = this.resolvePrefix(element, prefix);
            if (namespaceUri == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{prefix, this.getServiceReferenceDescriptor().getName()});
            } else {
                QName serviceName = new QName(namespaceUri, localPart);
                this.getServiceReferenceDescriptor().setServiceName(serviceName, prefix);
            }
        } else if ("port-component-link".equals(qname)) {
            this.portInfo.setPortComponentLinkName(value);
            this.portInfo = null;
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, ServiceReferenceDescriptor descriptor) {
        Node serviceRefNode = super.writeDescriptor(parent, nodeName, descriptor);
        this.writeDisplayableComponentInfo(serviceRefNode, descriptor);
        ServiceReferenceNode.appendTextChild(serviceRefNode, "service-ref-name", descriptor.getName());
        ServiceReferenceNode.appendTextChild(serviceRefNode, "service-interface", descriptor.getServiceInterface());
        ServiceReferenceNode.appendTextChild(serviceRefNode, "wsdl-file", descriptor.getWsdlFileUri());
        ServiceReferenceNode.appendTextChild(serviceRefNode, "jaxrpc-mapping-file", descriptor.getMappingFileUri());
        if (descriptor.hasServiceName()) {
            QName serviceName = descriptor.getServiceName();
            this.appendQNameChild("service-qname", serviceRefNode, serviceName.getNamespaceURI(), serviceName.getLocalPart(), descriptor.getServiceNameNamespacePrefix());
        }
        Iterator iter = descriptor.getPortsInfo().iterator();
        while (iter.hasNext()) {
            ServiceRefPortInfo next = (ServiceRefPortInfo)iter.next();
            if (!next.isContainerManaged()) continue;
            String serviceEndpointInterface = next.getServiceEndpointInterface();
            Element portComponentRefNode = ServiceReferenceNode.appendChild(serviceRefNode, "port-component-ref");
            ServiceReferenceNode.appendTextChild((Node)portComponentRefNode, "service-endpoint-interface", serviceEndpointInterface);
            ServiceReferenceNode.appendTextChild((Node)portComponentRefNode, "port-component-link", next.getPortComponentLinkName());
        }
        WebServiceHandlerNode handlerNode = new WebServiceHandlerNode();
        handlerNode.writeWebServiceHandlers(serviceRefNode, descriptor.getHandlerChain());
        return serviceRefNode;
    }
}

