/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.backend.AppDD;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class ContextRootChecker {
    private static Map serverXMLtimeStampMap;
    private static Map instanceMap;
    private InstanceEnvironment iEnv;
    private String[] contextRoots;
    private AppsManager appMgr;
    private WebModulesManager webMgr;
    private String instanceName;
    private String appName = null;
    private String webName = null;
    private String matchDescription = null;
    private static final long fileWriteLatencyMilliSec = 5000L;
    private final Logger logger = DeploymentLogger.get();
    private static StringManager localStrings;
    private static final String ctorErr = "Internal Error: call to ContextRootChecker.ContextRootChecker with ";
    private static final String undeployErr;
    static final /* synthetic */ boolean $assertionsDisabled;

    ContextRootChecker(InstanceEnvironment iEnv, String[] contextRoots, AppsManager appMgr, String appName) throws IASDeploymentException {
        this.preCtor(iEnv, contextRoots);
        this.appMgr = appMgr;
        this.appName = appName;
        if (appMgr == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_appsmanager_object");
            throw new IASDeploymentException(msg);
        }
        if (!StringUtils.ok((String)appName)) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_appName");
            throw new IASDeploymentException(msg);
        }
        try {
            this.webMgr = new WebModulesManager(iEnv);
        }
        catch (ConfigException ce) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_creating_webmodulesmanager", ce);
            throw new IASDeploymentException(msg, ce);
        }
    }

    ContextRootChecker(InstanceEnvironment iEnv, String[] contextRoots, WebModulesManager webMgr, String webName) throws IASDeploymentException {
        this.preCtor(iEnv, contextRoots);
        this.webMgr = webMgr;
        this.webName = webName;
        if (webMgr == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_webmodulesmanager_object");
            throw new IASDeploymentException(msg);
        }
        if (!StringUtils.ok((String)webName)) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_webname");
            throw new IASDeploymentException(msg);
        }
        try {
            this.appMgr = new AppsManager(iEnv);
        }
        catch (ConfigException ce) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_creating_appsmanager", ce);
            throw new IASDeploymentException(msg, ce);
        }
    }

    void check() throws IASDeploymentException {
        if (this.alreadyExists()) {
            String msg = localStrings.getString("enterprise.deployment.backend.context_root_exists", this.matchDescription);
            throw new IASDeploymentException(msg);
        }
    }

    static synchronized void checkTimeStamp(InstanceEnvironment env) {
        if (!$assertionsDisabled && env == null) {
            throw new AssertionError();
        }
        String instanceName = env.getName();
        Long cacheTimeStamp = (Long)serverXMLtimeStampMap.get(instanceName);
        if (cacheTimeStamp == null) {
            instanceMap.remove(env.getName());
            return;
        }
        Long currentConfigTimeStamp = ContextRootChecker.getFileTimeStamp(env);
        if (currentConfigTimeStamp > cacheTimeStamp) {
            instanceMap.remove(env.getName());
            serverXMLtimeStampMap.remove(instanceName);
        }
    }

    static synchronized void undeploy(InstanceEnvironment env, String appName) throws IASDeploymentException {
        if (!StringUtils.ok((String)appName)) {
            throw new IASDeploymentException(undeployErr);
        }
        Map appMap = (Map)instanceMap.get(env.getName());
        if (appMap == null) {
            return;
        }
        appMap.remove(appName);
        ContextRootChecker.setTimeStamp(env);
    }

    static synchronized void update(InstanceEnvironment env, String appID, File appDir) throws IASDeploymentException {
        if (!$assertionsDisabled && instanceMap == null) {
            throw new AssertionError();
        }
        if (!StringUtils.ok((String)appID)) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_appid_argument");
            throw new IASDeploymentException(msg);
        }
        Map appMap = (Map)instanceMap.get(env.getName());
        if (appMap == null) {
            return;
        }
        try {
            File location = new File(appDir.getCanonicalPath());
            AppDD appDD = new AppDD(location);
            String[] crs = appDD.getContextRoots();
            AppInfo info = new AppInfo(appDD.getFile(), crs);
            appMap.put(appID, info);
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_updating_appmap", e);
            throw new IASDeploymentException(msg, e);
        }
        ContextRootChecker.setTimeStamp(env);
    }

    private void preCtor(InstanceEnvironment iEnv, String[] contextRoots) throws IASDeploymentException {
        if (!$assertionsDisabled && instanceMap == null) {
            throw new AssertionError();
        }
        this.iEnv = iEnv;
        this.contextRoots = contextRoots;
        if (iEnv == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_instanceenvironment_object");
            throw new IASDeploymentException(msg);
        }
        this.instanceName = iEnv.getName();
    }

    private boolean alreadyExists() throws IASDeploymentException {
        if (this.contextRoots.length <= 0) {
            return false;
        }
        if (this.alreadyExistsInWebModule()) {
            return true;
        }
        return this.alreadyExistsInApplication();
    }

    private boolean alreadyExistsInWebModule() throws IASDeploymentException {
        try {
            WebModule[] webModules = this.webMgr.listWebModules();
            if (webModules == null || webModules.length == 0) {
                return false;
            }
            for (int i = 0; i < webModules.length; ++i) {
                WebModule wm = webModules[i];
                if (this.webName != null && this.webName.equals(wm.getName())) continue;
                String cr = wm.getContextRoot();
                for (int whichCR = 0; whichCR < this.contextRoots.length; ++whichCR) {
                    if (!cr.equals(this.contextRoots[whichCR])) continue;
                    this.matchDescription = "Stand-alone Web Module: " + wm.getName();
                    return true;
                }
            }
        }
        catch (ConfigException e) {
            String msg = localStrings.getString("enterprise.deployment.backend.config_exception_in_alreadyexistsinwebmodule");
            throw new IASDeploymentException(msg, e);
        }
        return false;
    }

    private void checkAppFileStamps() {
        Map appMap = (Map)instanceMap.get(this.instanceName);
        if (appMap == null) {
            return;
        }
        Set appIDs = appMap.keySet();
        Iterator it = appIDs.iterator();
        while (it.hasNext()) {
            String currAppName = (String)it.next();
            if (this.appName != null && currAppName != null && currAppName.equals(this.appName)) continue;
            AppInfo appInfo = (AppInfo)appMap.get(currAppName);
            File appXML = appInfo.appXML;
            long cachedTS = appInfo.fileTimeStamp;
            if (appXML == null || !appXML.exists()) {
                instanceMap.remove(this.instanceName);
                return;
            }
            long currentTS = appXML.lastModified();
            if (currentTS <= cachedTS) continue;
            instanceMap.remove(this.instanceName);
            return;
        }
    }

    private boolean alreadyExistsInApplication() throws IASDeploymentException {
        this.checkAppFileStamps();
        Map appMap = this.getAppMap();
        if (!$assertionsDisabled && appMap == null) {
            throw new AssertionError();
        }
        Set appIDs = appMap.keySet();
        Iterator appIt = appIDs.iterator();
        while (appIt.hasNext()) {
            String appID = (String)appIt.next();
            if (this.appName != null && appID.equals(this.appName)) continue;
            AppInfo appInfo = (AppInfo)appMap.get(appID);
            String[] appCRs = appInfo.contextRoots;
            for (int appCRIndex = 0; appCRIndex < appCRs.length; ++appCRIndex) {
                String appCR = appCRs[appCRIndex];
                if (appCR == null) continue;
                for (int currCRIndex = 0; currCRIndex < this.contextRoots.length; ++currCRIndex) {
                    String currCR = this.contextRoots[currCRIndex];
                    if (!appCR.equals(currCR) || this.appName != null && appID.equals(this.appName)) continue;
                    this.matchDescription = "Application: " + appID;
                    return true;
                }
            }
        }
        return false;
    }

    private synchronized Map getAppMap() {
        HashMap<String, AppInfo> appMap = (HashMap<String, AppInfo>)instanceMap.get(this.instanceName);
        if (appMap != null) {
            return appMap;
        }
        List apps = this.appMgr.listIds();
        appMap = new HashMap<String, AppInfo>();
        instanceMap.put(this.instanceName, appMap);
        Iterator it = apps.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            if (!StringUtils.ok((String)id)) continue;
            try {
                if (!this.appMgr.isEnabled(id)) continue;
                File location = new File(DeploymentServiceUtils.getLocation(id, DeployableObjectType.APP));
                AppDD appDD = new AppDD(location);
                String[] crs = appDD.getContextRoots();
                AppInfo info = new AppInfo(appDD.getFile(), crs);
                appMap.put(id, info);
            }
            catch (Exception e) {
                this.logger.warning("Exception in createAppsList: " + e);
            }
        }
        ContextRootChecker.setTimeStamp(this.iEnv);
        return appMap;
    }

    private static Long getFileTimeStamp(InstanceEnvironment env) {
        long coldTS;
        File hot = new File(env.getBackupConfigFilePath());
        File cold = new File(env.getConfigFilePath());
        long hotTS = hot.lastModified();
        long ts = hotTS > (coldTS = cold.lastModified()) ? hotTS : coldTS;
        return new Long(ts);
    }

    private static void setTimeStamp(InstanceEnvironment env) {
        serverXMLtimeStampMap.put(env.getName(), new Long(5000L + System.currentTimeMillis()));
    }

    static {
        $assertionsDisabled = !ContextRootChecker.class.desiredAssertionStatus();
        serverXMLtimeStampMap = new HashMap();
        instanceMap = new HashMap();
        localStrings = StringManager.getManager(ContextRootChecker.class);
        undeployErr = localStrings.getString("enterprise.deployment.backend.undeploy_error");
    }

    private static class AppInfo {
        String[] contextRoots;
        long fileTimeStamp;
        File appXML;

        AppInfo(File f, String[] crs) {
            this.appXML = f;
            this.contextRoots = crs;
            this.fileTimeStamp = this.appXML.lastModified();
        }
    }
}

