/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

class AppDD {
    private File file = null;
    private Set ejbModules = new HashSet();
    private Set warModules = new HashSet();
    private Set rarModules = new HashSet();
    private Set clientModules = new HashSet();
    private Application app = null;
    private Set contextRoots = null;
    private final Logger logger = DeploymentLogger.get();
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    AppDD(File f) throws IASDeploymentException, IOException, SAXParseException {
        this(f, false);
    }

    AppDD(File f, boolean validateXML) throws IASDeploymentException, IOException, SAXParseException {
        if (f == null || !f.exists()) {
            String msg = localStrings.getString("enterprise.deployment.backend.bad_file_parameter", f);
            throw new IllegalArgumentException(msg);
        }
        if (f.isDirectory()) {
            f = new File(f, "META-INF");
            f = new File(f, "application.xml");
        }
        if (!f.exists() || f.isDirectory()) {
            String msg = localStrings.getString("enterprise.deployment.backend.no_application_xml", f.getPath());
            throw new IASDeploymentException(msg);
        }
        this.file = f;
        try {
            this.parse(validateXML);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof IASDeploymentException) {
                throw (IASDeploymentException)t;
            }
            String msg = localStrings.getString("enterprise.deployment.backend.error_parsing_application_xml", this.file.getPath(), t);
            throw new IASDeploymentException(msg, t);
        }
    }

    Application getApplication() {
        return this.app;
    }

    String[] getEjbModules() {
        String[] ss = new String[this.ejbModules.size()];
        return this.ejbModules.toArray(ss);
    }

    String[] getWarModules() {
        String[] ss = new String[this.warModules.size()];
        return this.warModules.toArray(ss);
    }

    String[] getRarModules() {
        String[] ss = new String[this.rarModules.size()];
        return this.rarModules.toArray(ss);
    }

    String[] getClientModules() {
        String[] ss = new String[this.clientModules.size()];
        return this.clientModules.toArray(ss);
    }

    String[] getContextRoots() {
        String[] ss = new String[this.contextRoots.size()];
        return this.contextRoots.toArray(ss);
    }

    File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(boolean validateXML) throws IASDeploymentException, IOException, SAXParseException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            ApplicationDeploymentDescriptorFile addf = new ApplicationDeploymentDescriptorFile();
            addf.setXMLValidation(validateXML);
            if (validateXML) {
                addf.setXMLValidationLevel(Deployer.getValidationLevel());
            }
            this.app = (Application)addf.read(fis);
            Iterator modules = this.app.getModules();
            while (modules.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)modules.next();
                if (md.getModuleType().equals(ModuleType.EJB)) {
                    this.ejbModules.add(md.getArchiveUri());
                    continue;
                }
                if (md.getModuleType().equals(ModuleType.WAR)) {
                    this.warModules.add(md.getArchiveUri());
                    continue;
                }
                if (md.getModuleType().equals(ModuleType.CAR)) {
                    this.clientModules.add(md.getArchiveUri());
                    continue;
                }
                if (!md.getModuleType().equals(ModuleType.RAR)) continue;
                this.rarModules.add(md.getArchiveUri());
            }
            this.setContextRoots(this.app);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private void setContextRoots(Application app) throws IASDeploymentException {
        if (!$assertionsDisabled && app == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.warModules == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.contextRoots != null) {
            throw new AssertionError();
        }
        this.contextRoots = new HashSet();
        Iterator it = this.warModules.iterator();
        while (it.hasNext()) {
            ModuleDescriptor md = app.getModuleDescriptorByUri((String)it.next());
            String cr = md.getContextRoot();
            if (this.contextRoots.add(cr)) continue;
            String msg = localStrings.getString("enterprise.deployment.backend.duplicate_context_root", cr);
            throw new IASDeploymentException(msg);
        }
    }

    private String trim(String s) {
        int index = s.indexOf(">");
        String ret = s.substring(index + 1);
        ret = ret.substring(0, ret.indexOf("<"));
        return ret;
    }

    static {
        $assertionsDisabled = !AppDD.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(AppDD.class);
    }
}

