/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.WebRuntimeDDFile;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleContentValidator;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

public class WebArchivist
extends Archivist {
    private WebBundleDescriptor descriptor;
    DeploymentDescriptorFile standardDD = new WebDeploymentDescriptorFile();

    public ModuleType getModuleType() {
        return ModuleType.WAR;
    }

    public void setDescriptor(Descriptor descriptor) {
        if (!(descriptor instanceof WebBundleDescriptor)) {
            Set webBundles;
            if (descriptor instanceof Application && (webBundles = ((Application)descriptor).getWebBundleDescriptors()).size() > 0) {
                this.descriptor = (WebBundleDescriptor)webBundles.iterator().next();
                if (this.descriptor.getModuleDescriptor().isStandalone()) {
                    return;
                }
                this.descriptor = null;
            }
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.descriptorFailure", new Object[]{this});
            throw new RuntimeException("Error setting descriptor " + descriptor + " in " + this);
        }
        this.descriptor = (WebBundleDescriptor)descriptor;
    }

    public String getWebServicesDeploymentDescriptorPath() {
        return "WEB-INF/webservices.xml";
    }

    public DeploymentDescriptorFile getStandardDDFile() {
        return this.standardDD;
    }

    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new WebRuntimeDDFile();
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    protected void postOpen(RootDeploymentDescriptor descriptor, AbstractArchive archive) throws IOException {
        super.postOpen(descriptor, archive);
        WebBundleDescriptor webBundle = (WebBundleDescriptor)descriptor;
        ModuleContentValidator mdv = new ModuleContentValidator(archive);
        webBundle.visit(mdv);
    }

    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        this.descriptor.visit(new ApplicationValidator());
    }
}

