/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.archivist.InputJarArchive;
import com.sun.enterprise.deployment.archivist.PluggableArchivists;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.ApplicationRuntimeDDFile;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

public class ApplicationArchivist
extends Archivist {
    Application application = null;
    DeploymentDescriptorFile standardDD = new ApplicationDeploymentDescriptorFile();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationArchivist.class);

    public ApplicationArchivist() {
        this.handleRuntimeInfo = true;
    }

    public ModuleType getModuleType() {
        return ModuleType.EAR;
    }

    public void setDescriptor(Descriptor descriptor) {
        if (!(descriptor instanceof Application)) {
            throw new RuntimeException("Error setting descriptor in " + this);
        }
        this.application = (Application)descriptor;
    }

    protected void writeContents(AbstractArchive in, AbstractArchive out) throws IOException {
        Vector<String> filesToSkip = new Vector<String>();
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Write " + out.getArchiveUri() + " with " + this);
        }
        Enumeration alreadyWritten = out.entries();
        while (alreadyWritten.hasMoreElements()) {
            String elementName = (String)alreadyWritten.nextElement();
            filesToSkip.add(elementName);
        }
        Iterator modules = this.application.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor aModule = (ModuleDescriptor)modules.next();
            Archivist subArchivist = this.getPluggableArchivists().getArchivistForType(aModule.getModuleType());
            subArchivist.initializeContext(this);
            subArchivist.setModuleDescriptor(aModule);
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().info("Write " + aModule.getArchiveUri() + " with " + subArchivist);
            }
            if (aModule.getAlternateDescriptor() != null) {
                OutputStream os = out.addEntry(aModule.getAlternateDescriptor());
                subArchivist.writeStandardDeploymentDescriptors(os);
                out.closeEntry(os);
                if (!this.isHandlingRuntimeInfo()) continue;
                os = out.addEntry("sun-" + aModule.getAlternateDescriptor());
                subArchivist.writeRuntimeDeploymentDescriptors(os);
                out.closeEntry(os);
                continue;
            }
            AbstractArchive internalJar = out.getEmbeddedArchive(aModule.getArchiveUri());
            InputStream is = in.getEntry(aModule.getArchiveUri());
            File tmpFile = null;
            try {
                if (in.supportsElementsOverwriting()) {
                    subArchivist.setArchiveUri(internalJar.getArchiveUri());
                } else {
                    tmpFile = ApplicationArchivist.getTempFile(this.path);
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
                    ApplicationArchivist.copy(is, bos);
                    subArchivist.setArchiveUri(tmpFile.getAbsolutePath());
                }
                subArchivist.writeContents(internalJar);
                out.closeEntry(internalJar);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
            filesToSkip.add(aModule.getArchiveUri());
        }
        super.writeContents(in, out, filesToSkip);
    }

    public Descriptor getDescriptor() {
        return this.application;
    }

    public RootDeploymentDescriptor open(AbstractArchive appArchive) throws IOException, SAXParseException {
        this.setManifest(appArchive.getManifest());
        Descriptor appDesc = this.readStandardDeploymentDescriptor(appArchive);
        this.setDescriptor(appDesc);
        Iterator modules = this.application.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor aModule = (ModuleDescriptor)modules.next();
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Opening sub-module " + aModule);
            }
            Descriptor descriptor = null;
            Archivist newArchivist = this.getPluggableArchivists().getArchivistForType(aModule.getModuleType());
            newArchivist.initializeContext(this);
            newArchivist.setRuntimeXMLValidation(this.getRuntimeXMLValidation());
            newArchivist.setRuntimeXMLValidationLevel(this.getRuntimeXMLValidationLevel());
            AbstractArchive embeddedArchive = appArchive.getEmbeddedArchive(aModule.getArchiveUri());
            if (aModule.getAlternateDescriptor() != null) {
                InputStream is = appArchive.getEntry(aModule.getAlternateDescriptor());
                DeploymentDescriptorFile ddFile = newArchivist.getStandardDDFile();
                ddFile.setXMLValidation(newArchivist.getXMLValidation());
                ddFile.setXMLValidationLevel(newArchivist.getXMLValidationLevel());
                if (appArchive.getArchiveUri() != null) {
                    ddFile.setErrorReportingString(appArchive.getArchiveUri());
                }
                descriptor = ddFile.read(is);
                is.close();
                newArchivist.postOpen((RootDeploymentDescriptor)descriptor, embeddedArchive);
                if (this.isHandlingRuntimeInfo()) {
                    is = appArchive.getEntry("sun-" + aModule.getAlternateDescriptor());
                    if (is != null) {
                        DeploymentDescriptorFile confDD = newArchivist.getConfigurationDDFile();
                        confDD.setXMLValidation(newArchivist.getRuntimeXMLValidation());
                        confDD.setXMLValidationLevel(newArchivist.getRuntimeXMLValidationLevel());
                        if (appArchive.getArchiveUri() != null) {
                            confDD.setErrorReportingString(appArchive.getArchiveUri());
                        }
                        confDD.read(descriptor, is);
                        is.close();
                    } else if (embeddedArchive != null) {
                        newArchivist.readRuntimeDeploymentDescriptor(embeddedArchive, descriptor);
                    }
                }
            } else if (embeddedArchive != null) {
                descriptor = newArchivist.open(embeddedArchive);
            } else {
                DOLUtils.getDefaultLogger().info(localStrings.getLocalString("enterprise.deployment.cannotfindmodule", "Cannot find module {0} in application bundle", new Object[]{aModule.getArchiveUri()}));
            }
            if (embeddedArchive != null) {
                embeddedArchive.close();
            }
            if (descriptor != null && descriptor instanceof BundleDescriptor) {
                aModule.setDescriptor((BundleDescriptor)descriptor);
                ((BundleDescriptor)descriptor).setApplication(this.application);
                aModule.setManifest(newArchivist.getManifest());
                continue;
            }
            if (embeddedArchive == null) continue;
            DOLUtils.getDefaultLogger().info(localStrings.getLocalString("enterprise.deployment.cannotreadDDs", "Cannot read the Deployment Descriptors for module {0}", new Object[]{aModule.getArchiveUri()}));
        }
        super.readRuntimeDeploymentDescriptor(appArchive, appDesc);
        if (this.classLoader != null) {
            this.validate(null);
        }
        return (RootDeploymentDescriptor)appDesc;
    }

    public void readRuntimeDeploymentDescriptor(AbstractArchive archive, Descriptor descriptor) throws IOException, SAXParseException {
        if (descriptor instanceof Application) {
            Application application = (Application)descriptor;
            Iterator itr = application.getModules();
            while (itr.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)itr.next();
                Archivist archivist = this.getPluggableArchivists().getArchivistForType(md.getModuleType());
                archivist.setRuntimeXMLValidation(this.getRuntimeXMLValidation());
                archivist.setRuntimeXMLValidationLevel(this.getRuntimeXMLValidationLevel());
                InputStream is = null;
                if (md.getAlternateDescriptor() != null && (is = archive.getEntry("sun-" + md.getAlternateDescriptor())) != null) {
                    DeploymentDescriptorFile confDD = archivist.getConfigurationDDFile();
                    confDD.setXMLValidation(archivist.getRuntimeXMLValidation());
                    confDD.setXMLValidationLevel(archivist.getRuntimeXMLValidationLevel());
                    if (archive.getArchiveUri() != null) {
                        confDD.setErrorReportingString(archive.getArchiveUri());
                    }
                    confDD.read((Descriptor)md.getDescriptor(), is);
                    is.close();
                }
                if (is != null) continue;
                AbstractArchive subArchive = archive.getEmbeddedArchive(md.getArchiveUri());
                archivist.readRuntimeDeploymentDescriptor(subArchive, md.getDescriptor());
            }
        }
        super.readRuntimeDeploymentDescriptor(archive, descriptor);
    }

    public void readRuntimeDDFromDeploymentPlan(AbstractArchive planArchive, Descriptor descriptor) throws IOException, SAXParseException {
        if (planArchive == null) {
            return;
        }
        Vector dpEntries = new Vector();
        Enumeration e = planArchive.entries();
        while (e.hasMoreElements()) {
            dpEntries.add(e.nextElement());
        }
        if (descriptor instanceof Application) {
            Application application = (Application)descriptor;
            Iterator itr = application.getModules();
            while (itr.hasNext()) {
                ModuleDescriptor moduleDesc = (ModuleDescriptor)itr.next();
                Archivist subArchivist = ArchivistFactory.getArchivistForType(moduleDesc.getModuleType());
                String archiveUri = moduleDesc.getArchiveUri();
                String runtimeDDPath = subArchivist.getRuntimeDeploymentDescriptorPath();
                if (runtimeDDPath == null) continue;
                String mangledName = archiveUri + "." + runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1);
                DOLUtils.getDefaultLogger().fine("mangledName is " + mangledName);
                if (!dpEntries.contains(mangledName)) continue;
                subArchivist.readRuntimeDDFromDeploymentPlan(mangledName, planArchive, moduleDesc.getDescriptor());
            }
        }
        super.readRuntimeDDFromDeploymentPlan(planArchive, descriptor);
    }

    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        this.application.setClassLoader(cl);
        this.application.visit(new ApplicationValidator());
    }

    public ModuleDescriptor addArchive(String archivePath, Set libraryJars, String externalDD) throws SAXParseException, IOException {
        AbstractArchive newArchive = this.abstractArchiveFactory.openArchive(archivePath);
        return this.addArchive(newArchive, libraryJars, externalDD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleDescriptor addArchive(AbstractArchive newArchive, Set libraryJars, String externalDD) throws SAXParseException, IOException {
        File outputFile = null;
        ModuleDescriptor newModule = null;
        try {
            outputFile = ApplicationArchivist.getTempFile(this.path);
            AbstractArchive out = this.abstractArchiveFactory.createArchive(outputFile.getAbsolutePath());
            newModule = this.getModuleFor(out, newArchive, libraryJars, externalDD);
            this.application.addModule(newModule);
            AbstractArchive in = this.abstractArchiveFactory.openArchive(this.path);
            Vector<String> filesToSkip = new Vector<String>();
            filesToSkip.add(newModule.getArchiveUri());
            this.writeContents(in, out, filesToSkip);
            in.close();
            out.close();
            this.renameTmp(outputFile.getAbsolutePath(), this.path);
        }
        finally {
            if (outputFile != null) {
                outputFile.delete();
            }
        }
        return newModule;
    }

    private ModuleDescriptor getModuleFor(AbstractArchive out, AbstractArchive newArchive, Set libraryJars, String externalDD) throws SAXParseException, IOException {
        Archivist newArchivist = this.getPluggableArchivists().getArchivistForArchive(newArchive);
        newArchivist.initializeContext(this);
        newArchivist.setArchiveUri(newArchive.getArchiveUri());
        ModuleDescriptor newModule = newArchivist.addToArchive(this, externalDD);
        newArchivist.prepareForInclusion(out);
        if (libraryJars != null && !libraryJars.isEmpty()) {
            StringBuffer classPath = new StringBuffer();
            Iterator e = libraryJars.iterator();
            while (e.hasNext()) {
                String libUri = (String)e.next();
                File libFile = new File(libUri);
                if (libFile.exists()) {
                    classPath.append(libUri);
                    classPath.append(' ');
                    ApplicationArchivist.addFileToArchive(out, libFile.getAbsolutePath(), libUri);
                    continue;
                }
                throw new FileNotFoundException("Library file " + libFile.getAbsolutePath() + " not found");
            }
            Manifest manifest = newArchivist.getManifest();
            if (manifest == null) {
                manifest = new Manifest();
                newArchivist.setManifest(manifest);
            }
            Attributes atts = manifest.getMainAttributes();
            atts.putValue(Attributes.Name.CLASS_PATH.toString(), classPath.toString());
        }
        AbstractArchive newModuleJar = out.getEmbeddedArchive(newModule.getArchiveUri());
        newArchivist.writeContents(newModuleJar);
        out.closeEntry(newModuleJar);
        return newModule;
    }

    public DeploymentDescriptorFile getStandardDDFile() {
        return this.standardDD;
    }

    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new ApplicationRuntimeDDFile();
    }

    public void copyInto(AbstractArchive source, AbstractArchive target) throws IOException {
        try {
            Application a = (Application)this.readStandardDeploymentDescriptor(source);
        }
        catch (SAXParseException spe) {
            spe.printStackTrace();
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.fileCopyFailure");
        }
    }

    public void copyInto(Application a, AbstractArchive source, AbstractArchive target) throws IOException {
        this.copyInto(a, source, target, true);
    }

    public void copyInto(Application a, AbstractArchive source, AbstractArchive target, boolean overwriteManifest) throws IOException {
        Vector<String> entriesAdded = new Vector<String>();
        Iterator modules = a.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor aModule = (ModuleDescriptor)modules.next();
            entriesAdded.add(aModule.getArchiveUri());
            AbstractArchive subSource = source.getEmbeddedArchive(aModule.getArchiveUri());
            AbstractArchive subTarget = target.getEmbeddedArchive(aModule.getArchiveUri());
            Archivist newArchivist = this.getPluggableArchivists().getArchivistForType(aModule.getModuleType());
            newArchivist.copyInto(subSource, subTarget, overwriteManifest);
            target.closeEntry(subTarget);
            String subModulePath = subSource.getArchiveUri();
            if (subModulePath.startsWith(source.getArchiveUri())) {
                subModulePath = subModulePath.substring(source.getArchiveUri().length() + File.separator.length());
                Enumeration subEntries = subSource.entries();
                while (subEntries.hasMoreElements()) {
                    String anEntry = (String)subEntries.nextElement();
                    entriesAdded.add(subModulePath + "/" + anEntry);
                }
            }
            subSource.close();
        }
        super.copyInto(source, target, entriesAdded, overwriteManifest);
    }

    public static Application openArchive(File jarFile) throws IOException, SAXParseException {
        return ApplicationArchivist.openArchive(jarFile, false);
    }

    public static Application openArchive(Archivist archivist, File jarFile, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        AbstractArchive originalArchive = null;
        if (jarFile.isDirectory()) {
            originalArchive = new FileArchive();
            ((FileArchive)originalArchive).open(jarFile.getAbsolutePath());
        } else {
            originalArchive = new InputJarArchive();
            ((InputJarArchive)originalArchive).open(jarFile.getAbsolutePath());
        }
        Application application = ApplicationArchivist.openArchive(archivist, originalArchive, handleRuntimeInfo);
        originalArchive.close();
        return application;
    }

    public static Application openArchive(Archivist archivist, AbstractArchive in, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        return ApplicationArchivist.openArchive(in.getArchiveUri(), archivist, in, handleRuntimeInfo);
    }

    public static Application openArchive(String appName, Archivist archivist, AbstractArchive in, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        Application application;
        archivist.setHandleRuntimeInfo(false);
        RootDeploymentDescriptor descriptor = archivist.open(in);
        if (descriptor instanceof Application) {
            application = (Application)descriptor;
            application.setRegistrationName(appName);
        } else {
            BundleDescriptor aBundle = (BundleDescriptor)descriptor;
            ModuleDescriptor newModule = archivist.createModuleDescriptor(aBundle);
            newModule.setArchiveUri(in.getArchiveUri());
            application = Application.createApplication(appName, newModule);
        }
        if (handleRuntimeInfo) {
            archivist.setHandleRuntimeInfo(true);
            archivist.readRuntimeDeploymentDescriptor(in, descriptor);
        }
        archivist.validate(null);
        return application;
    }

    public static Application openArchive(File jarFile, PluggableArchivists pa, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        Archivist archivist = pa.getArchivistForArchive(jarFile);
        return ApplicationArchivist.openArchive(archivist, jarFile, handleRuntimeInfo);
    }

    public static Application openArchive(File jarFile, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        Archivist archivist = ArchivistFactory.getArchivistForArchive(jarFile);
        return ApplicationArchivist.openArchive(archivist, jarFile, handleRuntimeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getApplicationName(File jarFile) throws IOException {
        block8: {
            if (!jarFile.exists()) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionjarfiledoesn'texist", "{0} does not exist", new Object[]{jarFile}));
            }
            JarFile jar = null;
            try {
                jar = new JarFile(jarFile);
                ApplicationDeploymentDescriptorFile node = new ApplicationDeploymentDescriptorFile();
                node.setXMLValidation(false);
                ZipEntry deploymentEntry = jar.getEntry(node.getDeploymentDescriptorPath());
                if (deploymentEntry == null) break block8;
                try {
                    Application application = (Application)node.read(jar.getInputStream(deploymentEntry));
                    String string = application.getDisplayName();
                    return string;
                }
                catch (Exception pe) {
                    pe.printStackTrace();
                }
            }
            finally {
                if (jar != null) {
                    jar.close();
                }
            }
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        String fileName = args[0];
        try {
            Archivist archivist = ArchivistFactory.getArchivistForArchive(fileName);
            archivist.setHandleRuntimeInfo(true);
            archivist.setArchiveUri(fileName);
            archivist.setXMLValidation(true);
            archivist.setXMLValidationLevel("full");
            Application descriptor = ApplicationArchivist.openArchive(archivist, new File(fileName), true);
            if (args.length > 1 && args[1] != null) {
                archivist.write(args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

