/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.io.AppClientDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.AppClientRuntimeDDFile;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleContentValidator;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.io.IOException;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

public class AppClientArchivist
extends Archivist {
    ApplicationClientDescriptor descriptor = null;
    DeploymentDescriptorFile standardDD = new AppClientDeploymentDescriptorFile();

    public AppClientArchivist() {
        this.handleRuntimeInfo = true;
    }

    public ModuleType getModuleType() {
        return ModuleType.CAR;
    }

    public void setDescriptor(Descriptor descriptor) {
        if (descriptor instanceof ApplicationClientDescriptor) {
            this.descriptor = (ApplicationClientDescriptor)descriptor;
        } else {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.descriptorFailure", new Object[]{this});
        }
    }

    public DeploymentDescriptorFile getStandardDDFile() {
        return this.standardDD;
    }

    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new AppClientRuntimeDDFile();
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        this.descriptor.visit(new ApplicationValidator());
    }

    protected void postOpen(RootDeploymentDescriptor descriptor, AbstractArchive archive) throws IOException {
        super.postOpen(descriptor, archive);
        ApplicationClientDescriptor appClient = (ApplicationClientDescriptor)descriptor;
        ModuleContentValidator mdv = new ModuleContentValidator(archive);
        appClient.visit(mdv);
        Manifest m = archive.getManifest();
        appClient.setMainClassName(this.getMainClassName(m));
    }

    protected ModuleDescriptor addToArchive(ApplicationArchivist appArch, String externalDD) throws IOException, SAXParseException {
        ModuleDescriptor module = super.addToArchive(appArch, externalDD);
        ApplicationClientDescriptor acd = (ApplicationClientDescriptor)module.getDescriptor();
        if (module != null) {
            String mainClassName;
            AbstractArchive jarFile = this.abstractArchiveFactory.openArchive(this.getArchiveUri());
            Manifest jarManifest = jarFile.getManifest();
            if (jarManifest != null && (mainClassName = this.getMainClassName(jarManifest)) != null) {
                acd.setMainClassName(mainClassName);
            }
            jarFile.close();
        }
        return module;
    }

    protected void writeContents(AbstractArchive in, AbstractArchive out, Vector entriesToSkip) throws IOException {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        this.manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, MANIFEST_VERSION_VALUE);
        this.manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, ((ApplicationClientDescriptor)this.getDescriptor()).getMainClassName());
        super.writeContents(in, out, entriesToSkip);
    }

    private String getMainClassName(Manifest m) {
        if (m != null) {
            return m.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        }
        return null;
    }
}

