/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.enterprise.deploy.shared.ModuleType;

public class WebServicesDescriptor
extends RootDeploymentDescriptor {
    private BundleDescriptor bundleDesc;
    private Collection webServices = new HashSet();

    public void setBundleDescriptor(BundleDescriptor module) {
        this.bundleDesc = module;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.bundleDesc;
    }

    public boolean hasWebServices() {
        return !this.webServices.isEmpty();
    }

    public WebService getWebServiceByName(String webServiceName) {
        WebService webService = null;
        Iterator iter = this.webServices.iterator();
        while (iter.hasNext()) {
            WebService next = (WebService)iter.next();
            if (!next.getWebServiceName().equals(webServiceName)) continue;
            webService = next;
            break;
        }
        return webService;
    }

    public void addWebService(WebService descriptor) {
        descriptor.setWebServicesDescriptor(this);
        this.webServices.add(descriptor);
        super.changed();
    }

    public void removeWebService(WebService descriptor) {
        descriptor.setWebServicesDescriptor(null);
        this.webServices.remove(descriptor);
        super.changed();
    }

    public Collection getWebServices() {
        return new HashSet(this.webServices);
    }

    public WebServiceEndpoint getEndpointByName(String endpointName) {
        Iterator iter = this.getEndpoints().iterator();
        while (iter.hasNext()) {
            WebServiceEndpoint next = (WebServiceEndpoint)iter.next();
            if (!next.getEndpointName().equals(endpointName)) continue;
            return next;
        }
        return null;
    }

    public boolean hasEndpointsImplementedBy(EjbDescriptor ejb) {
        return !this.getEndpointsImplementedBy(ejb).isEmpty();
    }

    public Collection getEndpointsImplementedBy(EjbDescriptor ejb) {
        HashSet<WebServiceEndpoint> endpoints = new HashSet<WebServiceEndpoint>();
        if (ejb instanceof EjbSessionDescriptor) {
            Iterator iter = this.getEndpoints().iterator();
            while (iter.hasNext()) {
                WebServiceEndpoint next = (WebServiceEndpoint)iter.next();
                if (!next.implementedByEjbComponent(ejb)) continue;
                endpoints.add(next);
            }
        }
        return endpoints;
    }

    public boolean hasEndpointsImplementedBy(WebComponentDescriptor desc) {
        return !this.getEndpointsImplementedBy(desc).isEmpty();
    }

    public Collection getEndpointsImplementedBy(WebComponentDescriptor desc) {
        HashSet<WebServiceEndpoint> endpoints = new HashSet<WebServiceEndpoint>();
        Iterator iter = this.getEndpoints().iterator();
        while (iter.hasNext()) {
            WebServiceEndpoint next = (WebServiceEndpoint)iter.next();
            if (!next.implementedByWebComponent(desc)) continue;
            endpoints.add(next);
        }
        return endpoints;
    }

    public Collection getEndpoints() {
        HashSet allEndpoints = new HashSet();
        Iterator iter = this.webServices.iterator();
        while (iter.hasNext()) {
            WebService next = (WebService)iter.next();
            allEndpoints.addAll(next.getEndpoints());
        }
        return allEndpoints;
    }

    public String getModuleID() {
        return "";
    }

    public ModuleType getModuleType() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public boolean isApplication() {
        return false;
    }

    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        if (this.hasWebServices()) {
            Iterator itr = this.getWebServices().iterator();
            while (itr.hasNext()) {
                WebService aWebService = (WebService)itr.next();
                toStringBuffer.append("\n Web Service : ");
                aWebService.print(toStringBuffer);
            }
        }
    }
}

