/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.namespace.QName;

public class WebServiceEndpoint
extends Descriptor {
    public static final String TRANSPORT_NONE = "NONE";
    public static final String TRANSPORT_INTEGRAL = "INTEGRAL";
    public static final String TRANSPORT_CONFIDENTIAL = "CONFIDENTIAL";
    private static final String PUBLISHING_SUBCONTEXT = "__container$publishing$subctx";
    private String endpointName;
    private String serviceEndpointInterface;
    private QName wsdlPort;
    private String wsdlPortNamespacePrefix;
    private String ejbLink;
    private EjbDescriptor ejbComponentImpl;
    private String webComponentLink;
    private WebComponentDescriptor webComponentImpl;
    private LinkedList handlerChain;
    private WebService webService;
    private String endpointAddressUri;
    private String authMethod;
    private String transportGuarantee;
    private String serviceNamespaceUri;
    private String serviceLocalPart;
    private String servletImplClass;
    private String tieClassName;
    private MessageSecurityBindingDescriptor messageSecBindingDesc = null;

    public WebServiceEndpoint(WebServiceEndpoint other) {
        super(other);
        this.endpointName = other.endpointName;
        this.serviceEndpointInterface = other.serviceEndpointInterface;
        this.wsdlPort = other.wsdlPort;
        this.wsdlPortNamespacePrefix = other.wsdlPortNamespacePrefix;
        this.ejbLink = other.ejbLink;
        this.ejbComponentImpl = other.ejbComponentImpl;
        this.webComponentLink = other.webComponentLink;
        this.webComponentImpl = other.webComponentImpl;
        this.handlerChain = other.handlerChain;
        if (other.handlerChain != null) {
            this.handlerChain = new LinkedList();
            Iterator i = other.handlerChain.iterator();
            while (i.hasNext()) {
                WebServiceHandler wsh = (WebServiceHandler)i.next();
                this.handlerChain.addLast(new WebServiceHandler(wsh));
            }
        } else {
            this.handlerChain = null;
        }
        this.webService = other.webService;
        this.endpointAddressUri = other.endpointAddressUri;
        this.authMethod = other.authMethod;
        this.transportGuarantee = other.transportGuarantee;
        this.serviceNamespaceUri = other.serviceNamespaceUri;
        this.serviceLocalPart = other.serviceLocalPart;
        this.servletImplClass = other.servletImplClass;
        this.tieClassName = other.tieClassName;
    }

    public WebServiceEndpoint() {
        this.handlerChain = new LinkedList();
        this.authMethod = null;
        this.wsdlPort = null;
    }

    public void setWebService(WebService service) {
        this.webService = service;
        super.changed();
    }

    public WebService getWebService() {
        return this.webService;
    }

    public void setEndpointName(String name) {
        this.endpointName = name;
        super.changed();
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setServiceEndpointInterface(String endpointInterface) {
        this.serviceEndpointInterface = endpointInterface;
        super.changed();
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setWsdlPort(QName port, String prefix) {
        this.wsdlPort = port != null ? new QName(port.getNamespaceURI(), port.getLocalPart()) : null;
        this.wsdlPortNamespacePrefix = prefix;
        super.changed();
    }

    public void setWsdlPort(QName port) {
        this.wsdlPort = port != null ? new QName(port.getNamespaceURI(), port.getLocalPart()) : null;
        super.changed();
    }

    public String getWsdlPortNamespacePrefix() {
        return this.wsdlPortNamespacePrefix;
    }

    public boolean hasWsdlPortNamespacePrefix() {
        return this.wsdlPortNamespacePrefix != null;
    }

    public boolean hasWsdlPort() {
        return this.wsdlPort != null;
    }

    public QName getWsdlPort() {
        return this.wsdlPort != null ? new QName(this.wsdlPort.getNamespaceURI(), this.wsdlPort.getLocalPart()) : null;
    }

    public void setMessageSecurityBinding(MessageSecurityBindingDescriptor messageSecBindingDesc) {
        this.messageSecBindingDesc = messageSecBindingDesc;
    }

    public MessageSecurityBindingDescriptor getMessageSecurityBinding() {
        return this.messageSecBindingDesc;
    }

    public boolean resolveComponentLink() {
        WebBundleDescriptor webBundle;
        WebComponentDescriptor webComponent;
        boolean resolved = false;
        if (this.ejbLink != null) {
            EjbBundleDescriptor ejbBundle = this.getEjbBundle();
            if (ejbBundle.hasEjbByName(this.ejbLink)) {
                resolved = true;
                EjbDescriptor ejb = ejbBundle.getEjbByName(this.ejbLink);
                this.setEjbComponentImpl(ejb);
            }
        } else if (this.webComponentLink != null && (webComponent = (webBundle = this.getWebBundle()).getWebComponentByCanonicalName(this.webComponentLink)) != null) {
            resolved = true;
            this.setWebComponentImpl(webComponent);
        }
        super.changed();
        return resolved;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.getWebService().getBundleDescriptor();
    }

    private EjbBundleDescriptor getEjbBundle() {
        return (EjbBundleDescriptor)this.getBundleDescriptor();
    }

    private WebBundleDescriptor getWebBundle() {
        return (WebBundleDescriptor)this.getBundleDescriptor();
    }

    public boolean implementedByEjbComponent() {
        return this.ejbLink != null;
    }

    public boolean implementedByEjbComponent(EjbDescriptor ejb) {
        return this.ejbLink != null && this.ejbLink.equals(ejb.getName());
    }

    public boolean implementedByWebComponent() {
        return this.webComponentLink != null;
    }

    public boolean implementedByWebComponent(WebComponentDescriptor webComp) {
        return this.webComponentLink != null && this.webComponentLink.equals(webComp.getCanonicalName());
    }

    public String getLinkName() {
        String linkName = null;
        if (this.implementedByEjbComponent()) {
            linkName = this.ejbLink;
        } else if (this.implementedByWebComponent()) {
            linkName = this.webComponentLink;
        }
        return linkName;
    }

    public void setEjbLink(String link) {
        this.ejbLink = link;
        super.changed();
    }

    public String getEjbLink() {
        return this.ejbLink;
    }

    public void setEjbComponentImpl(EjbDescriptor ejbComponent) {
        this.webComponentImpl = null;
        this.webComponentLink = null;
        this.ejbLink = ejbComponent.getName();
        this.ejbComponentImpl = ejbComponent;
        super.changed();
    }

    public EjbDescriptor getEjbComponentImpl() {
        return this.ejbComponentImpl;
    }

    public void setWebComponentLink(String link) {
        this.webComponentLink = link;
        super.changed();
    }

    public String getWebComponentLink() {
        return this.webComponentLink;
    }

    public void setWebComponentImpl(WebComponentDescriptor webComponent) {
        this.ejbComponentImpl = null;
        this.ejbLink = null;
        this.webComponentLink = webComponent.getCanonicalName();
        this.webComponentImpl = webComponent;
        super.changed();
    }

    public WebComponentDescriptor getWebComponentImpl() {
        return this.webComponentImpl;
    }

    public boolean hasHandlers() {
        return this.handlerChain.size() > 0;
    }

    public void addHandler(WebServiceHandler handler) {
        this.handlerChain.addLast(handler);
        super.changed();
    }

    public void removeHandler(WebServiceHandler handler) {
        this.handlerChain.remove(handler);
        super.changed();
    }

    public void removeHandlerByName(String handlerName) {
        Iterator iter = this.handlerChain.iterator();
        while (iter.hasNext()) {
            WebServiceHandler next = (WebServiceHandler)iter.next();
            if (!next.getHandlerName().equals(handlerName)) continue;
            iter.remove();
            super.changed();
            break;
        }
    }

    public LinkedList getHandlerChain() {
        return this.handlerChain;
    }

    public boolean hasEndpointAddressUri() {
        return this.endpointAddressUri != null;
    }

    public void setEndpointAddressUri(String uri) {
        this.endpointAddressUri = uri;
        super.changed();
    }

    public String getEndpointAddressUri() {
        return this.endpointAddressUri;
    }

    public boolean isSecure() {
        return this.hasTransportGuarantee() && (this.transportGuarantee.equals(TRANSPORT_INTEGRAL) || this.transportGuarantee.equals(TRANSPORT_CONFIDENTIAL));
    }

    public URL composeEndpointAddress(URL root) throws MalformedURLException {
        String uri = null;
        if (this.implementedByWebComponent()) {
            WebBundleDescriptor webBundle;
            String contextRoot;
            if (this.endpointAddressUri == null) {
                this.updateServletEndpointRuntime();
            }
            if ((contextRoot = (webBundle = this.webComponentImpl.getWebBundleDescriptor()).getContextRoot()) != null) {
                if (!contextRoot.startsWith("/")) {
                    contextRoot = "/" + contextRoot;
                }
                uri = contextRoot + (this.endpointAddressUri.startsWith("/") ? this.endpointAddressUri : "/" + this.endpointAddressUri);
            }
        } else if (this.hasEndpointAddressUri()) {
            uri = this.endpointAddressUri.startsWith("/") ? this.endpointAddressUri : "/" + this.endpointAddressUri;
        }
        URL endpointAddressURL = new URL(root.getProtocol(), root.getHost(), root.getPort(), uri);
        return endpointAddressURL;
    }

    public URL composeFinalWsdlUrl(URL root) throws MalformedURLException {
        URL context = this.composeEndpointAddress(root);
        String mainFile = context.getFile() + "/" + PUBLISHING_SUBCONTEXT + "/" + this.webService.getWsdlFileUri();
        URL finalWsdlUrl = new URL(context.getProtocol(), context.getHost(), context.getPort(), mainFile);
        return finalWsdlUrl;
    }

    public String getPublishingUri() {
        String uri = this.endpointAddressUri.startsWith("/") ? this.endpointAddressUri.substring(1) : this.endpointAddressUri;
        return uri + "/" + PUBLISHING_SUBCONTEXT;
    }

    public boolean matchesEjbPublishRequest(String requestUriRaw, String query) {
        String requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
        boolean matches = false;
        if (query != null) {
            String toMatch = this.endpointAddressUri.charAt(0) == '/' ? this.endpointAddressUri.substring(1) : this.endpointAddressUri;
            matches = query.equalsIgnoreCase("WSDL") && requestUri.equals(toMatch);
        } else {
            String publishingUri = this.getPublishingUri() + "/";
            matches = requestUri.startsWith(publishingUri);
        }
        return matches;
    }

    public String getWsdlContentPath(String requestUri) {
        String uri = requestUri.charAt(0) == '/' ? requestUri.substring(1) : requestUri;
        String publishingUriRaw = this.getPublishingUri();
        String publishingRoot = null;
        if (this.implementedByWebComponent()) {
            WebBundleDescriptor webBundle = this.webComponentImpl.getWebBundleDescriptor();
            String contextRoot = webBundle.getContextRoot();
            if (contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
            publishingRoot = contextRoot + "/" + publishingUriRaw + "/";
        } else {
            publishingRoot = publishingUriRaw + "/";
        }
        String wsdlPath = uri.startsWith(publishingRoot) ? uri.substring(publishingRoot.length()) : null;
        return wsdlPath;
    }

    public void setAuthMethod(String authType) {
        this.authMethod = authType;
        super.changed();
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public boolean hasAuthMethod() {
        return this.authMethod != null;
    }

    public boolean hasBasicAuth() {
        return this.authMethod != null && this.authMethod.equals("BASIC");
    }

    public boolean hasClientCertAuth() {
        return this.authMethod != null && this.authMethod.equals("CLIENT_CERT");
    }

    public void setTransportGuarantee(String guarantee) {
        this.transportGuarantee = guarantee;
        super.changed();
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public boolean hasTransportGuarantee() {
        return this.transportGuarantee != null;
    }

    public void setServiceNamespaceUri(String uri) {
        this.serviceNamespaceUri = uri;
        super.changed();
    }

    public void setServiceLocalPart(String localpart) {
        this.serviceLocalPart = localpart;
        super.changed();
    }

    public boolean hasServiceName() {
        return this.serviceNamespaceUri != null && this.serviceLocalPart != null;
    }

    public QName getServiceName() {
        return this.hasServiceName() ? new QName(this.serviceNamespaceUri, this.serviceLocalPart) : null;
    }

    public void saveServletImplClass() {
        if (!this.implementedByWebComponent()) {
            throw new IllegalStateException("requires ejb");
        }
        this.servletImplClass = this.webComponentImpl.getWebComponentImplementation();
        super.changed();
    }

    public boolean hasServletImplClass() {
        return this.servletImplClass != null;
    }

    public void setServletImplClass(String implClass) {
        this.servletImplClass = implClass;
        super.changed();
    }

    public String getServletImplClass() {
        return this.servletImplClass;
    }

    public boolean hasTieClassName() {
        return this.tieClassName != null;
    }

    public void setTieClassName(String tieClass) {
        this.tieClassName = tieClass;
    }

    public String getTieClassName() {
        return this.tieClassName;
    }

    private void updateServletEndpointRuntime() {
        this.saveServletImplClass();
        WebComponentDescriptor webComp = this.getWebComponentImpl();
        WebBundleDescriptor bundle = webComp.getWebBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection endpoints = webServices.getEndpointsImplementedBy(webComp);
        if (endpoints.size() > 1) {
            String msg = "Servlet " + this.getWebComponentLink() + " implements " + endpoints.size() + " web service endpoints " + " but must only implement 1";
            throw new IllegalStateException(msg);
        }
        if (this.getEndpointAddressUri() == null) {
            Set urlPatterns = webComp.getUrlPatternsSet();
            if (urlPatterns.size() == 1) {
                String uri = (String)urlPatterns.iterator().next();
                this.setEndpointAddressUri(uri);
                Collection constraints = bundle.getSecurityConstraintsForUrlPattern(uri);
                Iterator i = constraints.iterator();
                while (i.hasNext()) {
                    SecurityConstraint next = (SecurityConstraint)i.next();
                    UserDataConstraint dataConstraint = next.getUserDataConstraint();
                    String guarantee = dataConstraint != null ? dataConstraint.getTransportGuarantee() : null;
                    if (guarantee == null || !guarantee.equals(TRANSPORT_INTEGRAL) && !guarantee.equals(TRANSPORT_CONFIDENTIAL)) continue;
                    this.setTransportGuarantee(guarantee);
                    break;
                }
            } else {
                String msg = "Endpoint " + this.getEndpointName() + " has not been assigned an endpoint address " + " and is associated with servlet " + webComp.getCanonicalName() + " , which has " + urlPatterns.size() + " url patterns";
                throw new IllegalStateException(msg);
            }
        }
    }

    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n endpoint name = ").append(this.endpointName);
        toStringBuffer.append("\n endpoint intf = ").append(this.serviceEndpointInterface);
        toStringBuffer.append("\n wsdl Port = ").append(this.wsdlPort);
        toStringBuffer.append("\n ejb Link = ").append(this.ejbLink);
        toStringBuffer.append("\n web Link = ").append(this.webComponentLink);
    }
}

