/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.SessionSynchronization;

public final class EjbSessionDescriptor
extends EjbDescriptor {
    private boolean isStateless = false;
    private int timeout = 0;
    public static final String TYPE = "Session";
    public static final String STATELESS = "Stateless";
    public static final String STATEFUL = "Stateful";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbSessionDescriptor.class);

    public EjbSessionDescriptor() {
    }

    public EjbSessionDescriptor(EjbDescriptor other) {
        super(other);
        if (other instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor session = (EjbSessionDescriptor)other;
            this.isStateless = session.isStateless;
            this.timeout = session.timeout;
        }
    }

    public String getType() {
        return TYPE;
    }

    public String getSessionType() {
        if (this.isStateless()) {
            return STATELESS;
        }
        return STATEFUL;
    }

    public void setSessionType(String sessionType) {
        if (STATELESS.equals(sessionType)) {
            this.setStateless(true);
            return;
        }
        if (STATEFUL.equals(sessionType)) {
            this.setStateless(false);
            return;
        }
        if (this.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionsessiontypenotlegaltype", "{0} is not a legal session type for session ejbs. The type must be {1} or {2}", new Object[]{sessionType, STATEFUL, STATELESS}));
        }
    }

    public void setType(String type) {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotsettypeofsessionbean", "Cannot set the type of a session bean"));
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTransactionType(String transactionType) {
        boolean isValidType;
        boolean bl = isValidType = BEAN_TRANSACTION_TYPE.equals(transactionType) || CONTAINER_TRANSACTION_TYPE.equals(transactionType);
        if (!isValidType) {
            if (this.isBoundsChecking()) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment..exceptointxtypenotlegaltype", "{0} is not a legal transaction type for session beans", new Object[]{transactionType}));
            }
        }
        this.transactionType = transactionType;
        super.setMethodContainerTransactions(new Hashtable());
        super.changed();
    }

    public boolean isStateless() {
        return this.isStateless;
    }

    public boolean isStateful() {
        return !this.isStateless();
    }

    public void setStateless(boolean isStateless) {
        this.isStateless = isStateless;
        super.changed();
    }

    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> txAttributes = super.getPossibleTransactionAttributes();
        if (this.isStateful()) {
            try {
                Class sessionSynchClass;
                EjbBundleDescriptor ejbBundle = this.getEjbBundleDescriptor();
                ClassLoader classLoader = ejbBundle.getClassLoader();
                Class<?> ejbClass = classLoader.loadClass(this.getEjbClassName());
                Class clazz = sessionSynchClass = SessionSynchronization.class;
                if (sessionSynchClass.isAssignableFrom(ejbClass)) {
                    txAttributes = new Vector<ContainerTransaction>();
                    txAttributes.add(new ContainerTransaction(ContainerTransaction.REQUIRED, ""));
                    txAttributes.add(new ContainerTransaction(ContainerTransaction.REQUIRES_NEW, ""));
                    txAttributes.add(new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return txAttributes;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Session descriptor");
        toStringBuffer.append("\n isStateless ").append(this.isStateless);
        super.print(toStringBuffer);
    }
}

